'\"
'\" Copyright (c) 1994 The Regents of the University of California.
'\" Copyright (c) 1994 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) fileevent.n 1.5 95/05/06 15:31:02
'\" 
.so man.macros
.TH fileevent n 4.0 Tk "Partially Converted Methods"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
fileevent \- Execute a callback when a file becomes readable or writable
.SH SYNOPSIS
\fI$widget\fR->\fBfileevent\fR(\fIfileId,\fB'readable'\fR?=>\fIcallback\fR?);
.br
\fI$widget\fR->\fBfileevent\fR(\fIfileId,\fB'writable'\fR?=>\fIcallback\fR?);
.BE

.SH DESCRIPTION
.PP
This method is used to create \fIfile event handlers\fR.
A file event handler is a binding between a file and a callback,
such that the callbackis invoked whenever the file becomes
readable or writable.
File event handlers are most commonly used to allow data to be
received from a child process on an event-driven basis, so that
the receiver can continue to interact with the user while
waiting for the data to arrive.
If an application invokes perl file operations such as \fB<>\fP or \fBread\fR when there
is no input data available, the process will block;  until the
input data arrives, it will not be able to service other events,
so it will appear to the user to ``freeze up''.
With \fBfileevent\fR, the process can tell when data is present
and only do operations when they won't block.
.PP
The \fIfileId\fR argument to \fBfileevent\fR refers to an open file;
any normal perl representaion of a file can be used such as
\fBSTDIN\fR, \fBSTDOUT\fR, \fBSTDERR\fR, or previously \fBopen\fPed
\fBFileHandle\fP objects or \fB\e*\fIname\fP "globs".
If the \fIcallback\fR argument is specified, then \fBfileevent\fR
creates a new event handler:  \fIcallback\fR will be evaluated
whenever the file becomes readable or writable (depending on the
argument to \fBfileevent\fR).
In this case \fBfileevent\fR returns an empty string.
The \fBreadable\fR and \fBwritable\fR event handlers for a file
are independent, and may be created and deleted separately.
However, there may be at most one \fBreadable\fR and one \fBwritable\fR
handler for a file at a given time.
If \fBfileevent\fR is called when the specified handler already
exists, the new callback replaces the old one.
.PP
If the \fIcallback\fR argument is not specified, \fBfileevent\fR
returns the current callback for \fIfileId\fR, or an empty string
if there is none.
If the \fIcallback\fR argument is specified as an empty string
then the event handler is deleted, so that no callback will be invoked.
.VS
The file event handler is \fInot\fP deleted automatically whenever
its file is closed as perl does not provide appropriate hooks, the perl/Tk 
code will detect some cases and delete the handler, but it is good practice
to explcitly use
.br
\fI$widget->\fBfileevent\fR(\fIfileId,\fB'readable'\fR => ''\fR);
.br 
to remove the handler when file is closed.
The file event handler \fIis\fP deleted automatically if the \fBMainWindow\fP
associated with \fI$widget\fP is destroyed.
.VE
.PP
A file is considered to be readable on same basis as the system's \fBselect()\fP
(or \fBpoll()\fP). This typically means that a "tty" has a whole line
readable but same is not true of "pipes" as pipe's buffer may fill before the 
newline. At least one character or an  end-of-file or error condition is present.
Perl's \fBsysread\fP with  specifying a single character is always safe, other
mechanisms are application dependant. It is important for \fIcallback\fR to check
for error and end-of-file conditions and handle them appropriately;  for example,
if there is no special check for end-of-file, an infinite loop may occur where
\fIcallback\fR reads no data, returns, and is immediately invoked again.
.PP
When using \fBfileevent\fR for event-driven I/O, it's important
to read the file in the same units that are written
from the other end. For example, suppose that you are using \fBfileevent\fR to
read data generated by a child process.
If the child process is writing whole lines, then you could use
\fB<>\fR (in a scalar context) to read those lines.
If the child generates one line at a time then you shouldn't
make more than a single call to \fB<>\fR or use it in an array context
in \fIcallback\fR: the first call may consume all the available data, so the second
call may block. You can also use \fBsysread\fR to read the child's data, but only
if you know how many bytes the child is writing at a time:  if
you try to read more bytes than the child has written, the
\fBsysread\fR call will block.
.PP
A file is considered to be writable on same basis as the system's \fBselect()\fP
(or \fBpoll()\fP). Typically this means at least one byte of data
can be written to the file without blocking, or an error condition
is present.
Write handlers are probably not very useful without additional support,
although \fBsyswrite\fP one character at a time is possible.
The \fBprint\fR command is dangerous since it can write more than
one byte at a time and may thus block.
What is really needed is a non-blocking form of write that
saves any data that couldn't be written to the file.
.PP
The callback for a file event is executed in same perl context that 
\fBMainLoop\fP was invoked.
If an error occurs while executing the callback then the
\fBTk::Error\fR mechanism is used to report the error.
In addition, the file event handler is deleted if it ever "\fBdie\fPs";
this is done in order to prevent infinite loops due to
buggy handlers.

.SH CAVEATS
.PP
Perl's \fBPOSIX\fP module provides a number of calls which would be useful
with \fBfilevent\fP, however core Tk code for \fBfilevent\fP assumes existance 
of stdio style \fBFILE *\fP which \fBPOSIX\fP module does not provide.
.PP
The \fBTk::IO\fP class attempts to address the several of the above issues by
providing a higher level interface - including using non-blocking read/write, and
some buffering. This level of interface is still evolving, but should stabilize
now perl's \fBFileHandle\fP objects have been cleaned up. A completely clean
interface is not possible without additional changes to perl internals.
.PP
As of Tcl/Tk4.1b1 the Tk mechanism used to implement \fBfileevent\fP migrates
into Tcl, and is changed slightly (to work better on non-UNIX machines).
The impact of these changes on future perl/Tk releases has not let been
established.

.SH CREDITS
.PP
\fBfileevent\fR is based on the \fBaddinput\fR command created
by Mark Diekhans.

.SH "SEE ALSO"
Tk::Error,
callbacks,
.br
perl documentation

.SH KEYWORDS
asynchronous I/O, event handler, file, readable, callback, writable
