mount_partition () {
	local device="$1"
	local status=0

	if [ -z "$Root" ]; then
		Root=`find_root`
		status=$?
	fi
	if [ $status -ne 0 -o -z "$Root" ]; then
		yesNoBox \
"You must mount your root filesystem (\"/\") before you can
mount any other filesystems. Would you like to mount
$1 as the root filesytem?" "Mount as the Root Filesystem?"
		if [ $? -ne 0 ]; then return 1; fi
		local mount_point=/
		local real_mount_point=/target
	else
		if [ ! -d /target/usr ]; then
			local prototype=/usr
		elif [ "`block_device /target/usr 2>/dev/null`" = $Root ]; then
			local prototype=/usr
		elif [ ! -d /target/var ]; then
			local prototype=/var
		elif [ "`block_device /target/var 2>/dev/null`" = $Root ]; then
			local prototype=/var
		elif [ ! -d /target/home ]; then
			local prototype=/home
		elif [ "`block_device /target/home 2>/dev/null`" = $Root ]; then
			local prototype=/home
		else
			local prototype=/
		fi
		local mount_point=`inputBox \
"Select the mount point for $device." "Select Mount Point" $prototype`
		if [ $status -ne 0 -o -z "$mount_point" ]; then return 1; fi
		local real_mount_point="/target$mount_point"
	fi

	echo -n $clear
	if [ ! -d $real_mount_point ]; then
		mkdir -p -m 755 $real_mount_point 2>/dev/null >/dev/null
		if [ $? -eq 0 ]; then
			chown root.sys $real_mount_point
		fi
	fi

	echo -n $clear
	mount $device $real_mount_point
	if [ $? -ne 0 -o ! -z "$output" ]; then
		write_it_down
		msgBox \
"Mount of $device on $mount_point failed
$output" "Problem"
		return 1
	fi
	if [ $mount_point = "/" ]; then
		Root=$device
	fi
	return 0
}
