write_boot_floppy ()
{
	local device="$1"
	echo $bold"Please wait while the boot floppy is created."$norm
	echo ""
	umount $device 2>/dev/null
	umount /floppy 2>/dev/null
	fdflush $device
	if [ $? -ne 0 ]; then return 1; fi;
	local size="`getfdprm $device`"
	if [ $? -ne 0 ]; then return 1; fi;
	size=`first $size`
	size=`math $size 2 div`
	echo "Formatting the floppy..."
	fdformat $device
	if [ $? -ne 0 ]; then return 1; fi;
	echo "Creating a filesystem on the floppy..."
	gunzip</target/usr/lib/syslinux/img""$size""k.gz >$device
	if [ $? -ne 0 ]; then return 1; fi;
	echo "Mounting..."
	mount -t msdos $device /floppy
	if [ $? -ne 0 ]; then return 1; fi;
	echo "Copying the operating system kernel..."
	cp /target/vmlinuz /floppy/linux
	if [ $? -ne 0 ]; then umount /floppy; return 1; fi;
	sync
	echo "Writing the configuration files..."
	cat >/floppy/syslinux.cfg << EOF
DISPLAY message.txt
TIMEOUT 40
PROMPT 1
DEFAULT linux root=$Root
APPEND ro
EOF
	if [ $? -ne 0 ]; then umount /floppy; return 1; fi;
	cat >/floppy/message.txt << EOF

Linux will be started automatically using the kernel on this floppy disk.
The root filesystem will be mounted from $Root .

When you start to type a command at the "boot: " prompt, the automatic
bootstrap process will stop. You may then type the name of the kernel to
use followed by any kernel options in the form option=value .

The kernel must be on the floppy disk in the first floppy drive. A kernel
file called "linux" was installed on this floppy when it was created. If you
wish to use a kernel on the hard disk, remove the floppy and press RESET.

EOF
	if [ $? -ne 0 ]; then umount /floppy; return 1; fi;
	echo "Done! Un-mounting the floppy"
	umount /floppy
	return 0
}

make_boot_floppy ()
{
	require_root
	if [ $? -ne 0 ]; then return 1; fi

	local device=/dev/fd0
	local designation=first

	if [ "`block_device / 2>/dev/null`" = /dev/fd0 ]; then
		yesNoBox \
"You are not using the RAM-disk, and thus the Installation Root
Disk in the first floppy drive can not be removed.

If your second floppy drive is the same size as the first one,
you can use it to write a boot floppy which you will place in
the first drive when you boot the system. Otherwise, you can
skip this step and use the Debian Installation Boot Disk to boot
your hard disk by typing \"linux root=$Root\" at the
\"boot: \" prompt, or you may be able to boot directly from the
hard disk.

Use the second floppy drive to create a boot floppy?" \
		"Use Second Floppy Drive?"
		if [ $? -ne 0 ]; then return 1; fi
		device=/dev/fd1
		designation=second
	fi
	msgBox \
"Please place a blank floppy disk in the $designation
floppy disk drive, and press ENTER." "Change Disk"
	if [ $? -ne 0 ]; then return 1; fi
	echo -n $clear
	write_boot_floppy $device
	if [ $? -ne 0 ]; then
		write_it_down
		msgBox \
"Creation of a boot floppy failed. Please make sure that
the floppy was not write-protected, and that you put it
in the $designation drive. Try another floppy if the
problem persists." "Problem"
		return 1
	fi
	CreatedBootFloppy=1
	return 0
}
