init_linux () {
	sync
	local partition=`select_not_mounted \
"Please select the partition to initialize as a
Linux \"EXT2\" filesystem." "Linux native"`
	if [ $? -ne 0 -o -z "$partition" ]; then return 1; fi
	yesNoBox \
"The system can scan the entire partition for un-readable disk
blocks and will mark any such bad blocks it finds so that they
will not be used. This requires that every block be read, and
thus could take a long time, but may save you trouble later.

Should the bad-block scan be performed on $partition?" \
	"Scan for Bad Blocks?"
	if [ $? -eq 0 ]; then
		local cflag="-c "
	elif [ $? -eq 1 ]; then
		local cflag=""
	else
		return 1
	fi
	yesNoBox \
"You have chosen to initialize $partition as a Linux \"EXT2\"
filesystem. This will permanently erase any data on this
disk partition. Are you sure you want to do this?" "Are You Sure?"
	if [ $? -ne 0 ]; then return 1; fi
	echo $clear$bold"Creating filesystem..."$norm
	echo ""
	mkfs.ext2 $cflag""$partition
	local status=$?
	if [ $status -ne 0 ]; then
		write_it_down
		msgBox \
"The filesystem was not created." "Problem"
		return 1
	fi
	mount_partition $partition
	return $status
}
