#!	/bin/sh

# Install the kernel from this boot floppy onto the root filesystem.
# Don't run LILO, so the hard disk won't be bootable until more is done.
# The commands used by this script are limited to the ones available on
# the root floppy.

set -e
umask 022

VERSION=--version--

extract="cpio --format=ustar --extract --unconditional"
if [ -x /bin/star -o -x /usr/bin/star ]; then
	extract="star"
fi

if [ ! -f linux -o ! -f sys_map.gz -o ! -f modules.tgz ]; then
	echo 	"Error: Change directory to the boot floppy before running this script."
	1>&2
	exit -1
fi

FLOPPY=`pwd`

if [ $# -gt 0 ]; then
	DESTDIR=$1
fi

if [ ! -d ${DESTDIR}/boot ]; then
	mkdir -m 2775 ${DESTDIR}/boot
fi
if [ ! -d ${DESTDIR}/lib/modules/${VERSION} ]; then
	mkdir -p -m 2775 ${DESTDIR}/lib/modules/${VERSION}
fi

cp linux ${DESTDIR}/boot/vmlinuz-${VERSION}
rdev -r ${DESTDIR}/boot/vmlinuz-${VERSION} 0
gunzip < sys_map.gz > ${DESTDIR}/boot/System.map-${VERSION}
if [ -f ${DESTDIR}/vmlinuz ]; then 
	rm -f ${DESTDIR}/vmlinuz.old
	mv -f ${DESTDIR}/vmlinuz ${DESTDIR}/vmlinuz.old
	rm -f ${DESTDIR}/vmlinuz
fi
(cd ${DESTDIR}; ln -s boot/vmlinuz-${VERSION} vmlinuz)
if [ -f ${DESTDIR}/System.map ]; then 
	rm -f ${DESTDIR}/System.old
	mv -f ${DESTDIR}/System.map ${DESTDIR}/System.old
	rm -f ${DESTDIR}/System.map
fi
(cd ${DESTDIR}; ln -s boot/System.map-${VERSION} System.map)
(cd ${DESTDIR}/; gunzip < ${FLOPPY}/modules.tgz | $extract)
(cd ${DESTDIR}/lib/modules; if [ ! -d current ]; then; \
 ln -s ${VERSION} current; fi)
(cd ${DESTDIR}; depmod -a)
sync
exit 0
