open Unix
open Protocol

external add_file_input : file_descr -> cbid -> unit
        =  "camltk_add_file_input"
external rem_file_input : file_descr -> unit
        =  "camltk_rem_file_input"
external add_file_output : file_descr -> cbid -> unit
        =  "camltk_add_file_output"
external rem_file_output : file_descr -> unit
        =  "camltk_rem_file_output"

(* File input handlers *)

let fd_table = Hashtbl.create 37 (* Avoid space leak in callback table *)

let add_fileinput fd f =
  let id = new_function_id () in
    Hashtblc.add callback_naming_table id (fun _ -> f());
    Hashtbl.add fd_table (fd, 'r') id;
    add_file_input fd id

let remove_fileinput fd =
  begin try
    let id = Hashtbl.find fd_table (fd, 'r') in
      clear_callback id
  with
    Not_found -> ()
  end;
  Hashtbl.remove fd_table (fd, 'r');
  rem_file_input fd

let add_fileoutput fd f =
  let id = new_function_id () in
    Hashtblc.add callback_naming_table id (fun _ -> f());
    Hashtbl.add fd_table (fd, 'w') id;
    add_file_output fd id

let remove_fileoutput fd =
  begin try
    let id = Hashtbl.find fd_table (fd, 'w') in
      clear_callback id
  with
    Not_found -> ()
  end;
  Hashtbl.remove fd_table (fd, 'w');
  rem_file_output fd

