#include <tcl.h>
#include <tk.h>
#include <caml/mlvalues.h>
#include "camltk.h"

/* Parsing results */
value camltk_splitlist (v) /* ML */
     value v;
{
  int argc;
  char **argv;
  int result;

  if (!cltclinterp) tk_error("Tcl/Tk not initialised");
  /* argv is allocated by Tcl, to be freed by us */
  result = Tcl_SplitList(cltclinterp,String_val(v),&argc,&argv);
  switch(result) {
  case TCL_OK:
   { value res = copy_string_list(argc,argv);
     free((char *)argv);	/* only one large block was allocated */
     return res;
   }
  case TCL_ERROR:
  default:
    tk_error(cltclinterp->result);
  }
}

