/*

Name:
UI.C

Description:
Curses parser for Tracker-like controls - bare linux (unix?) version.
Shamelessly adapted from tracker v4.3 by Marc Espie

By using the UI_... return style, an X equivalent should drop in as a
replacement. 

Steve McIntyre <stevem@chiark.greenend.org.uk>

HISTORY
=======

v1.00 (06/12/96) - first "versioned" version
v1.01 (06/12/96) - changed email address to stevem@chiark

*/
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>

#ifdef NCURSES
#include <ncurses/ncurses.h>
#else
#include <curses.h>
#endif

#include "mikmod.h"
#include "ui.h"

int current_pattern;
int count_pattern, count_song;

int may_getchar()
{
	int buffer;
	buffer=getch();
	if (buffer != ERR)
		return buffer;
	else
		return EOF;   
}

int get_ui()
   {
   ui_result = 2;
   switch(may_getchar())
      {
   case 'n':
   case 'N':
   case KEY_DOWN:
   case 13: /*carriage return*/
      ui_result = UI_NEXT_SONG;
      play_current=0;
      break;
   case 'p':
   case 'P':
   case KEY_UP:
      ui_result = UI_PREVIOUS_SONG;
      break;
   case 'x':
   case 'e':
   case 'q':
   case 'X':
   case 'E':
   case 'Q':
      ui_result = UI_QUIT;
      break;
   case '.':
	ui_result= UI_SPEED_UP;
	break;
   case ',':
	ui_result= UI_SLOW_DOWN;
	break;
   case '/':
	ui_result= UI_NORMAL_SPEED;
	break;
   case '+':
	ui_result= UI_VOL_UP;
	break;
   case '-':
	ui_result= UI_VOL_DOWN;
	break;
   case '*':
	ui_result= UI_NORMAL_VOL;
	break;
   case '>':
   case KEY_RIGHT:
      ui_result = UI_JUMP_TO_NEXT_PATTERN;
      break;
   case '<':
   case KEY_LEFT:
      ui_result = UI_JUMP_TO_PREV_PATTERN;
      break;
   case ' ':
      ui_result = UI_PAUSE;
      break;
   case 'd':
   case 'D':
      ui_result = UI_MARK_DELETED;
      break;
   case 'y':
   case 'Y':
      ui_result = UI_DELETE_MARKED;
      break;
   case '1':
      ui_result = UI_SELECT_MONO;
      break;
   case '2':
      ui_result = UI_SELECT_STEREO;
      break;
   case 'i':
      ui_result = UI_SELECT_INTERP;
      break;
   case 'o':
      ui_result = UI_SELECT_NONINTERP;
      break;
   case '8':
      ui_result = UI_SELECT_8BIT;
      break;
   case '9':
      ui_result = UI_SELECT_16BIT;
      break;
   default:
      break;
      }
   return ui_result;
   }

