/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** idDeclList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "basic.h"

idDeclList
  idDeclList_singleton (/*@only@*/ idDecl e)
{
  idDeclList s = (idDeclList) dmalloc (sizeof (*s));
  
  s->nelements = 1;
  s->nspace = idDeclListBASESIZE - 1; 
  s->elements = (idDecl *) dmalloc (sizeof (*s->elements) * idDeclListBASESIZE);
  s->elements[0] = e;
  return (s);
}

static void
idDeclList_grow (idDeclList s)
{
  int i;
  idDecl *newelements;
  
  s->nspace = idDeclListBASESIZE + s->nspace; 
  newelements = (idDecl *) dmalloc (sizeof (*newelements) 
				    * (s->nelements + idDeclListBASESIZE));


  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i]; 
    }
  
  sfree (s->elements); 
  s->elements = newelements;
}

idDeclList idDeclList_add (idDeclList s, /*@only@*/ idDecl el)
{
  if (s->nspace <= 0)
    idDeclList_grow (s);
  
  s->nspace--;
  s->elements[s->nelements] = el;
  s->nelements++;

  return s;
}

/*@only@*/ cstring
idDeclList_unparse (idDeclList s)
{
   int i;
   cstring st = cstring_makeLiteral ("[");

   for (i = 0; i < s->nelements; i++)
     {
       if (i == 0)
	 {
	   st = message ("%q %q", st, idDecl_unparse (s->elements[i]));
	 }
       else
	 st = message ("%q, %q", st, idDecl_unparse (s->elements[i]));
     }
   
   st = message ("%q ]", st);
   return st;
}

void
idDeclList_free (idDeclList s)
{
  int i;
  for (i = 0; i < s->nelements; i++)
    {
      idDecl_free (s->elements[i]);
    }
  
  sfree (s->elements);
  sfree (s);
}
