/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** scanline.h
** 
**	The header files
**	    lsl.h
**	    string.h
**	    scan.h
**	must be included prior to including
**	    scanline.h
**	
**  MODIFICATION HISTORY:
**
**  X0.1-1	GAF	90.11.08	Created from LSL version
**  X0.1-2	JPW	91.05.03	Add LSLReportCommentTokens.
**  X0.1-3	JPW	91.06.26	Update copyright notice.
**  3.2   ymtan 92.11.14  conditionalize defn of types, needed for
**                        merging scanline.h and lclscanline.h
**                        Hence added SLASHCHAR (from LSL's scanline.h). 
**  2.4     ymtan  93.03.16  -- adapted original for release 2.4
**  Version Who    yy.mm.dd  -- did what?
*/

# ifndef LCLSCANLINE_H
# define LCLSCANLINE_H

extern void LCLScanLine (char *line) /*@modifies internalState, line@*/ ;
/*@exposed@*/ ltoken LCLScanEofToken (void) /*@*/ ;
extern void LCLReportEolTokens (bool setting) /*@modifies internalState@*/ ;

extern void LCLScanLineInit(void) /*@modifies internalState@*/ ;
extern void LCLScanLineReset(void) /*@modifies internalState@*/ ;
extern void LCLScanLineCleanup(void) /*@modifies internalState@*/ ;

extern charCode LCLScanCharClass (char c) /*@*/ ;
# define LCLScanCharClass(c) (LCLcharClass[(int)(c)].code)

extern bool LCLIsEndComment(char c) /*@*/ ;
# define LCLIsEndComment(c)  (LCLcharClass[(int)(c)].endCommentChar)

extern void LCLSetCharClass(char c, charCode cod) 
   /*@modifies internalState@*/ ;
# define LCLSetCharClass(c, cod) \
         (LCLcharClass[(int)(c)].code = (cod))

extern void LCLSetEndCommentChar(char c, bool flag)
   /*@modifies internalState@*/ ;
# define LCLSetEndCommentChar(c, flag) \
         (LCLcharClass[(int)(c)].endCommentChar = (flag))

extern charClassData LCLcharClass[LASTCHAR + 1];

# else
# error "Multiple include"
# endif





