/*
 * Copyright (c) 1993-1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * The Java source code is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You shall
 * not disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.

 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
/*
 * @(#)monitor_cache.h	1.16 96/02/07
 *
 */

/*
 * Monitor cache definitions
 */

#ifndef _MONITOR_CACHE_H_
#define _MONITOR_CACHE_H_

#include "monitor.h"		/* For SYS_TIMEOUT_INFINITY */

extern sys_mon_t *_moncache_lock;
#define CACHE_LOCK_INIT() monitorRegister(_moncache_lock, "Monitor cache lock");
#define CACHE_LOCK()	  sysMonitorEnter(_moncache_lock)
#define CACHE_NOTIFY()	  sysMonitorNotify(_moncache_lock)
#define CACHE_WAIT()	  sysMonitorWait(_moncache_lock, TIMEOUT_INFINITY)
#define CACHE_LOCKED()	  sysMonitorEntered(_moncache_lock)
#define CACHE_UNLOCK()	  sysMonitorExit(_moncache_lock)

/*
 * External routines.
 */
monitor_t *lookupMonitor(unsigned int);
monitor_t *createMonitor(unsigned int);
void monitorDestroy(monitor_t *, unsigned int);
void monitorEnumerate(void (*)(monitor_t *, void *), void *);
void monitorEnumerate_unlocked(void (*)(monitor_t *, void *), void *);

#endif /* !_MONITOR_CACHE_H_ */
