/*
 * defines for the error and message code.
 *
 * Copyright 1995 by Gray Watson
 *
 * This file is part of the dmalloc package.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * NON-COMMERCIAL purpose and without fee is hereby granted, provided
 * that the above copyright notice and this permission notice appear
 * in all copies, and that the name of Gray Watson not be used in
 * advertising or publicity pertaining to distribution of the document
 * or software without specific, written prior permission.
 *
 * Please see the PERMISSIONS file or contact the author for information
 * about commercial licenses.
 *
 * Gray Watson makes no representations about the suitability of the
 * software described herein for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * The author may be contacted at gray.watson@letters.com
 *
 * $Id: error.h,v 1.28 1995/08/30 18:06:56 gray Exp $
 */

#ifndef __ERROR_H__
#define __ERROR_H__

#include <stdarg.h>				/* for ... */

#include "conf.h"				/* up here for _INCLUDE */

/* for timeval type -- see conf.h */
#if STORE_TIMEVAL
#ifdef TIMEVAL_INCLUDE
#include TIMEVAL_INCLUDE
#endif
#endif

#include "dmalloc_loc.h"			/* for IMPORT */

/*<<<<<<<<<<  The below prototypes are auto-generated by fillproto */

/* global debug flags that are set my DMALLOC_DEBUG environ variable */
IMPORT	long		_dmalloc_flags;

/* global iteration counter for activities */
IMPORT	unsigned long	_dmalloc_iterc;

/* overhead information storing when the library started up for elapsed time */
#if STORE_TIMEVAL
IMPORT	struct timeval	_dmalloc_start;
#else
IMPORT	long		_dmalloc_start;
#endif

/* global flag which indicates when we are aborting */
IMPORT	char		_dmalloc_aborting;

/*
 * print the time into local buffer which is returned
 */
#if STORE_TIMEVAL
IMPORT	char	*_dmalloc_ptime(const struct timeval * timevalp,
				const char elapsed);
#else
IMPORT	char	*_dmalloc_ptime(const long * timep,
				const char elapsed);
#endif

/*
 * message writer with printf like arguments
 */
IMPORT	void	_dmalloc_message(const char * format, ...);

/*
 * kill the program because of an internal malloc error
 */
IMPORT	void	_dmalloc_die(const char silent);

/*
 * handler of error codes from procedure FUNC.  the procedure should
 * have set the errno already.
 */
IMPORT	void	dmalloc_error(const char * func);

/*<<<<<<<<<<   This is end of the auto-generated output from fillproto. */

#endif /* ! __ERROR_H__ */
