;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Type/coercion.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec 27 18:43:04 1994                          */
;*    Last change :  Fri Dec  8 09:38:40 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The coercion management                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module type_coercion
   (include "Type/type.sch"
	    "Tools/trace.sch")
   (import  tools_error
	    tools_shape
	    engine_param)
   (export  (add-coercion!    <type> <type> <symbol*> <symbol*>)
	    (get-aliased-type <type>)
	    (find-coercer     <type> <type>)))

;*---------------------------------------------------------------------*/
;*    get-aliased-type ...                                             */
;*---------------------------------------------------------------------*/
(define (get-aliased-type type)
   (let loop ((type type))
      (if (type? (type-alias type))
	  (loop (type-alias type))
	  type)))
			  
;*---------------------------------------------------------------------*/
;*    find-coercer ...                                                 */
;*    -------------------------------------------------------------    */
;*    We look for the coercion between `from' and `to'.                */
;*---------------------------------------------------------------------*/
(define (find-coercer from to)
   (Trace (type loop init)
	  "find-coercer: " (shape from) " " (shape to) #\Newline)
   [assert check (from to) (and (type? from) (type? to))]
   (let ((from (get-aliased-type from))
	 (to   (get-aliased-type to)))
      (let loop ((coercer (type-coerce-to from)))
	 (cond
	    ((null? coercer)
	     #f)
	    ((eq? (coercer-to (car coercer)) to)
	     (car coercer))
	    (else
	     (loop (cdr coercer)))))))

;*---------------------------------------------------------------------*/
;*    check-coercion? ...                                              */
;*---------------------------------------------------------------------*/
(define (check-coercion? from to check coerce)
   (and (type? from)
	(type? to)
	(let loop ((check check))
	   (cond
	      ((null? check)
	       (let loop ((coerce coerce))
		  (cond
		     ((null? coerce)
		      #t)
		     ((match-case (car coerce)
			 ((? symbol?)
			  #f)
			 (()
			  #f)
			 ((lambda (?-) . ?-)
			  #f)
			 (else
			  #t))
		      #f)
		     (else
		      (loop (cdr coerce))))))
	      ((and (not (symbol? (car check))) (not (null? (car check))))
	       #f)
	      (else
	       (loop (cdr check)))))))

;*---------------------------------------------------------------------*/
;*    add-coercion! ...                                                */
;*    -------------------------------------------------------------    */
;*    Coercion inherit from parent to children and children to         */
;*    parent.                                                          */
;*    -------------------------------------------------------------    */
;*    Here is an example, supose we have the following type hierachy   */
;*                                                                     */
;*       obj              foreign                                      */
;*        ^                  ^                                         */
;*        |                  |                                         */
;*        |                  |                                         */
;*      bint                int                                        */
;*                                                                     */
;*    Now, we add the coercion between `bint' and `int'. Fisrt, we add */
;*    the simple coercion.                                             */
;*                                                                     */
;*       obj              foreign                                      */
;*        ^                  ^                                         */
;*        |                  |                                         */
;*        |                  |                                         */
;*      bint -------------> int                                        */
;*                                                                     */
;*    Then, we add parent coercion.                                    */
;*                                                                     */
;*       obj -----   -----> foreign                                    */
;*        ^       \ /        ^                                         */
;*        |        X         |                                         */
;*        |  _____/ \_____>  |                                         */
;*      bint -------------> int                                        */
;*                                                                     */
;*    Adding `obj' to `int' will not build the between                 */
;*    `obj' and `foreign' since this link already exists.              */
;*---------------------------------------------------------------------*/
(define (add-coercion! from to check coerce)
   (trace (type loop) "add-coercion!: "
	  (shape from) " " (shape to) " "
	  (shape check) " " (shape coerce) #\Newline
	  "  parent(from): " (shape (type-parents from)) #\Newline
	  "  parent(to): " (shape (type-parents to)) #\Newline)
   [assert check (from to check coerce) (check-coercion? from to check coerce)]
   (if (null? check)
       (set! check '(())))
   (if (null? coerce)
       (set! coerce '(())))
   (let ((from (get-aliased-type from))
	 (to   (get-aliased-type to)))
      (if (coercer? (find-coercer from to))
	  (if (not *lib-mode*)
	      (warning "add-coercion!"
		       "Type coercion redefinition -- "
		       (shape (list from to check coerce))))
	  (begin
	     ;; we set the coercion between `from' and `to'
	     (let ((new (coercer from to check coerce)))
		(type-coerce-to-set! from (cons new (type-coerce-to from)))
		(type-coerce-from-set! to (cons new (type-coerce-from to))))
	     ;; we set the coercion between `from' and `to's parents'
	     (for-each
	      (lambda (parent)
		 (trace (type loop init)
			"   from->to's: " (shape parent) #\Newline)
		 (if (and (not (eq? from parent))
			  (not (eq? to parent))
			  (not (coercer? (find-coercer from parent))))
		     (let ((coercer-p (find-coercer to parent)))
			(if (not (coercer? coercer-p))
			    (user-error "Can't find coercion"
					(shape to)
					(shape parent))
			    (let ((check-p  (coercer-check-op coercer-p))
				  (coerce-p (coercer-coerce-op coercer-p)))
			       (add-coercion! from
					      parent
					      (append check check-p)
					      (append coerce coerce-p)))))))
	      (type-parents to))
	     ;; we set the coercion between `from's parent' and `to'
	     (for-each
	      (lambda (parent)
		 (trace (type loop init)
			"   from'->to: " (shape parent) #\Newline)
		 (if (and (not (eq? from parent))
			  (not (eq? to parent))
			  (not (coercer? (find-coercer parent to))))
		     (let ((coercer-p (find-coercer parent from)))
			(if (not (coercer? coercer-p))
			    (user-error "Can't find coercion"
					(shape parent)
					(shape from))
			    (let ((check-p  (coercer-check-op coercer-p))
				  (coerce-p (coercer-coerce-op coercer-p)))
			       (add-coercion! parent
					      to
					      (append check-p check)
					      (append coerce-p coerce)))))))
		       (type-parents from))))))
       
