;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Read/include.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 26 11:38:10 1994                          */
;*    Last change :  Tue Feb  6 18:04:40 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We read include files                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module read_include
   (include "Tools/location.sch")
   (import  main
	    tools_speek
	    tools_file
	    tools_error
	    tools_location
	    expand_eps)
   (export  (read-include            <string>)
	    (read-include-sans-macro <string>)))

;*---------------------------------------------------------------------*/
;*    read-include ...                                                 */
;*    name --> < import x include x sexp >                             */
;*---------------------------------------------------------------------*/
(define (read-include file)
   (verbose 2 "      [reading include file " file "]" #\Newline)
   (let ((fname (find-file/path file *load-path*)))
      (if (not (string? fname))
	  (user-error "read-include" "Can't find include file" file)
	  (let ((port (open-input-file fname)))
	     (if (not (input-port? port))
		 (user-error "read-include" "Can't open such file" file)
		 (let ((handler (lambda (escape proc mes obj)
				   (notify-error proc mes obj)
				   (close-input-port port)
				   (exit-bigloo -3))))
		    (try (let* ((first      (read port #t))
				(directives (if (and (pair? first)
						     (eq? (car first)
							  'directives))
						first
						'())))
			    (let loop ((r    (if (pair? directives)
						 (read port #t)
						 first))
				       (sexp '()))
			       (if (eof-object? r)
				   (begin
				      (close-input-port port)
				      (parse-include-directives
				       directives
				       (reverse! sexp)))
				   (match-case r
				      ((define-macro . ?-)
				       (add-macro-definition! r)
				       (loop (read port #t)
					     sexp))
				      ((define-expander . ?-)
				       (add-macro-definition! r)
				       (loop (read port #t)
					     sexp))
				      (else
				       (loop (read port #t)
					     (cons r sexp)))))))
			 handler)))))))

;*---------------------------------------------------------------------*/
;*    read-include-sans-macro ...                                      */
;*---------------------------------------------------------------------*/
(define (read-include-sans-macro file)
   (verbose 2 "      [reading include file " file "]" #\Newline)
   (let ((fname (find-file/path file *load-path*)))
      (if (not (string? fname))
	  (user-error "read-include" "Can't find include file" file)
	  (let ((port (open-input-file fname)))
	     (if (not (input-port? port))
		 (user-error "read-include" "Can't open such file" file)
		 (let ((handler (lambda (escape proc mes obj)
				   (notify-error proc mes obj)
				   (close-input-port port)
				   (exit-bigloo -3))))
		    (try (let* ((first      (read port #t))
				(directives (if (and (pair? first)
						     (eq? (car first)
							  'directives))
						first
						'())))
			    (close-input-port port)
			    (parse-include-directives directives '()))
			 handler)))))))

;*---------------------------------------------------------------------*/
;*    parse-include-directives ...                                     */
;*---------------------------------------------------------------------*/
(define (parse-include-directives directives sexp)
   (let loop ((dir      (if (null? directives)
			    '()
			    (cdr directives)))
	      (import  '())
	      (include '())
	      (foreign '())
	      (type    '())
	      (export  '())
	      (use     '())
	      (with    '()))
      (if (null? dir)
	  (vector import include sexp foreign type export use with)
	  (let ((r (car dir)))
	     (match-case r
		((import . ?rest)
		 (loop (cdr dir)
		       (append rest import)
		       include
		       foreign
		       type
		       export
		       use
		       with)) 
		((use . ?rest)
		 (loop (cdr dir)
		       import
		       include
		       foreign
		       type
		       export
		       (append rest use)
		       with))
		((force . ?rest)
		 (user-error "force" "no more supported" r)
		 (loop (cdr dir)
		       import
		       include
		       foreign
		       type
		       export
		       use
		       with))
		((include . ?file)
		 (loop (cdr dir)
		       import
		       (append file include)
		       foreign
		       type
		       export
		       use
		       with))
		((foreign . ?rest)
		 (loop (cdr dir)
		       import
		       include
		       (append foreign rest)
		       type
		       export
		       use
		       with))
		((type . ?rest)
		 (loop (cdr dir)
		       import
		       include
		       foreign
		       (append rest type)
		       export
		       use
		       with))
		((export . ?rest)
		 (loop (cdr dir)
		       import
		       include
		       foreign
		       type
		       (append rest export)
		       use
		       with))
		((with . ?rest)
		 (loop (cdr dir)
		       import
		       include
		       foreign
		       type
		       export
		       use
		       (append rest with))) 
		(else
		 (let ((loc (find-location (car dir))))
		    (user-error/location (if (loc? loc)
					     loc
					     (find-location dir))
					 "Parse error"
					 "Unknown directives"
					 (car dir)))))))))

	  
