;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../prgm/project/bigloo/comptime1.8/Integrate/loc2glo.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 15 17:29:48 1995                          */
;*    Last change :  Thu Jul 13 14:03:38 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We translate a local function definition into a global one.      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module integrate_local->global
   (include "Tools/trace.sch"
	    "Ast/ast.sch"
	    "Integrate/integrate.sch")
   (import  tools_shape
	    tools_args
	    ast_local
	    ast_global
	    type_cache
	    integrate_ast)
   (export  (local->global <local>)
	    (the-global    <local>)))

;*---------------------------------------------------------------------*/
;*    local->global ...                                                */
;*---------------------------------------------------------------------*/
(define (local->global local)
   [assert check (local) (local? local)]
   (trace (loop integrate) (local-shape local) #\: #\Newline)
   (let* ((global   (the-global local))
	  (kaptured (ifun-kaptured (local-info local)))
	  (add-args (map (lambda (old)
			    (let ((new (make-local-variable (local-name old)
							    (local-type old))))
			       (let ((key (local-key new)))
				  (struct-update! new old)
				  (local-key-set! new key))
			       new))
			 kaptured))
	  (old-fun  (local-value local))
	  (new-fun  (global-value global)))
      ;; we fill the new allocated function
      (function-inline?-set! new-fun #f)
      (function-arity-set! new-fun (+-arity (function-arity old-fun)
					    (length add-args)))
      (function-type-res-set! new-fun (function-type-res old-fun))
      (function-args-set! new-fun (append (reverse add-args)
					  (function-args old-fun)))
      (for-each (lambda (l)
		   (if (integrate-celled? l)
		       (local-type-set! l *obj*)))
		(function-args new-fun))
      (function-body-set! (global-value global)
			  (globalize! (function-body old-fun)
				      local
				      (map cons kaptured add-args)))
      (global-occurrence-set! global (local-occurrence local))
      global))

;*---------------------------------------------------------------------*/
;*    the-global ...                                                   */
;*---------------------------------------------------------------------*/
(define (the-global local)
   (let ((info (local-info local)))
      (if (global? (ifun-global info))
	  (ifun-global info)
	  (let ((global (declare-global-procedure!
			 'static
			 ;; we create an unused dummy module
			 (gensym 'local)
			 'procedure
			 (list (list (local-name local))))))
	     (ifun-global-set! info global)
	     global))))
