;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Integrate/kk.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Mar 14 17:30:55 1995                          */
;*    Last change :  Mon Apr 24 19:02:41 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The computation of K and K* properties.                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module integrate_kk
   (include "Tools/trace.sch"
	    "Ast/ast.sch"
	    "Integrate/integrate.sch")
   (import  tools_shape
	    integrate_a)
   (export  (K!  <a-set> <global>)
	    (K*! <a-set>)))

;*---------------------------------------------------------------------*/
;*    K! ...                                                           */
;*    -------------------------------------------------------------    */
;*    La facon de calculer la propriete K est la suivante:             */
;*       1- On parcours la liste des A pour trouver tous               */
;*          les appels non-terminaux.                                  */
;*       2- On re-parcours A pour s'occuper des terminaux sachant      */
;*          que l'application de la troisieme regle declenche          */
;*          le re-ajustage de K pour une et une seule fonction.        */
;*    -------------------------------------------------------------    */
;*    Les trois regles sont (Seniak, page 101):                        */
;*       1.  E(f)                 ==> K(f, bottom)                     */
;*       2.  A(f,g,k)             ==> k(g,k)                           */
;*       3.  A(f,g,tail) ^ k(f,k) ==> k(g,k)                           */
;*    -------------------------------------------------------------    */
;*    En fait, on calcule en meme temps que la propriete K, la         */
;*    premiere regle de la propriete K*                                */
;*---------------------------------------------------------------------*/
(define (K! A var)
   (trace (integrate loop) "K!..." #\Newline)
;*---------------------------------------------------------------------*/
;*    1.  on sait qu'une seule fonction est E car toutes les autres    */
;*    ont deja ete globalisees (par la globaliation).                  */
;*---------------------------------------------------------------------*/
   (let ((ifun (global-info var)))
      (ifun-K-set!  ifun (list 'bottom))
      (ifun-K*-set! ifun (list 'bottom))
      (K.2! A (K.1! A '()))))

;*---------------------------------------------------------------------*/
;*    K.1! ...                                                         */
;*---------------------------------------------------------------------*/
(define (K.1! A A-tail)
   (trace (integrate loop) "K.1!..." #\Newline)
   (if (null? A)
       A-tail
       (let* ((pr (car A))
	      (f  (car pr))
	      (g  (cadr pr))
	      (k  (caddr pr)))
	  (cond
	     ((eq? k 'tail)
	      (if (eq? f g)
		  (K.1! (cdr A) A-tail)
		  (K.1! (cdr A) (cons pr A-tail))))
	     (else
	      (let ((ifun (variable-info g)))
		 (if (memq k (ifun-K ifun))
		     (K.1! (cdr A) A-tail)
		     (begin
			(ifun-K-set!  ifun (cons k (ifun-K ifun)))
			(ifun-K*-set! ifun (cons k (ifun-K* ifun)))
			(K.1! (cdr A) A-tail)))))))))

;*---------------------------------------------------------------------*/
;*    K.2! ...                                                         */
;*---------------------------------------------------------------------*/
(define (K.2! A A-tail)
   (trace (integrate loop) "K.2!..." #\Newline)
   (let loop ((continue #t))
      (if (not continue)
	  A-tail
	  (let liip ((At       A-tail)
		     (continue #f))
	     (trace (integrate loop init) " liip: " (if (pair? At)
							(shape (car At))
							'())
		    "  " continue #\Newline)
	     (if (null? At)
		 (loop continue)
		 (let ((ifun (variable-info (car (car At)))))
		    (if (null? (ifun-K ifun))
			(liip (cdr At) continue)
			(let* ((g      (cadr (car At)))
			       (gifun  (variable-info g)))
			   (let laap ((Ks       (ifun-K ifun))
				      (continue continue))
			      (trace (integrate loop init) "  laap: "
				     (if (pair? Ks) (shape (car Ks)) '())
				     "  " continue #\Newline)
			      (if (null? Ks)
				  (liip (cdr At) continue)
				  (let ((k (car Ks)))
				     (if (memq k (ifun-K gifun))
					 (laap (cdr Ks) continue)
					 (begin
					    (ifun-K-set! gifun
							 (cons k (ifun-K
								  gifun)))
					    (ifun-K*-set! gifun
							  (cons k (ifun-K*
								   gifun)))
					    (laap (cdr Ks) #t))))))))))))))


;*---------------------------------------------------------------------*/
;*    K*! ...                                                          */
;*    -------------------------------------------------------------    */
;*    Les regles qui definissent la propriete K* sont:                 */
;*       1. K(f,g)                ==> K*(f,g)                          */
;*       2. A(f,g,tail) ^ K*(g,k) ==> K*(f,k)                          */
;*    Pour trouver des informations plus precises, se referer a la     */
;*    these Nitsan Seniak, page 102.                                   */
;*    -------------------------------------------------------------    */
;*    On a ete un tout petit peu malin car la premiere regle a deja    */
;*    ete traite lors du calcul de K.                                  */
;*---------------------------------------------------------------------*/
(define (K*! A-tail)
   (trace (integrate loop) "K*!..." #\Newline)
   (let loop ((continue #t))
      (if (not continue)
	  (trace-K)
	  (let liip ((At       A-tail)
		     (continue #f))
	     (if (null? At)
		 (loop continue)
		 (let ((ifun (variable-info (cadr (car At)))))
		    (if (null? (ifun-K* ifun))
			(loop continue)
			(let laap ((Ks       (ifun-K* ifun))
				   (continue continue))
			   (if (null? Ks)
			       (liip (cdr At) continue)
			       (let* ((f      (car (car At)))
				      (fifun  (variable-info f))
				      (k      (car Ks)))
				  (if (memq k (ifun-K* fifun))
				      (laap (cdr Ks) continue)
				      (begin
					 (ifun-K*-set! fifun
						       (cons k (ifun-K*
								fifun)))
					 (laap (cdr Ks) #t)))))))))))))

;*---------------------------------------------------------------------*/
;*    trace-K ...                                                      */
;*---------------------------------------------------------------------*/
(define (trace-K)
   (when-trace '(integrate loop)
	       (lambda ()
		  (fprint *trace-port* "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~")
		  (for-each (lambda (p)
			       (let ((ifun (variable-info p)))
				  (fprint *trace-port*
					  " --> " (shape p) #\: #\Newline
					  "   K : " (shape (ifun-K ifun))
					  #\Newline
					  "   K*: " (shape (ifun-K* ifun))
					  #\Newline)))
			    *phi*)
		  (fprint *trace-port* "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"))))


		       
		    

	     
	
