;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Integrate/a.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Mar 14 10:52:56 1995                          */
;*    Last change :  Wed Oct 11 11:37:29 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The computation of the A relation.
;*    -------------------------------------------------------------    */
;*    We don't have problem with `celled' because such variables       */
;*    are now set as only readed (which is a great idea :-).           */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module integrate_a
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Integrate/integrate.sch")
   (import  tools_shape
	    ast_dump
	    integrate_tools)
   (export  (A <global> <ast>)
	    *phi*))

;*---------------------------------------------------------------------*/
;*    *phi* ...                                                        */
;*---------------------------------------------------------------------*/
(define *phi* #unspecified)

;*---------------------------------------------------------------------*/
;*    A ...                                                            */
;*    -------------------------------------------------------------    */
;*    We compute the A property (see Seniak's thesis) and for          */
;*    each function, we compute the set of its free variables.         */
;*---------------------------------------------------------------------*/
(define (A global ast)
   ;; the setups
   (set! *phi*  (list global))
   (set! *kont* 0)
   (initialize-fun! global global)
   ;; we start the A computation.
   (let ((A (let loop ((ast   ast)     ;; ast      : the ast to scan
		       (host  global)  ;; variable : the host function
		       (k     'tail)   ;; k        : the continuation
		       (A     '()))    ;; A-set    : the result
	       (ast-case ast
		  ((atom)
		   A)
		  ((kwote)
		   A)
		  ((var)
		   A)
		  ((prag-ma)
		   (let liip ((asts (prag-ma-values ast))
			      (A    A))
		      (if (null? asts)
			  A
			  (liip (cdr asts)
				(loop (car asts)
				      host
				      (get-new-kont)
				      A)))))
		  ((make-box)
		   (loop (make-box-value ast)
			 host
			 (get-new-kont)
			 A))
		  ((box-ref)
		   A)
		  ((box-set!)
		   (loop (box-set!-value ast)
			 host
			 (get-new-kont)
			 A))
		  ((fail)
		   (loop (fail-proc ast)
			 host
			 (get-new-kont)
			 (loop (fail-msg ast)
			       host
			       (get-new-kont)
			       (loop (fail-obj ast)
				     host
				     (get-new-kont)
				     A))))
		  ((sequence)
		   (let ((asts (sequence-exp ast)))
		      (if (null? asts)
			  A
			  (let liip ((asts asts)
				     (A    A))
			     (if (null? (cdr asts))
				 (loop (car asts) host k A)
				 (liip (cdr asts)
				       (loop (car asts)
					     host
					     (get-new-kont)
					     A)))))))
		  ((conditional)
		   (let ((A (loop (conditional-test ast)
				  host
				  (get-new-kont)
				  A)))
		      (loop (conditional-then ast)
			    host
			    k
			    (loop (conditional-else ast)
				  host
				  k
				  A))))
		  ((switch)
		   (let liip ((clauses (switch-clauses ast))
			      (A       (loop (switch-test ast)
					     host
					     (get-new-kont)
					     A)))
			 (if (null? clauses)
			     A
			     (liip (cdr clauses)
				   (loop (cdr (car clauses))
					 host
					 k
					 A)))))
		  ((setq)
		   (let ((var (var-variable (setq-var ast))))
		      (loop (setq-val ast) host (get-new-kont) A)))
		  ((let-var)
		   (let liip ((bindings (let-var-bindings ast))
			      (A        A))
		      (if (null? bindings)
			  (loop (let-var-body ast)
				host
				k
				A)
			  (let* ((binding (car bindings))
				 (var (car binding))
				 (val (cdr binding)))
			     ;; we set the `ivar' structure (with the owner)
			     (local-info-set! var (create-ivar))
			     (liip (cdr bindings)
				   (loop val
					 host
					 (get-new-kont)
					 A))))))
		  ((let-fun)
		   ;; we initialize all the local definitions
		   (for-each (lambda (f)
				(initialize-fun! f host)
				(set! *phi* (cons f *phi*)))
			     (let-fun-locals ast))
		   ;; now, we scan the locals definitions and the body
		   (let liip ((locals (let-fun-locals ast))
			      (A      A))
		      (if (null? locals)
			  (loop (let-fun-body ast)
				host
				k
				A)
			  (liip (cdr locals)
				(loop (function-body
				       (local-value (car locals)))
				      (car locals)
				      'tail
				      A)))))
		  ((set-ex-it)
		   (local-info-set! (var-variable (set-ex-it-exit ast))
				    (create-ivar))
		   ;; in order to be sure that `set-ex-it' handler
		   ;; are always globalized we simulate to two-non tail
		   ;; call to them if the handler is not detached
		   ;; (see globalize pass)
		   (let* ((exit (var-variable (set-ex-it-exit ast)))
			  (hdlg (return-handler (local-value exit))))
		      (if (not (return-detached (local-value exit)))
			  (let ((call-1 `(,hdlg ,hdlg ,(get-new-kont)))
				(call-2 `(,hdlg ,hdlg ,(get-new-kont))))
			     (loop (set-ex-it-body ast)
				   host
				   (get-new-kont)
				   (cons call-1 (cons call-2 A))))
			  A)))
		  ((jump-ex-it)
		   (loop (jump-ex-it-exit ast)
			 host
			 (get-new-kont)
			 (loop (jump-ex-it-value ast)
			       host
			       (get-new-kont)
			       A)))
		  ((fun)
		   (internal-error "a-graph"
				   "Illegal node (see Globalize)"
				   (ast->sexp ast)))
		  ((app-ly)
		   (loop (app-ly-fun ast)
			 host
			 (get-new-kont)
			 (loop (app-ly-value ast)
			       host
			       (get-new-kont)
			       A)))
		  ((funcall)
		   (loop (funcall-fun ast)
			 host
			 (get-new-kont)
			 (let liip ((args (funcall-actuals ast))
				    (A    A))
			    (if (null? args)
				A
				(liip (cdr args)
				      (loop (car args)
					    host
					    (get-new-kont)
					    A))))))
		  ((app)
		   (let ((callee (var-variable (app-fun ast))))
		      ;; we manage the actuals
		      (let liip ((args (app-actuals ast))
				 (A    A))
			 (if (null? args)
			     (cond
				((local? callee)
				 (cons `(,host ,callee ,k) A))
				(else
				 A))
			     (liip (cdr args)
				   (loop (car args)
					 host
					 (get-new-kont)
					 A))))))))))
      (trace-A A)
      A))

;*---------------------------------------------------------------------*/
;*    *kont* ...                                                       */
;*---------------------------------------------------------------------*/
(define *kont* #unspecified)

;*---------------------------------------------------------------------*/
;*    get-new-kont ...                                                 */
;*---------------------------------------------------------------------*/
(define (get-new-kont)
   (set! *kont* (+fx 1 *kont*))
   *kont*)

;*---------------------------------------------------------------------*/
;*    trace-A ...                                                      */
;*---------------------------------------------------------------------*/
(define (trace-A A)
   (when-trace '(integrate loop)
	       (lambda ()
		  (fprint *trace-port* "- - - - - - - - - - - - - - - - ")
		  (fprint *trace-port* "PHI: " (shape *phi*) #\newline)
		  (for-each (lambda (a) 
			       (fprint *trace-port*
				       "A( " (shape (car a)) ", "
				       (shape (cadr a)) ", "
				       (caddr a) " )"))
			    A)
		  (fprint *trace-port* "- - - - - - - - - - - - - - - - "))))
