;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Inline/variant.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jan 17 18:06:19 1995                          */
;*    Last change :  Wed Apr  3 17:04:22 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The computation of variant or non variant formals parameters.    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module inline_variant
      (include "Ast/node.sch"
	       "Tools/trace.sch"
	       "Inline/inline.sch")
      (import  inline_loop
	       ast_dump
	       tools_shape)
      (export  (set-variant! <variable> <ast>)))

;*---------------------------------------------------------------------*/
;*    set-variant! ...                                                 */
;*    -------------------------------------------------------------    */
;*    Variant information is store in the info slot using the          */
;*    `variant' structure.                                             */
;*---------------------------------------------------------------------*/
(define (set-variant! callee ast)
   (let ((fun (variable-value callee)))
      ;; all formals are supposed to be un-variant
      (for-each (lambda (f)
		   (local-info-set! f (variant #f)))
		(function-args fun)))
   ;; we scan the Ast to discover which are variant.
   ;; there is no need to speed up the ast walking since
   ;; these ast are very small (due to inlining predicate which
   ;; are false if the function is too large).
   (let loop ((ast ast))
      (ast-case ast
	 ((atom)
	  'done)
	 ((var)
	  'done)
	 ((kwote)
	  'done)
	 ((box-ref)
	  'done)
	 ((make-box)
	  (loop (make-box-value ast)))
	 ((box-set!)
	  (loop (box-set!-value ast)))
	 ((sequence)
	  (for-each loop (sequence-exp ast)))
	 ((setq)
	  (let ((var (var-variable (setq-var ast))))
	     (if (and (local? var) (Iinfo? (local-info var)))
		 (variant-variant?-set! var #t)))
	  (loop (setq-val ast)))
	 ((conditional)
	  (loop (conditional-test ast))
	  (loop (conditional-then ast))
	  (loop (conditional-else ast)))
	 ((fail)
	  (loop (fail-proc ast))
	  (loop (fail-msg ast))
	  (loop (fail-obj ast)))
	 ((let-fun)
	  (loop (let-fun-body ast))
	  (for-each (lambda (local)
		       (loop (function-body (local-value local))))
		    (let-fun-locals ast)))
	 ((let-var)
	  (loop (let-var-body ast))
	  (for-each (lambda (binding)
		       (loop (cdr binding)))
		    (let-var-bindings ast)))
	 ((app-ly)
	  (loop (app-ly-fun ast))
	  (loop (app-ly-value ast)))
	 ((app)
	  (if (recursion? callee ast)
	      (set-recursion-variant! callee ast)
	      (begin
		 (loop (app-fun ast))
		 (for-each loop (app-actuals ast)))))
	 ((funcall)
	  (loop (funcall-fun ast))
	  (for-each loop (funcall-actuals ast)))
	 ((fun)
	  (internal-error "do-set-recursive-call!"
			  "Illegal node (see `Bivaluation' pass)"
			  (ast->sexp ast)))
	 ((set-ex-it)
	  (loop (set-ex-it-body ast)))
	 ((jump-ex-it)
	  (loop (jump-ex-it-exit ast))
	  (loop (jump-ex-it-value ast)))
	 ((switch)
	  (loop (switch-test ast))
	  (for-each (lambda (clause)
		       (loop (cdr clause)))
		    (switch-clauses ast)))
	 ((prag-ma)
	  (for-each loop (prag-ma-values ast))
	  'done))))

;*---------------------------------------------------------------------*/
;*    set-recursion-variant! ...                                       */
;*---------------------------------------------------------------------*/
(define (set-recursion-variant! callee ast)
   (let ((va? (<fx (function-arity (variable-value callee)) 0)))
      (let loop ((actuals (app-actuals ast))
		 (formals (function-args (variable-value callee))))
	 (trace (loop inline) "set-recursion-variant!: "
		(shape actuals) "  " (shape formals) #\Newline)
	 (cond
	    ((null? formals)
	     'done)
	    ((and va? (null? (cdr formals)))
	     (variant-variant?-set! (local-info (car formals)) #t))
	    ((null? actuals)
	     (internal-error "set-recursion-variant!"
			     "Incorrect number of arguments"
			     (shape (var-variable callee))))
	    (else
	     (if (or (not (var? (car actuals)))
		     (not (eq? (car formals) (var-variable (car actuals)))))
		 (variant-variant?-set! (local-info (car formals)) #t))
	     (loop (cdr actuals) (cdr formals)))))))
