;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cgen/cgen.sch            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Mar 17 10:00:33 1995                          */
;*    Last change :  Wed Oct 11 11:44:02 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The structures used by the C production                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    cgen                                                             */
;*---------------------------------------------------------------------*/
(define-struct cgen
   label       ;; <label>  :: the label associated to the function
   cop         ;; <cop>    :: a pseudo-c code
   integrated) ;; <bool>   :: is the function already integrated ?

;*---------------------------------------------------------------------*/
;*    cop                                                              */
;*---------------------------------------------------------------------*/
(define-ast cop
   ;; `c-exp?' is true if a cop is a C expression and false otherwise.
   (c-exp?) 
   ;; the labels
   (define-node label
      name
      used?
      body)
   ;; goto
   (define-node goto
      label)
   ;; block
   (define-node block
      body)
   ;; return
   (define-node creturn
      value)
   ;; void
   (define-node void
      value)
   (define-node catom
      value)
   ;; cvar
   (define-node cvar
      variable)
   ;; cpragma
   (define-node cpragma
      string
      values)
   ;; csequence
   (define-node csequence
      exp)
   ;; nop
   (define-node nop)
   ;; stop
   (define-node stop
      value)
   ;; csetq
   (define-node csetq
      var
      val)
   ;; cif
   (define-node cif
      test
      then
      else)
   ;; branch
   (define-node branch
      test
      true 
      false
      end)
   ;; local-variable declaration
   (define-node local-var
      vars)
   ;; the computed application
   (define-node cfuncall
      fun
      actuals
      strength)
   ;; apply
   (define-node capply
      fun
      value)
   ;; the application
   (define-node capp
      fun
      actuals)
   ;; failure
   (define-node cfail
      proc
      msg
      obj)
   ;; switch
   (define-node cswitch
      test
      clauses)
   ;; make-box
   (define-node cmake-box
      value)
   ;; box-ref
   (define-node cbox-ref
      var)
   ;; box-set!
   (define-node cbox-set!
      var
      value)
   ;; set-ex-it
   (define-node cset-ex-it
      exit
      jump-value
      body)
   ;; jump-ex-it
   (define-node cjump-ex-it
      exit
      value)
   )
