;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/stack.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue May  2 18:06:40 1995                          */
;*    Last change :  Wed Oct 11 11:18:16 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The mapping of heap allocation to stack allocations.             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_stack
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Type/type.sch"
	    "Cfa/approx.sch"
	    "Cfa/stack.sch")
   (import  cfa_approx
	    cfa_cache
	    cfa_collect
	    cfa_dead
	    cfa_special
	    cfa_vector
	    ast_dump
	    ast_global
	    ast_sexp
	    ast_build
	    ast_global-definition
	    ast_global-mutation
	    ast_env
	    ast_pragma
	    engine_param
	    inline_inline
	    bivalue_walk
	    globalize_globalize
	    globalize_ast
	    tvector_declare
	    tvector_install
	    type_cache
	    type_env
	    tools_set
	    tools_shape
	    tools_speek)
   (export  (heap->stack!)
	    (mark-unstackable!        alloc)
	    (spread-unstackable/mark! alloc min max mark age)))

;*---------------------------------------------------------------------*/
;*    Stamp variables control                                          */
;*---------------------------------------------------------------------*/
(define *0-stamp*     -1)
(define *stack-stamp* *0-stamp*)
(define *mark*        *0-stamp*)

;*---------------------------------------------------------------------*/
;*    set-mark! ...                                                    */
;*---------------------------------------------------------------------*/
(define (set-mark! val)
   (set! *mark* val))

;*---------------------------------------------------------------------*/
;*    inc-mark! ...                                                    */
;*---------------------------------------------------------------------*/
(define (inc-mark!)
   (set! *mark* (+fx 1 *mark*)))

;*---------------------------------------------------------------------*/
;*    set-default-sinfo ...                                            */
;*    -------------------------------------------------------------    */
;*    We look at the approximation. The value of stackable? is         */
;*    the same as the value of exported?.                              */
;*---------------------------------------------------------------------*/
(define (set-default-sinfo alloc)
   (trace stack "set-default-sinfo: " (ast->sexp alloc) " ... ")
   (let* ((approx (get-approx alloc))
	  (sinfo  (sinfo *0-stamp* *0-stamp* (not (approx-exported? approx)))))
      (app-stack-info-set! alloc sinfo)
      (trace stack (approx-shape (get-approx alloc)) #\Newline)
      sinfo))

;*---------------------------------------------------------------------*/
;*    mark-stamp! ...                                                  */
;*---------------------------------------------------------------------*/
(define (mark-stamp! alloc stamp)
   (trace (stack loop) "mark-stamp!: " (ast->sexp alloc) " [" stamp #\]
	  #\Newline)
   (let* ((sinfo (app-stack-info alloc)))
      (sinfo-stamp-set! sinfo stamp)
      #unspecified))

;*---------------------------------------------------------------------*/
;*    mark-unstackable! ...                                            */
;*---------------------------------------------------------------------*/
(define (mark-unstackable! alloc)
   (trace (stack loop) "mark-unstackable!: " (ast->sexp alloc) #\Newline)
   (let ((sinfo (app-stack-info alloc)))
      (sinfo-stackable?-set! sinfo #f)
      #unspecified))

;*---------------------------------------------------------------------*/
;*    spread-unstackable/mark! ...                                     */
;*---------------------------------------------------------------------*/
(define (spread-unstackable/mark! alloc min max mark age)
   [assert check (alloc) (app? alloc)]
   (trace (stack loop) "spread-unstackable/mark!: " (ast->sexp alloc))
   (let ((sinfo (app-stack-info alloc)))
      ;; is the allocation already marked ? 
      (if (=fx (sinfo-mark sinfo) mark)
	  (begin
	     (trace (stack loop) " already marked" #\Newline)
	     #unspecified)
	  (let* ((var      (var-variable (app-fun alloc)))
		 (val      (global-value var))
		 (iforeign (cond
			      ((function? val)
			       (function-cfa-info val))
			      ((ffunction? val)
			       (ffunction-cfa-info val))
			      (else
			       (internal-error "spread-unstackable!"
					       "Illegal function"
					       (ast->sexp alloc))))))
	     (trace (stack loop)
		    "  *stack-stamp*: " *stack-stamp* " "
		    "  astamp: " (sinfo-stamp sinfo)
		    " min: " min "  max: " max
		    "  age: " age "  mark: " mark
		    #\Newline)
	     ;; we mark the allocation
	     (sinfo-mark-set! sinfo mark)
	     ((ispecial-spread-unstackable! iforeign) alloc
						      min
						      max
						      mark
						      age)))))

;*---------------------------------------------------------------------*/
;*    spread-unstackable! ...                                          */
;*---------------------------------------------------------------------*/
(define (spread-unstackable! alloc min max age)
   (inc-mark!)
   (trace (stack loop) "*** spread-unstackable!: "
	  (ast->sexp alloc)
	  "  *stack-stamp*: " *stack-stamp* " "
	  "  astamp: " (sinfo-stamp (app-stack-info alloc))
	  " min: " min "  max: " max
	  "  age: " age "  new-mark: " *mark*
	  #\Newline)
   (spread-unstackable/mark! alloc min max *mark* age))

;*---------------------------------------------------------------------*/
;*    spread-all-unstackable! ...                                      */
;*    -------------------------------------------------------------    */
;*    We spread unstackable for all pointed allocation.                */
;*---------------------------------------------------------------------*/
(define (spread-all-unstackable! alloc)
   (spread-unstackable! alloc (-fx *0-stamp* 1) (-fx *0-stamp* 1) 'all))

;*---------------------------------------------------------------------*/
;*    heap->stack ...                                                  */
;*---------------------------------------------------------------------*/
(define (heap->stack!)
   (trace stack
	  #\Newline "======================================"
	  #\Newline "heap->stack: "
	  #\Newline "--------------------------------------"
	  #\Newline)
   (set! *stack-stamp* 0)
   (set-mark! *0-stamp*)
   (let ((alloc (get-allocs)))
      ;; we install all sinfo structures
      (for-each set-default-sinfo alloc)
      ;; then we scan all program's variables and functions.
      (for-each-global!
       (lambda (global)
	  (cond
;*--- unused ----------------------------------------------------------*/
	     ((and (not (eq? (global-import global) 'export))
		   (=fx (global-occurrence global) 0))
	      (trace (stack loop) "      " (shape global) ": ")
	      (trace (stack loop) "[unused]" #\Newline)
	      #unspecified)
;*--- variable --------------------------------------------------------*/
	     ((or (eq? (global-class global) 'variable)
		  (eq? (global-class global) 'c-variable)
		  (eq? (global-class global) 'c-macro-variable))
	      (trace stack "      " (shape global) ": ")
	      (trace stack "[variable]" #\Newline)
	      (let ((approx (get-approx global)))
		 (for-each-set spread-all-unstackable! (approx-alloc approx))))
;*--- sprocedure ------------------------------------------------------*/
	     ((eq? (global-class global) 'sprocedure)
	      (trace (stack loop) "      " (shape global) ": ")
	      (trace (stack loop) "[sprocedure]" #\Newline)
	      (if (alive-function? (closure->function (global-value global)))
		  (mark-unstackable! (global-value global))))
;*--- special ---------------------------------------------------------*/
	     ((or (and (function? (global-value global))
		       (ispecial? (function-cfa-info (global-value global))))
		  (and (ffunction? (global-value global))
		       (ispecial? (ffunction-cfa-info (global-value global)))))
	      (trace (stack loop) "      " (shape global) ": ")
	      (trace (stack loop) "[special]" #\Newline)
	      #unspecified)
;*--- ffunction -------------------------------------------------------*/
	     ((or (eq? (global-class global) 'c-function)
		  (eq? (global-class global) 'c-macro-function))
	      (trace (stack loop) "      " (shape global) ": ")
	      (trace (stack loop) "[ffunction]" #\Newline)
	      #unspecified)
;*--- function --------------------------------------------------------*/
	     ((or (eq? (global-class global) 'procedure)
		  (eq? (global-class global) 'inline))
	      (trace stack "      " (shape global) ": ")
	      (trace stack "[function]" #\Newline)
	      (case (global-import global)
		 ((export)
		  (export-function-heap->stack! global))
		 ((static)
		  (static-function-heap->stack! global))
		 ((import)
		  #unspecified)))
;*--- error -----------------------------------------------------------*/
	     (else
	      (internal-error "heap->stack!"
			      "Don't know what to do with"
			      (shape global))))))
      (show-heap->stack-results alloc)
      ;; we have finished, we just have to inspect all allocations
      ;; in order to replace the one who are stackable
      (for-each (lambda (alloc)
		   (let ((sinfo  (app-stack-info alloc))
			 (halloc (var-variable (app-fun alloc))))
		      (app-stack-info-set! alloc #unspecified)
		      (if (sinfo-stackable? sinfo)
			  (let ((salloc (ast-pragma halloc '_s-alloc_)))
			     (if (pair? salloc)
				 (var-variable-set! (app-fun alloc)
						    (require-global
						     (car salloc)
						     'foreign
						     #f)))))))
		alloc))
   #unspecified)

;*---------------------------------------------------------------------*/
;*    export-function-heap->stack! ...                                 */
;*    -------------------------------------------------------------    */
;*    For exported function, all the approximations which are          */
;*    contained in the result are said to be unstackable. This is      */
;*    the only difference between static and exported functions.       */
;*---------------------------------------------------------------------*/
(define (export-function-heap->stack! var)
   (trace stack "$$ export-function-heap->stack!: " (shape var) #\Newline)
   (if (alive-function? var)
       (begin
	  (ast-heap->stack! (function-body (global-value var)))
	  (let* ((approx (get-approx var))
		 (alloc  (approx-alloc approx)))
	     (for-each-set spread-all-unstackable! alloc)))))

;*---------------------------------------------------------------------*/
;*    static-function-heap->stack! ...                                 */
;*---------------------------------------------------------------------*/
(define (static-function-heap->stack! var)
   (trace stack "$$ static-function-heap->stack!: " (shape var) #\Newline)
   (if (alive-function? var)
       (let ((stamp *stack-stamp*))
	  (ast-heap->stack! (function-body (variable-value var)))
	  (let* ((approx (get-approx var))
		 (alloc  (approx-alloc approx)))
	     (inc-mark!)
	     (trace stack
		    ">>> Je spread unstackable tous les resultats...[len:"
		    (set-length alloc) "]:" #\Newline)
	     (for-each-set (lambda (a)
			      (trace (stack loop) ">>>>>> je fais: "
				     (ast->sexp a) #\Newline)
			      (spread-unstackable/mark! a
							stamp
							*stack-stamp*
							*mark*
							'between))
			   alloc)))))
    
;*---------------------------------------------------------------------*/
;*    ast-heap->stack! ...                                             */
;*---------------------------------------------------------------------*/
(define (ast-heap->stack! ast)
   (let loop ((ast ast))
   (trace stack "> " (ast->sexp ast) #\Newline)
      (ast-case ast
	 ((atom)
	  #unspecified)
	 ((kwote)
	  #unspecified)
	 ((var)
	  #unspecified)
	 ((prag-ma)
	  (for-each loop (prag-ma-values ast))
	  #unspecified)
	 ((fail)
	  (loop (fail-proc ast))
	  (loop (fail-msg ast))
	  (loop (fail-obj ast)))
	 ((sequence)
	  (let liip ((exp (sequence-exp ast)))
	     (if (null? exp)
		 #unspecified
		 (begin
		    (loop (car exp))
		    (liip (cdr exp))))))
	 ((conditional)
	  (loop (conditional-test ast))
	  (loop (conditional-then ast))
	  (loop (conditional-else ast)))
	 ((switch)
	  (let liip ((exp (switch-clauses ast))) 
	     (if (null? exp)
		 (loop (switch-test ast))
		 (begin
		    (loop (cdr (car exp)))
		    (liip (cdr exp))))))
	 ((setq)
	  (loop (setq-val ast)))
	 ((let-var)
	  (set! *stack-stamp* (+fx *stack-stamp* 1))
	  (let ((old *stack-stamp*))
	     (for-each (lambda (binding)
			  (loop (cdr binding)))
		       (let-var-bindings ast))
	     ;; alloca de-allocate at the end of the activation frame.
	     ;; Hence, it is possible to stack-allocate all local
	     ;; variables which are dead at the end of the function even
	     ;; if they are living after their binding let.
	     (if (not (eq? *stack-alloc* 'alloca))
		 ;; If we are not using alloca, all live local variables
		 ;; after their binding let can't be stack allocate.
		 ;; This code disable their stack allocation.
		 (for-each (lambda (binding)
			      (let* ((approx (get-approx (car binding)))
				     (alloc  (approx-alloc approx))
				     (count  0))
				 (inc-mark!)
				 (trace stack
					">>> Je spread unstackable tous "
					"les resultats...[len:"
					(set-length alloc) "]:" #\Newline)
				 (for-each-set
				  (lambda (a)
				     (set! count (+fx 1 count))
				     (trace stack count " ")
				     (trace (stack loop)
					    ">>>>>> je fais: "
					    (ast->sexp a) #\Newline)
				     (spread-unstackable/mark! a
							       old
							       *stack-stamp*
							       *mark*
							       'between))
				  alloc)
				 (trace stack #\Newline)))
			   (let-var-bindings ast)))
	     (loop (let-var-body ast))))
	 ((let-fun)
	  (for-each static-function-heap->stack! (let-fun-locals ast))
	  (loop (let-fun-body ast)))
	 ((set-ex-it)
	  (loop (set-ex-it-body ast)))
	 ((jump-ex-it)
	  (loop (jump-ex-it-exit ast))
	  (loop (jump-ex-it-value ast)))
	 ((app-ly)
	  (loop (app-ly-fun ast))
	  (loop (app-ly-value ast)))
	 ((funcall)
	  (loop (funcall-fun ast))
	  (for-each loop (funcall-actuals ast)))
	 ((app)
	  (if (is-alloc? ast)
	      (mark-stamp! ast *stack-stamp*))
	  (for-each loop (app-actuals ast)))
	 ((make-box)
	  (loop (make-box-value ast)))
	 ((box-ref)
	  (loop (box-ref-var ast)))
	 ((box-set!)
	  (loop (box-set!-var ast))
	  (loop (box-set!-value ast))))))

;*---------------------------------------------------------------------*/
;*    show-heap->stack-results ...                                     */
;*---------------------------------------------------------------------*/
(define (show-heap->stack-results alloc)
   (let ((stacked 0)
	 (total   0))
      (for-each
       (lambda (alloc)
	  (set! total (+fx 1 total))
	  (if (sinfo-stackable? (app-stack-info alloc))
	      (begin
		 (set! stacked (+fx 1 stacked))
		 (trace stack "   #t " (ast->sexp alloc) #\Newline))
	      (trace stack "   #f " (ast->sexp alloc) #\Newline)))
       alloc)
      (verbose 2
	       "           heap->stack reduction: "
	       (if (=fx total 0)
		   0
		   (inexact->exact
		    (*fl 100.0 (/fl (exact->inexact stacked)
				    (exact->inexact total)))))
	       " %"
	       #\Newline)
      #unspecified))
		
