;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Ast/pragma.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec 27 18:09:27 1994                          */
;*    Last change :  Mon Jul 17 11:26:51 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The pragma manipulations.                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_pragma
   (include "Ast/ast.sch")
   (import  engine_param
	    ast_env
	    tools_location
	    tools_shape
	    tools_error)
   (export  (parse-pragmas! <list>   <module>)
	    (ast-pragma     <global> <pragma>)))

;*---------------------------------------------------------------------*/
;*    *unary-pragma-list* ...                                          */
;*---------------------------------------------------------------------*/
(define *unary-pragma-list* '(_no_cfa_top_ _no_side_effect_))

;*---------------------------------------------------------------------*/
;*    *nary-pragma-list* ...                                           */
;*---------------------------------------------------------------------*/
(define *nary-pragma-list* '(_s-alloc_ _type-checker_))

;*---------------------------------------------------------------------*/
;*    *pragma-list* ...                                                */
;*---------------------------------------------------------------------*/
(define *pragma-list* (append *nary-pragma-list* *unary-pragma-list*))

;*---------------------------------------------------------------------*/
;*    ast-pragma ...                                                   */
;*    -------------------------------------------------------------    */
;*    This function scan `global' pragma list in order to              */
;*    find the value associated with `property'.                       */
;*---------------------------------------------------------------------*/
(define (ast-pragma global property)
   [assert check (global) (global? global)]
   [assert check (property) (memq property *pragma-list*)]
   (let ((val (assq property (global-pragma global))))
      (if (pair? val)
	  (cdr val)
	  #f)))
   
;*---------------------------------------------------------------------*/
;*    get-pragma-property ...                                          */
;*    -------------------------------------------------------------    */
;*    We check if the compiler knows the pragma and if it is correct.  */
;*---------------------------------------------------------------------*/
(define (get-pragma-property pragma)
   (cond
      ((symbol? pragma)
       (if (memq pragma *unary-pragma-list*)
	   'unary
	   #f))
      ((pair? pragma)
       (if (memq (car pragma) *nary-pragma-list*)
	   'nary
	   #f))
      (else
       #f)))

;*---------------------------------------------------------------------*/
;*    parse-pragma ...                                                 */
;*---------------------------------------------------------------------*/
(define (parse-pragma pragma module)
   (match-case pragma
      ((?fun . ?prop)
       (let ((global (let ((global (find-global fun module)))
			(if (not (global? global))
			    (find-global fun 'foreign)
			    global))))
	  (if (not (global? global))
	      (user-error "parse-pragma"
			  "Can't find global variable"
			  `(@ ,module ,fun))
	      (let loop ((prop prop)
			 (err? #f))
		 (if (null? prop)
		     (begin
			(if err?
			    (user-warning/location (find-location pragma)
						   "parse-pragma"
						   "Illegal pragma"
						   pragma))
			#unspecified)
		     (let ((pprop (get-pragma-property (car prop))))
			(case pprop
			   ((unary)
			    (global-pragma-set! global
						(cons (cons (car prop) #t)
						      (global-pragma global)))
			    (loop (cdr prop) err?))
			   ((nary)
			    (global-pragma-set! global
						(cons (car prop)
						      (global-pragma global)))
			    (loop (cdr prop) err?))
			   (else
			    (loop (cdr prop) #t)))))))))
      (else
       (user-warning/location (find-location pragma)
			      "parse-pragma"
			      "Illegal pragma"
			      pragma))))
       
;*---------------------------------------------------------------------*/
;*    parse-pragmas! ...                                               */
;*---------------------------------------------------------------------*/
(define (parse-pragmas! pragma-list module)
   (for-each (lambda (p) (parse-pragma p module)) pragma-list))

