/*
 * dlsof.h - DEC OSF/1 header file for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


/*
 * $Id: dlsof.h,v 1.15 96/01/09 08:18:51 abe Exp $
 */


#if	!defined(DECOSF_LSOF_H)
#define	DECOSF_LSOF_H	1

#include <fcntl.h>
#include <fstab.h>

# if	_OSF1V<30000
#include <sys/mount.h>
# endif	/* _OSF1V<30000 */

#include <dirent.h>
#include <nlist.h>
#include <setjmp.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <cdfs/cdfsnode.h>
#include <rpc/types.h>
#include <sys/mbuf.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/table.h>
#include <sys/un.h>
#include <sys/unpcb.h>
#include <sys/domain.h>
#include <netinet/in.h>
#include <net/route.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/in_pcb.h>
#include <net/raw_cb.h>
#undef	queue
#undef	queue_t
#define	queue	___queue
#define	queue_t	___queue_t
#include <sys/stream.h>
#undef	___queue
#undef	___queue_t
#define	___queue queue
#define	___queue_t queue_t

# if	_OSF1V<30000
#include <nfs/nfs.h>
#define	KERNEL_FILE
#include <sys/file.h>
# endif	/* _OSF1V<30000 */

#include <ufs/inode.h>
/*
 * The following header files need _KERNEL and KERNEL defined.  Some
 * #undef preparation is necessary.  Three of the header files that the
 * following header files include --  <kern/queue.h>, <kern/timer.h>, and
 * <machine/pmap.h> -- have local copies with duplicate typedef's
 * conditionally eliminated by the LSOF definition.  The local copies
 * are in the dec_a subdirectory of the lsof distribution.
 *
 * The dec_a subdirectory also contains copies of <stdlib.h> and
 * <sys/signal.h> which have LSOF conditionals to avoid conflicts between
 * kernel and application function prototypes.
 */

#define _KERNEL	1
#define KERNEL	1
#undef	MACRO_END
#undef	PIPSIZ
#undef	i_forw
#undef	i_gen
#undef	i_gid
#undef	i_lock
#undef	i_mode
#undef	i_nlink
#undef	i_rdev
#undef	i_size
#undef	i_uid
# if	_OSF1V>=30000
#undef	m_data
#undef	m_next
#include <sys/file.h>
#include <sys/fifonode.h>
#include <sys/mount.h>
# endif	/* _OSF1V>=30000 */
#undef	calloc
#define	calloc	___calloc
#undef	exit
#define	exit	___exit
#undef	pt_entry_t
#define	pt_entry_t ___pt_entry_t
#undef	timer_t
#define	timer_t	___timer_t
#include <kern/task.h>
#undef	___calloc
#define	___calloc calloc
#define	___exit	exit
#undef	___pt_entry_t
#undef	___timer_t
#include <s5fs/s5inode.h>
#include <sys/procfs.h>
#include <sys/proc.h> DEBUG
#include <sys/user.h>
#undef	u_comm
#define	u_comm	uu_comm

# if	_OSF1V>=30000
#undef	u
#endif	/* _OSF1V>=30000 */

#include <sys/specdev.h>
#include <sys/vnode.h>

# if	_OSF1V>=30000
#include <nfs/nfs.h>
# endif	/* _OSF1V>=30000 */

#include <nfs/rnode.h>
#include <ufs/mfsnode.h>
#include <vm/vm_anon.h>
#include <vm/u_mape_seg.h>

# if	_OSF1V>=40000
#include <vm/vm_ubc.h>
# else	/* _OSF1V<40000 */
#include <vm/vm_vp.h>
# endif	/* _OSF1V>=40000 */

/*
 * The spec_node is not defined in a distributed header file, but in
 * a kernel source file.
 */

struct spec_node {
	struct vnode *sn_vnode;
	struct vattr sn_vattr;
};

/*
 * The is an educated guess at an ADVFS/MSFS node.
 */

struct advfsnode {

# if	_ADVFSV<200
	long	d1[19];
# else	/* _ADVFSV>=200 */
#  if	_ADVFSV<300
	long	d1[20];
#  else	/* _ADVFSV>=300 */
#   if	_ADVFSV<400
	long	d1[21];
#   else	/* _ADVFSV>=400 */
	long	d1[17];
#   endif	/* _ADVFSV>=400 */
#  endif	/* _ADVFSV<300 */
# endif	/* _ADVFSV<200 */

	ino_t	a_number;
	int	d2;
	long	d3;
	int	d4;
	dev_t	a_rdev;
	long	a_size;
};


#define	COMP_P		void
#define DEVINCR		1024	/* device table malloc() increment */
#define	KA_T		off_t
#define	KMEM		"/dev/kmem"
#define MALLOC_P	char
#define FREE_P		MALLOC_P
#define MALLOC_S	size_t
#define N_UNIX		"/vmunix"
#define	PNSIZ		5	/* /proc PID name component length */
#define PR_INOBIAS	64	/* /proc inode number bias */
#define PR_ROOTINO	2	/* /proc root inode number */
#define	PROCMIN		3	/* processes that make a "good" scan */
#define	PROCTRYLM	5	/* times to try to read proc table */
#define QSORT_P		char
#define	READLEN_T	int
#define STRNCPY_L	int
#define	U_SIZE		sizeof(struct user)


/*
 * Global storage definitions (including their structure definitions)
 */

struct clone {
	int dx;			/* index of device entry in Devtp[] */
	struct clone *next;	/* forward link */

};
extern struct clone *Clone;

extern dev_t Clonedev;

extern int Kmem;

struct l_vfs {
	struct mount *addr;		/* kernel address */
	fsid_t fsid;			/* file system ID */
	short type;			/* type of file system */
	char *dir;			/* mounted directory */
	char *fsname;			/* file system name */

# if	defined(HASFSINO)
	ino_t fs_ino;			/* file system inode number */
# endif	/* defined(HASFSINO) */

	dev_t dev;			/* device number */
	dev_t rdev;			/* raw device number */
	struct l_vfs *next;		/* forward link */
};
extern struct l_vfs *Lvfs;

struct mounts {
        dev_t dev;              	/* st_dev */
        char *dir;              	/* directory */
        char *fsname;           	/* file system */
	ino_t inode;			/* st_ino */
	mode_t mode;			/* st_mode */
        struct mounts *next;    	/* forward link */
	dev_t rdev;			/* st_rdev */
	fsid_t fsid;			/* file system ID */
};
extern struct mounts *Mtab;

#define X_CLONE		0
#define	X_NCACHE	1
#define	X_NCSIZE	2
#define X_VNMXP		3

# if	_OSF1V<30000
#define X_PROC          4
#define X_NPROC         5
# else	/* _OSF1V>=30000 */
#define	X_NPID		4
#define	X_PIDTAB	5
# endif	/* _OSF1V<30000 */

struct sfile {
	char *aname;			/* argument file name */
	char *name;			/* file name (after readlink()) */
	char *devnm;			/* device name (optional) */
	dev_t dev;			/* device */
	u_short mode;			/* S_IFMT mode bits from stat() */
	int type;			/* file type: 0 = file system
				 	 *	      1 = regular file */
	ino_t i;			/* inode number */
	int f;				/* file found flag */
	struct sfile *next;		/* forward link */

};

# if	_OSF1V>=30000
extern KA_T *Pa;			/* kernel proc structure addresses */
# endif	/* _OSF1V>=30000 */

extern struct proc *Ps;			/* local proc structures */
extern int Psn;				/* entries in Pa[] and Ps[] */

extern int Vnmxp;

#endif	/* !DECOSF_LSOF_H */
