;**************************************************************************
;*
;* Boot-ROM-Code to load an operating system across a TCP/IP network.
;*
;* Module:  dospriv.inc
;* Purpose: Include file to define DOS and BIOS data structures
;* Entries: None
;*
;**************************************************************************
;*
;* Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
;*
;*  This program is free software; you can redistribute it and/or modify
;*  it under the terms of the GNU General Public License as published by
;*  the Free Software Foundation; either version 2 of the License, or
;*  any later version.
;*
;*  This program is distributed in the hope that it will be useful,
;*  but WITHOUT ANY WARRANTY; without even the implied warranty of
;*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;*  GNU General Public License for more details.
;*
;*  You should have received a copy of the GNU General Public License
;*  along with this program; if not, write to the Free Software
;*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;*


;
;**************************************************************************
;
; Fatal error codes:
;
FATAL_NOMEM	equ	1		; not enough basic memory
FATAL_STACK	equ	2		; stack overflow error
FATAL_NOPROC	equ	3		; terminating non-active process
FATAL_MEMORY	equ	4		; memory corrupt
FATAL_PROG	equ	5		; corrupt program


;
;**************************************************************************
;
; The DOS dispatcher interrupt 21h has to save some registers before
; calling the handler routine. As DOS is able to use two different
; stacks we also have to save those registers into two different
; locations. The area to hold the values looks like this:
;
old_reg		struc

old_bp		dw	?
old_ds		dw	?
old_stack	dd	?
stack_sig	dw	?	; stack signature, has to be last in this
				; structure
old_reg		ends


;
;**************************************************************************
;
; Definitions for memory management:
;
; A memory control block precedes every memory block in the lower ram
; area (e.g. from the end of the boot rom data area to the beginning
; of the operating system loading area). If the owner address is 0,
; the memory block is free.
;
mcb		struc

mcb_id		db	?		; ID of control block (see below)
mcb_owner	dw	?		; pointer to PSP of owner process
mcb_size	dw	?		; size in paragraphs

mcb		ends

; MCB id codes:

MCB_MEM_ID	equ	'M'		; indicates valid memory block
MCB_END_ID	equ	'Z'		; indicates last memory block


;
;**************************************************************************
;
; Definition of device codes:
;
DEV_CON		equ	0		; console
DEV_AUX		equ	1		; serial port
DEV_PRN		equ	2		; printer port


;
;**************************************************************************
;
; Definition of reserved file handles.
;
RES_HANDLES	equ	5		; total number of reserved handles

RES_STDIN	equ	0		; stdin file handle
RES_STDOUT	equ	1		; stdout file handle
RES_STDERR	equ	2		; stderr file handle
RES_AUX		equ	3		; AUX device file handle
RES_PRN		equ	4		; PRN device file handle


;
;**************************************************************************
;
; Definition of Program Segment Prefix (PSP):
;
% ifdifi <@filename>,<dosinit>

		extrn call21:far

psp		struc

		db	0CDh,020h	; OP-codes for INT20h
psp_endmem	dw	?		; first allocatable seg after program
		db	00h		; reserved
		db	09Ah		; far call OP-code to INT21h handler
		dw	offset cgroup:call21	; pointer to INT21h handler
		dw	HIGHMEM			; segment of INT21h handler
psp_int22	dd	?			; saved interrupt 22h vector
psp_int23	dd	?			; saved interrupt 23h vector
psp_int24	dd	?			; saved interrupt 24h vector
psp_parent	dw	?			; PSP of parent process
psp_handles	db	RES_HANDLES dup (0FFh)	; reserved file handles
		db	20-RES_HANDLES dup (0)	; file handle table
psp_env		dw	0			; segment of program environment
psp_oldstack	dd	?			; stack pointer of parent
psp_numhndl	dw	psp_env - psp_handles	; number of file handles
psp_ofshndl	dw	psp_handles		; offset of file handle table
psp_seghndl	dw	?			; segment of file handle table
		db	24 dup (00h)		; reserved
		db	0CDh,021h,0CBh		; OP-codes for INT21h and RETF
		db	9 dup (00h)		; reserved
psp_fcb1	db	16 dup (0)	; first part of FCB 1
psp_fcb2	db	16 dup (0)	; first part of FCB 2
		db	4 dup (00h)	; reserved
psp_cmdlsize	db	0		; length of command line
psp_cmdl	db	0		; command line (the first of 127 bytes)

psp		ends

PSP_MAXCMDL	equ	125		; maximum length of command line
PSP_SIZE	equ	256		; size of PSP with full command line

endif


;
;**************************************************************************
;
; Definitions for program management:
;
COM_MAGIC	equ	4B47h		; magic cookie for COM program images
COM_SIZE_OFS	equ	2		; offset to value giving size of image
COM_CODE_OFS	equ	4		; offset ot code image
COM_MIN_FREE	equ	0110h		; minimum number of free paragraphs


;
;**************************************************************************
;
; DOS error codes
;
ERR_NOFN	equ	1		; function does not exist
ERR_NOFILE	equ	2		; file not found
ERR_NODIR	equ	3		; directory not found
ERR_TOOMANY	equ	4		; too many open files
ERR_NOACC	equ	5		; access denied
ERR_INVHDL	equ	6		; invalid file handle
ERR_INVMCB	equ	7		; invalid memory control block
ERR_NOMEM	equ	8		; not enough memory
ERR_INVMEM	equ	9		; invalid memory block address
ERR_INVENV	equ	10		; invalid environment
ERR_INVFORM	equ	11		; invalid format
ERR_INVACC	equ	12		; invalid access code
ERR_INVDATA	equ	13		; invalid data
ERR_INVDRV	equ	15		; invalid drive
ERR_DELACT	equ	16		; not allowed to delete active dir
ERR_NODEV	equ	17		; device not available
ERR_NOMORE	equ	18		; no more files
ERR_WRTPROT	equ	19		; disk is write protected
ERR_NODISK	equ	20		; disk device not available
ERR_NOTRDY	equ	21		; drive not ready
ERR_INVCMD	equ	22		; invalid disk command
ERR_CRCERR	equ	23		; CRC error
ERR_TIMOUT	equ	24		; time out of disk operation
ERR_SEARCH	equ	25		; error searching disk block
ERR_NODOS	equ	26		; no DOS diskette
ERR_NOSECT	equ	27		; sector not found
ERR_NOPAPER	equ	28		; no paper in printer
ERR_WRITE	equ	29		; write error
ERR_READ	equ	30		; read error
ERR_GENERAL	equ	31		; general error


;
;**************************************************************************
;
; ASCII character definitions
;
CHR_BS		equ	08h		; Backspace character
CHR_RET		equ	0Dh		; Return character
CHR_LF		equ	0Ah		; Line-feed character
CHR_FF		equ	0Ch		; Form-feed character
CHR_TAB		equ	09h		; Tab character
CHR_FIRST	equ	20h		; first printable character
CHR_DELETE	equ	7Fh		; Delete character

