;**************************************************************************
;*
;* Boot-ROM-Code to load an operating system across a TCP/IP network.
;*
;* Module:  macros.inc
;* Purpose: Miscellanous assembler macros
;* Entries: None
;*
;**************************************************************************
;*
;* Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
;*
;*  This program is free software; you can redistribute it and/or modify
;*  it under the terms of the GNU General Public License as published by
;*  the Free Software Foundation; either version 2 of the License, or
;*  any later version.
;*
;*  This program is distributed in the hope that it will be useful,
;*  but WITHOUT ANY WARRANTY; without even the implied warranty of
;*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;*  GNU General Public License for more details.
;*
;*  You should have received a copy of the GNU General Public License
;*  along with this program; if not, write to the Free Software
;*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;*


;
;**************************************************************************
;
; Define the processor type to use
;
ifdef P86
	.8086			; use only 8086 instructions
elseifdef P186
	.186			; may also use 80186 special instructions
	IS186	equ	1
elseifdef P286
	.286			; may also use 80286 special instructions
	IS186	equ	1
	IS286	equ	1
else
	.386			; this is the default
	IS186	equ	1
	IS286	equ	1
	IS386	equ	1
endif

; seguse is only used with the 386

ifdef IS386
	seguse	equ	<USE16>
else
	seguse	equ	<>
endif


;
;**************************************************************************
;
; Make segment definitions easy and unique by using the following macros.
; Note that these macros have to be identical with the definitions in
; the segment layout include file.
;
; Macros for defining the floppy loader text segment:
;
load_start	macro
% load_text	segment	para seguse public 'CODE'
		assume	cs:load_text
		assume	ds:load_text
		assume	ss:nothing
		assume	es:nothing
		endm

load_end	macro
load_text	ends
		endm

;
; Macros for defining the general text segment:
;
text_start	macro
% _text		segment	byte seguse public 'CODE'
		assume	cs:cgroup
		assume	ds:dgroup
		assume	ss:dgroup
		assume	es:nothing
		endm

text_end	macro
_text		ends
		endm

;
; Macros for defining the constant data segment:
;
const_start	macro
% _const	segment	word seguse public 'CONST'
		endm

const_end	macro
_const		ends
		endm

;
; Macros for defining the general data segment:
;
data_start	macro
% _data		segment word seguse public 'DATA'
		endm

data_end	macro
_data		ends
		endm

;
; Macros for defining the BSS segment:
;
bss_start	macro
% _bss		segment	word seguse public 'BSS'
		endm

bss_end		macro
_bss		ends
		endm


;
;**************************************************************************
;
; Macros for making the high level C programming interface easier.
;
; Setup a standard stack frame
;
penter		macro	argnum

ifb <&argnum>
	stackargs = 0
else
	stackargs = <&argnum>		;; save it for later
endif

ifdef IS186
	ifb <&argnum>
		push	bp		;; smaller than enter opcode
		mov	bp,sp
	else
		enter	argnum,0	;; smaller than conventional
	endif
else
		push	bp
		mov	bp,sp		;; otherwise we have to do it by hand
	ifnb <&argnum>
		sub	sp,argnum
	endif
endif

		endm


;
; Restore a standard stackframe
;
pleave		macro

ifdef IS186
	if stackargs eq 0
		pop	bp		;; reverse of code above
	else
		leave			;; do this all at once
	endif
else
	if stackargs eq 0
		mov	sp,bp		;; restore any local arguments
	endif
		pop	bp		;; restore callers stack frame
endif

		endm


;
; Get an argument from the stack. This assumes the tiny model with a
; standard stack frame.
;
getarg		macro	reg,argnum,psize,sign

if ((.type &argnum) and 04h) eq 04h
		;; argnum is a constant value
  ifnb <&psize>
    ifdef IS386
      ifnb <&sign>
        ifdifi <&sign>,<signed>
		movzx	&reg,&psize ptr [bp + 4 + (&argnum * 2)]
        else
		movsx	&reg,&psize ptr [bp + 4 + (&argnum * 2)]
        endif
      else
		movzx	&reg,&psize ptr [bp + 4 + (&argnum * 2)]
      endif
    else
		mov	&reg,&psize ptr [bp + 4 + (&argnum * 2)]
    endif
  else
		mov	&reg,[bp + 4 + (&argnum * 2)]
  endif
else
		;; argnum is a variable or register
  ifdifi <&reg>,<si>
		push	si
  endif
  ifdifi <&argnum>,<si>
		mov	si,&argnum
  endif
		shl	si,1
  ifnb <&psize>
    ifdef IS386
      ifnb <&sign>
        ifdifi <&sign>,<signed>
		movzx	&reg,&psize ptr [bp + 4 + si]
        else
		movsx	&reg,&psize ptr [bp + 4 + si]
        endif
      else
		movzx	&reg,&psize ptr [bp + 4 + si]
      endif
    else
		mov	&reg,&psize ptr [bp + 4 + si]
    endif
  else
		mov	&reg,[bp + 4 + si]
  endif
  ifdifi <&reg>,<si>
		pop	si
  endif
endif

		endm


;
;**************************************************************************
;
; Macros to make things easier with higher processors
;
; Standard shift and rotate instructions
;
shift		macro	op,reg,count

ifdef IS186
		&op	&reg,&count
else
  if count eq 1
		&op	&reg,1
  else
		push	cx
		mov	cl,&count
		&op	&reg,cl
		pop	cx
  endif
endif

		endm


;
; Push all registers onto stack
; 
pushall		macro

ifdef IS186
		pusha
else
		push	ax
		push	cx
		push	dx
		push	bx
		push	sp
		push	bp
		push	si
		push	di
endif

		endm


;
; Pop all registers from stack
; 
popall		macro

ifdef IS186
		popa
else
		pop	di
		pop	si
		pop	bp
		pop	ax		;; SP is discarded
		pop	bx
		pop	dx
		pop	cx
		pop	ax
endif

		endm

