'\"
'\" Copyright (c) 1990-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1995 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) label.n 1.23 95/06/07 21:15:17
'\" 
.so man.macros
.TH label n 4.0 Tk "Tk Generic Methods"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
label \- Create and manipulate label widgets
.SH SYNOPSIS
\fI$label\fR = \fI$parent\fR->\fBLabel\fR(\fR?\fIoptions\fR?\fR);
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.VS
\fBanchor\fR	\fBfont\fR	\fBimage\fR	\fBtakeFocus\fR
\fBbackground\fR	\fBforeground\fR	\fBjustify\fR	\fBtext\fR
\fBbitmap\fR	\fBhighlightBackground\fR	\fBpadX\fR	\fBtextVariable\fR
\fBborderWidth\fR	\fBhighlightColor\fR	\fBpadY\fR	\fBunderline\fR
.VE
\fBcursor\fR	\fBhighlightThickness\fR	\fBrelief\fR	\fBwrapLength\fR
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.LP
.nf
Name:	\fBheight\fR
Class:	\fBHeight\fR
Configure Option:	\fB\-height\fR
.fi
.IP
Specifies a desired height for the label.
If an image or bitmap is being displayed in the label then the value is in
screen units (i.e. any of the forms acceptable to \fBTk_GetPixels\fR);
for text it is in lines of text.
If this option isn't specified, the label's desired height is computed
from the size of the image or bitmap or text being displayed in it.
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Configure Option:	\fB\-width\fR
.fi
.IP
Specifies a desired width for the label.
If an image or bitmap is being displayed in the label then the value is in
screen units (i.e. any of the forms acceptable to \fBTk_GetPixels\fR);
for text it is in characters.
If this option isn't specified, the label's desired width is computed
from the size of the image or bitmap or text being displayed in it.
.BE

.SH DESCRIPTION
.PP
The \fBlabel\fR command creates a new window (given by the
$widget\fR argument) and makes it into a label widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the label such as its colors, font,
text, and initial relief.  The \fBlabel\fR command returns its
$widget\fR argument.  At the time this command is invoked,
there must not exist a window named $widget\fR, but
$widget\fR's parent must exist.
.PP
A label is a widget
.VS
that displays a textual string, bitmap or image.
If text is displayed, it must all be in a single font, but it
can occupy multiple lines on the screen (if it contains newlines
or if wrapping occurs because of the \fBwrapLength\fR option) and
one of the characters may optionally be underlined using the
\fBunderline\fR option.
.VE
The label can be manipulated in a few simple ways, such as
changing its relief or text, using the commands described below.

.SH "WIDGET METHODS"
.PP
The \fBlabel\fR command creates a widget object whose
name is $widget\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fI$label\fR->\fBmethod\fR(?\fIarg arg ...\fR?)
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for label widgets:
.TP
\fI$label->\fBcget\fR(\fIoption\fR)
.VS
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBlabel\fR
command.
.VE
.TP
\fI$label->\fBconfigure\fR(?\fIoption\fR?, ?\fIvalue, option, value, ...\fR?\fR)
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for $widget\fR (see \fBconfigure\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBlabel\fR
command.

.SH BINDINGS
.PP
When a new label is created, it has no default event bindings:
labels are not intended to be interactive.

.SH KEYWORDS
label, widget
