% -*- SLang -*-
%
% run compiler in a subshell and/or parse error messages
%
% Changes made by Alexander Demenshin <aldem@barnet.kharkov.ua>
%
% functions:
%   compile_parse_errors		parse next error
%   compile_previous_error		parse previous error
%   compile_parse_buf    		parse current buffer as error messages
%   compile			        run program and parse it output


% The file compile.dat is a database for various compilers.
% This file reads the function from compile.dat.

%!% compiler name in the database "compile.dat"
!if (is_defined ("compile_parse_error_function"))
  variable compile_parse_error_function = Null_String;

%!% regular expression to extract compile errors
!if (is_defined ("compile_parse_regexp"))
  variable compile_parse_regexp = Null_String;

variable Compile_Output_Buffer = "*shell-output*";

if (is_defined ("get_process_input"))
{
   Compile_Output_Buffer = "*compile*";
}

$4 = "'compile_parse_error_function' needs set.  See jed.rc for info.";
$5 = "compile.dat";
$6 = "compile.dat not found!";
$7 = " *compile.dat tmp*";
$8 = "Compiler type not in database file compile.dat!";

!if (strlen (compile_parse_regexp))
{   
   !if (strlen (compile_parse_error_function))
     error ($4);
   
   $1 = whatbuf ();
   $2 = expand_jedlib_file ($5);
   !if (strlen($2)) error ($6);
     
   setbuf ($7);
   $3 = insert_file_region ($2, strcat ("%@", compile_parse_error_function),
			    "-------");
   if ($3 > 0) evalbuffer ();
   delbuf (whatbuf);
   setbuf ($1);
   if ($3 <= 0)
     {
	error ($8);
     }
}

$1 = 0; $2 = 0; $3 = 0; $4 = 0; $5 = 0; $6 = 0; $7 = 0; $8 = 0; $9 = 0;

variable Compile_Src_Dir = Null_String;
variable Compile_Line_Mark = 0;

%
%  These variables are used when parsing GNU's Make output (directory changes).
%  I don't know what kind of output generated by other Make, so substitute
%  it if needed. <aldem>
%
#ifdef UNIX
variable Compile_Dir_Enter = "^make\\[\\d+\\]: Entering directory `\\(.+\\)'";
variable Compile_Dir_Leave = "^make\\[\\d+\\]: Leaving directory `\\(.+\\)'";

define compile_parse_make_chdir ()
{
   variable beg_mark, end_mark;
   variable end_line;

   push_spot ();
   EXIT_BLOCK
     {
	pop_spot ();
     }
   
   beg_mark = create_user_mark ();
   end_mark = create_user_mark ();

   forever
     {
	goto_user_mark (end_mark);
	
	end_line = 0;
	
	if (re_bsearch (Compile_Dir_Leave))
	  {
	     if (up_1 ())
	       end_line = what_line ();
	     
	     move_user_mark (end_mark);
	  }
	
	goto_user_mark (beg_mark);
	
	!if (up_1 ()) return Null_String;
	
	if (re_bsearch (Compile_Dir_Enter))
	  {
	     if (not(end_line)
		 or (what_line () > end_line))
	       break;
	     move_user_mark (beg_mark);
	  }
	else return Null_String;
     }
   regexp_nth_match (1);
}

#endif


define compile_find_file (file, line)
{
#ifdef UNIX
   variable dir;
   
   dir = compile_parse_make_chdir ();
   if (strlen (dir) and (file[0] != '/'))
     file = dircat (dir, file);
#endif
   
   if (1 != file_status (file))
     {
	file = strcat (Compile_Src_Dir, file);
	while (1 != file_status (file))
	  {
	     file = read_file_from_mini ("Find this file's errors:");
	  }
     }
   
   (Compile_Src_Dir,) = parse_filename (file);

   
   () = find_file (file);
   widen_buffer ();
   goto_line (line);
   bol_skip_white ();
}


define compile_parse_errors_dir (next_error_fun, next_line_fun)
{
   variable cbuf, obuf = Compile_Output_Buffer;
   variable line, file;

   Compile_Line_Mark = 0;
   
   !if (bufferp(obuf))
     {
	flush ("Did you compile?");
	return;
     }

   if (MINIBUFFER_ACTIVE) return;
   
   cbuf = pop2buf_whatbuf (obuf);
   
   if (next_error_fun ())
     {
	file = regexp_nth_match (1);	% file name
	line = regexp_nth_match (2);	% line number (string)
	!if (strlen (line)) return;
	
	bol(); 
	Compile_Line_Mark = create_line_mark (3);
	
	next_line_fun ();
	
	compile_find_file (file, integer (line));
	cbuf = whatbuf ();
	sw2buf (obuf);
     }
   
   pop2buf (cbuf);
}

define compile_find_next_error_fun ()
{
   eol ();
   if (eobp ()) 
     {
	message ("No more errors!");
	0;
     }

   bol ();
   !if (re_fsearch (compile_parse_regexp))
     {
	eob ();
	return 0;
     }
   
   1;
}

define compile_find_prev_error_fun ()
{
   bol ();
   if (bobp ()) 
     {
	message ("No more errors!");
	0;
     }

   !if (re_bsearch (compile_parse_regexp))
     {
	bob ();
	return 0;
     }
   
   1;
}

define compile_parse_errors ()
{
   compile_parse_errors_dir (&compile_find_next_error_fun, &go_down_1);
}

define compile_previous_error ()
{
   compile_parse_errors_dir (&compile_find_prev_error_fun, &bol);
}

define compile ()
{
   variable b, n;
   
   b = whatbuf();
   call ("save_buffers");   
   do_shell_cmd ();
   bob();
   pop2buf(b);
   
   compile_parse_errors ();
}
   

%
%  Parse current buffer as error output
%
define compile_parse_buf ()
{
   Compile_Output_Buffer = whatbuf();
   bob ();
   compile_parse_errors ();
}

$1 = "acompile.sl";
if (is_defined ("get_process_input"))
{
   () = evalfile ($1);
}
