// $Id: AliasGE.h,v 1.4 1997/04/25 06:34:21 zeller Exp $ -*- C++ -*-
// AliasGraphEdge class: temporary edge from or to alias node

// Copyright (C) 1997 Technische Universitaet Braunschweig, Germany.
// Written by Andreas Zeller <zeller@ips.cs.tu-bs.de>.
// 
// This file is part of the DDD Library.
// 
// The DDD Library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// The DDD Library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with the DDD Library -- see the file COPYING.LIB.
// If not, write to the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// DDD is the data display debugger.
// For details, see the DDD World-Wide-Web page, 
// `http://www.cs.tu-bs.de/softech/ddd/',
// or send a mail to the DDD developers at `ddd@ips.cs.tu-bs.de'.

#ifndef _DDD_AliasGraphEdge_h
#define _DDD_AliasGraphEdge_h

#ifdef __GNUG__
#pragma interface
#endif

#include "ArcGraphE.h"

class AliasGraphEdge: public ArcGraphEdge {
public:
    DECLARE_TYPE_INFO

private:
    int _disp_nr;		// Display associated with this edge

protected:
    // Copy Constructor
    AliasGraphEdge(const AliasGraphEdge& edge)
	: ArcGraphEdge(edge),
	  _disp_nr(edge._disp_nr)
    {}

public:
    // Constructor
    AliasGraphEdge(int disp_nr, GraphNode *from, GraphNode *to)
	: ArcGraphEdge(from, to),
	  _disp_nr(disp_nr)
    {}

    // Destructor
    virtual ~AliasGraphEdge() {}

    // Resources
    int disp_nr() const { return _disp_nr; }

    // Duplicator
    GraphEdge *dup() const
    {
	return new AliasGraphEdge(*this);
    }
};

#endif // _DDD_AliasGraphEdge_h
// DON'T ADD ANYTHING BEHIND THIS #endif
