
#ifndef	CMAP_PALETTE_H
#define CMAP_PALETTE_H

/* Code stolen from the Amiga */
#include <stdio.h>
#include <sys/types.h>

#define	MAX_TRIPLETS	256

/* A 32 bit colour triplet. */

struct ColourTriplet
{
	u_long		Red,
			Green,
			Blue;
};


/* A palette template, to be filled in later. */

struct palette
{
long			NumColours;	/* Number of colours	*/
struct ColourTriplet	Triplets[MAX_TRIPLETS];	

};

struct palette *AllocPalette(long NumColours,int TrueColour);
void 		FreePalette(struct palette *palette);
struct palette *GetPalette(struct palette *palette);
long  		GetPaletteSize(struct palette *palette);
signed char	GetPaletteTriplet(struct palette *palette,
			struct ColourTriplet *Triplet,long Index);
signed char	SetPaletteTriplet(struct palette *palette,u_long R,u_long G,u_long B,long Index);
struct palette *copypalette(struct palette *src,struct palette *dst);

int /* success */  WritePalette(struct palette *p,FILE *fh);
struct palette *ReadPalette(FILE *fh);

int /* success */	UpdateTriplet(struct palette *palette,
				u_long	index,
				u_long	rvalue,
				u_long	gvalue,
				u_long	bvalue
				);

/*
 * In Amiga terms, true color means 8bits for each
 * r,g,b, or something similar, but not 24bit mode.
 *
 * On AIX-windows we assume that true color is always
 * true.
 */
#define istruecolor(x)	TRUE


/*
***********************************************************
**																			**
** MACROS																**
**																			**
***********************************************************
*/

#define	ispalettetruecolour( palette )	( palette ->Record ? TRUE : FALSE )

#endif /* CMAP_PALETTE_H */



