#include <stdlib.h>
#include <stdio.h>

#include <qapp.h>
#include <qwidget.h>
#include <qkeycode.h>

#include <QwSpriteField.h>

#define IMG_BACKGROUND "bg.ppm"
#define WIDTH 400
#define HEIGHT 300
#define IMG_SPRITE_DATA "sprite/sprite%d.ppm"
#define IMG_SPRITE_MASK "sprite/sprite%d.pbm"
#define NR_ROTS 32
#define REFRESH_DELAY 15
#define BOUNDS_ACTION Bounce

class Example : public QWidget {
public:
	Example(int nsprites) :
		field(IMG_BACKGROUND,WIDTH,HEIGHT),
		view(&field,this),
		sprite(new QwRealMobileSprite*[nsprites]),
		count(nsprites)

	{
		QwSpritePixmapSequence* images=new QwSpritePixmapSequence(
			IMG_SPRITE_DATA, IMG_SPRITE_MASK, NR_ROTS);

		for (int i=0; i<count; i++) {
			sprite[i]=new QwRealMobileSprite(*images);
			sprite[i]->setBoundsAction(QwRealMobileSprite::BOUNDS_ACTION);
			sprite[i]->setVelocity((double)(random()%256)/128,(double)(random()%256)/128);
		}

		resize(WIDTH,HEIGHT);
		// Since it is virtual, ours won't be called in the constructor
		resizeEvent(0);
		startTimer(REFRESH_DELAY);
	}

protected:
	void resizeEvent(QResizeEvent* event)
	{
		QWidget::resizeEvent(event);
		view.resize(width(),height());
		field.resize(width(),height());
		for (int i=0; i<count; i++) {
			sprite[i]->adoptPlayfieldBounds();
		}
	}

	void timerEvent(QTimerEvent*)
	{
		for (int i=0; i<count; i++) {
			sprite[i]->forward(2.0);
			sprite[i]->frame((sprite[i]->frame()+1)%NR_ROTS);
		}
		field.update();

		// Killing and restarting seems to make it smoother for
		// me.  How about you?
		killTimers();
		startTimer(REFRESH_DELAY);
	}

private:
	QwImageSpriteField field;
	QwSpriteFieldView view;
	QwRealMobileSprite** sprite;
	int count;
};

main(int argc, char** argv)
{
	QApplication app(argc,argv);
	Example example(argc>1 ? atoi(argv[1]) : 3);
	if (argc==1) printf("Give numeric parameter for more bouncers!\n");
	app.setMainWidget(&example);
	example.show();
	return app.exec();
}
