#!/bin/bash
#
# Enable fips mode

set -e

cleanup() {
    [ -z "$DIR" ] || rm -rf "$DIR"
}


run_certutil() {
    CMD="certutil -z $DIR/random -f $DIR/passwd -d sql:$DIR $@"
    echo "Running: $CMD"
    $CMD
}

DIR=`mktemp -p . -d`
trap cleanup EXIT ERR

modutil -create -dbdir $DIR < /dev/null
modutil -fips true -dbdir $DIR < /dev/null
