<?php
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//    Copyright (C) 2006 Malcolm Cowe
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

include("../inc/inc.Settings.php");
include("../inc/inc.AccessUtils.php");
include("../inc/inc.ClassAccess.php");
include("../inc/inc.ClassDocument.php");
include("../inc/inc.ClassFolder.php");
include("../inc/inc.ClassGroup.php");
include("../inc/inc.ClassUser.php");
include("../inc/inc.DBAccess.php");
include("../inc/inc.Language.php");
include("../inc/inc.ClassUI.php");
include("../inc/inc.Authentication.php");

// Check to see if the user wants to see only those documents that are still
// in the review / approve stages.
$showInProcess = false;
if (isset($_GET["inProcess"]) && strlen($_GET["inProcess"])>0 && $_GET["inProcess"]!=0) {
	$showInProcess = true;
}
$showAllVersions = false;
if (isset($_GET["allVersions"]) && strlen($_GET["allVersions"])>0 && $_GET["allVersions"]!=0) {
	$showAllVersions = true;
}

UI::htmlStartPage(getMLText("my_documents"));
UI::globalNavigation();
UI::pageNavigation(getMLText("my_documents"), "my_documents");

// Get list of documents owned by current user that are pending review or
// pending approval.
if (!$db->createTemporaryTable("ttstatid")) {
	UI::contentHeading(getMLText("warning"));
	UI::contentContainer(getMLText("internal_error_exit"));
	UI::htmlEndPage();
	exit;
}

if (!$showAllVersions) {
	if (!$db->createTemporaryTable("ttcontentid")) {
		UI::contentHeading(getMLText("warning"));
		UI::contentContainer(getMLText("internal_error_exit"));
		UI::htmlEndPage();
		exit;
	}
	$queryStr = "SELECT `tblDocuments`.*, `tblDocumentLocks`.`userID` as `lockUser`, ".
		"`tblDocumentContent`.`version`, `tblDocumentStatus`.*, `tblDocumentStatusLog`.`status`, ".
		"`tblDocumentStatusLog`.`comment` AS `statusComment`, `tblDocumentStatusLog`.`date` as `statusDate`, ".
		"`tblDocumentStatusLog`.`userID` ".
		"FROM `tblDocumentContent` ".
		"LEFT JOIN `tblDocuments` ON `tblDocuments`.`id` = `tblDocumentContent`.`document` ".
		"LEFT JOIN `tblDocumentStatus` ON `tblDocumentStatus`.`documentID` = `tblDocumentContent`.`document` ".
		"LEFT JOIN `tblDocumentStatusLog` ON `tblDocumentStatusLog`.`statusID` = `tblDocumentStatus`.`statusID` ".
		"LEFT JOIN `ttstatid` ON `ttstatid`.`maxLogID` = `tblDocumentStatusLog`.`statusLogID` ".
		"LEFT JOIN `ttcontentid` ON `ttcontentid`.`maxVersion` = `tblDocumentStatus`.`version` AND `ttcontentid`.`document` = `tblDocumentStatus`.`documentID` ".
		"LEFT JOIN `tblDocumentLocks` ON `tblDocuments`.`id`=`tblDocumentLocks`.`document` ".
		"WHERE `ttstatid`.`maxLogID`=`tblDocumentStatusLog`.`statusLogID` ".
		"AND `ttcontentid`.`maxVersion` = `tblDocumentContent`.`version` ".
		"AND `tblDocuments`.`owner` = '".$user->getID()."' ".
		($showInProcess ? "AND `tblDocumentStatusLog`.`status` IN (0, 1) " : "").
		"ORDER BY `sequence`";
}
else {
	$queryStr = "SELECT `tblDocuments`.*, `tblDocumentLocks`.`userID` as `lockUser`, ".
		"`tblDocumentStatus`.*, `tblDocumentStatusLog`.`status`, ".
		"`tblDocumentStatusLog`.`comment` AS `statusComment`, `tblDocumentStatusLog`.`date` as `statusDate`, ".
		"`tblDocumentStatusLog`.`userID` ".
		"FROM `tblDocumentStatus` ".
		"LEFT JOIN `tblDocumentStatusLog` USING (`statusID`) ".
		"LEFT JOIN `ttstatid` on `ttstatid`.`maxLogID` = `tblDocumentStatusLog`.`statusLogID` ".
		"LEFT JOIN `tblDocuments` ON `tblDocuments`.`id` = `tblDocumentStatus`.`documentID` ".
		"LEFT JOIN `tblDocumentLocks` ON `tblDocuments`.`id`=`tblDocumentLocks`.`document` ".
		"WHERE `ttstatid`.`maxLogID`=`tblDocumentStatusLog`.`statusLogID` ".
		"AND `tblDocuments`.`owner` = '".$user->getID()."' ".
		($showInProcess ? "AND `tblDocumentStatusLog`.`status` IN (0, 1) " : "").
		"ORDER BY `sequence`";
}
$resArr = $db->getResultArray($queryStr);
if (is_bool($resArr) && !$resArr) {
	UI::contentHeading(getMLText("warning"));
	UI::contentContainer("Internal error. Unable to complete request. Exiting.");
	UI::htmlEndPage();
	exit;
}

$uriVars = "inProcess=".($showInProcess ? "1" : "0")."&allVersions=".($showAllVersions ? "0" : "1");
UI::contentHeading(getMLText(($showInProcess ? "documents_in_process" : "all_documents")).
									 " (<a href=\"../out/out.MyDocuments.php?".$uriVars."\">".
									 getMLText(($showAllVersions ? "show_current_versions" : "show_all_versions"))."</a>)");
UI::contentContainerStart();
print "<table class=\"folderView\">";
print "<thead>\n<tr>\n";
print "<th></th>\n";
print "<th>".getMLText("name")."</th>\n";
print "<th>".getMLText("owner")."</th>\n";
print "<th>".getMLText("status")."</th>\n";
print "<th>".getMLText("version")."</th>\n";
print "<th>".getMLText("last_update")."</th>\n";
print "<th>".getMLText("actions")."</th>\n";
print "</tr>\n</thead>\n<tbody>\n";

if (count($resArr)>0) {
	foreach ($resArr as $res) {
		$owner = getUser($res["owner"]);
		print "<tr>\n";
		print "<td><img src=\"images/file.gif\" width=18 height=18 border=0></td>";
		print "<td><a href=\"out.ViewDocument.php?documentid=".$res["documentID"]."\">" . $res["name"] . "</a></td>\n";
		print "<td>".$owner->getFullName()."</td>";
		print "<td>".getOverallStatusText($res["status"])."</td>";
		print "<td class=\"center\">".$res["version"]."</td>";
		print "<td>".$res["statusDate"];
		$u = getUser($res["userID"]);
		if (is_object($u)) print " by ". $u->getFullName();
		print "</td><td>";
		print "<a href='../out/out.OverrideContentStatus.php?documentid=".$res["documentID"]."&version=".$res["version"]."'>Override Status</a>";
		print "</td></tr>\n";
	}
}
else {
	echo "<tr colspan=7><td>".getMLText("no_active_user_docs")."</td></tr>";
}
print "</tbody></table>";
UI::contentContainerEnd();
UI::htmlEndPage();
?>
