/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.UIResource;
import org.jhotdraw.gui.plaf.palette.PaletteLazyActionMap;
import org.jhotdraw.gui.plaf.palette.PaletteLookAndFeel;
import org.jhotdraw.gui.plaf.palette.PaletteToolBarBorder;

public class PaletteToolBarUI
extends ToolBarUI
implements SwingConstants {
    private static final boolean isFloatingAllowed = false;
    protected JToolBar toolBar;
    private boolean floating;
    private int floatingX;
    private int floatingY;
    private JFrame floatingFrame;
    private RootPaneContainer floatingToolBar;
    protected DragWindow dragWindow;
    private Container dockingSource;
    private int dockingSensitivity = 0;
    protected int focusedCompIndex = -1;
    protected Color dockingColor = null;
    protected Color floatingColor = null;
    protected Color dockingBorderColor = null;
    protected Color floatingBorderColor = null;
    protected MouseInputListener dockingListener;
    protected PropertyChangeListener propertyListener;
    protected ContainerListener toolBarContListener;
    protected FocusListener toolBarFocusListener;
    private Handler handler;
    protected Integer constraintBeforeFloating = new Integer(0);
    private static String IS_ROLLOVER = "JToolBar.isRollover";
    static String IS_DIVIDER_DRAWN = "Palette.ToolBar.isDividerDrawn";
    public static final String TOOLBAR_ICON_PROPERTY = "Palette.ToolBar.icon";
    public static final String TOOLBAR_TEXT_ICON_GAP_PROPERTY = "Palette.ToolBar.textIconGap";
    public static final String TOOLBAR_INSETS_OVERRIDE_PROPERTY = "Palette.ToolBar.insetsOverride";
    private static Border rolloverBorder;
    private static Border nonRolloverBorder;
    private static Border nonRolloverToggleBorder;
    private boolean rolloverBorders = false;
    private HashMap<AbstractButton, Border> borderTable = new HashMap();
    private Hashtable<AbstractButton, Boolean> rolloverTable = new Hashtable();
    @Deprecated
    protected KeyStroke upKey;
    @Deprecated
    protected KeyStroke downKey;
    @Deprecated
    protected KeyStroke leftKey;
    @Deprecated
    protected KeyStroke rightKey;
    private static String FOCUSED_COMP_INDEX;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PaletteToolBarUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.toolBar = (JToolBar)jComponent;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
        this.dockingSensitivity = 0;
        this.floating = false;
        this.floatingY = 0;
        this.floatingX = 0;
        this.floatingToolBar = null;
        this.setOrientation(this.toolBar.getOrientation());
        LookAndFeel.installProperty(jComponent, "opaque", Boolean.TRUE);
        if (jComponent.getClientProperty(FOCUSED_COMP_INDEX) != null) {
            this.focusedCompIndex = (Integer)jComponent.getClientProperty(FOCUSED_COMP_INDEX);
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        if (this.isFloating()) {
            this.setFloating(false, null);
        }
        this.floatingToolBar = null;
        this.dragWindow = null;
        this.dockingSource = null;
        jComponent.putClientProperty(FOCUSED_COMP_INDEX, new Integer(this.focusedCompIndex));
    }

    protected void installDefaults() {
        Object object;
        PaletteLookAndFeel.installBorder(this.toolBar, "ToolBar.border");
        PaletteLookAndFeel.installColorsAndFont(this.toolBar, "ToolBar.background", "ToolBar.foreground", "ToolBar.font");
        if (this.dockingColor == null || this.dockingColor instanceof UIResource) {
            this.dockingColor = UIManager.getColor("ToolBar.dockingBackground");
        }
        if (this.floatingColor == null || this.floatingColor instanceof UIResource) {
            this.floatingColor = UIManager.getColor("ToolBar.floatingBackground");
        }
        if (this.dockingBorderColor == null || this.dockingBorderColor instanceof UIResource) {
            this.dockingBorderColor = UIManager.getColor("ToolBar.dockingForeground");
        }
        if (this.floatingBorderColor == null || this.floatingBorderColor instanceof UIResource) {
            this.floatingBorderColor = UIManager.getColor("ToolBar.floatingForeground");
        }
        if ((object = this.toolBar.getClientProperty(IS_ROLLOVER)) == null) {
            object = UIManager.get("ToolBar.isRollover");
        }
        if (object != null) {
            this.rolloverBorders = (Boolean)object;
        }
        if (rolloverBorder == null) {
            rolloverBorder = this.createRolloverBorder();
        }
        if (nonRolloverBorder == null) {
            nonRolloverBorder = this.createNonRolloverBorder();
        }
        if (nonRolloverToggleBorder == null) {
            nonRolloverToggleBorder = this.createNonRolloverToggleBorder();
        }
        this.setRolloverBorders(this.isRolloverBorders());
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.toolBar);
        this.dockingColor = null;
        this.floatingColor = null;
        this.dockingBorderColor = null;
        this.floatingBorderColor = null;
        this.installNormalBorders(this.toolBar);
        rolloverBorder = null;
        nonRolloverBorder = null;
        nonRolloverToggleBorder = null;
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected void installListeners() {
        this.dockingListener = this.createDockingListener();
        if (this.dockingListener != null) {
            this.toolBar.addMouseMotionListener(this.dockingListener);
            this.toolBar.addMouseListener(this.dockingListener);
        }
        this.propertyListener = this.createPropertyListener();
        if (this.propertyListener != null) {
            this.toolBar.addPropertyChangeListener(this.propertyListener);
        }
        this.toolBarContListener = this.createToolBarContListener();
        if (this.toolBarContListener != null) {
            this.toolBar.addContainerListener(this.toolBarContListener);
        }
        this.toolBarFocusListener = this.createToolBarFocusListener();
        if (this.toolBarFocusListener != null) {
            Component[] componentArray = this.toolBar.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                componentArray[i].addFocusListener(this.toolBarFocusListener);
            }
        }
    }

    protected void uninstallListeners() {
        if (this.dockingListener != null) {
            this.toolBar.removeMouseMotionListener(this.dockingListener);
            this.toolBar.removeMouseListener(this.dockingListener);
            this.dockingListener = null;
        }
        if (this.propertyListener != null) {
            this.toolBar.removePropertyChangeListener(this.propertyListener);
            this.propertyListener = null;
        }
        if (this.toolBarContListener != null) {
            this.toolBar.removeContainerListener(this.toolBarContListener);
            this.toolBarContListener = null;
        }
        if (this.toolBarFocusListener != null) {
            Component[] componentArray = this.toolBar.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                componentArray[i].removeFocusListener(this.toolBarFocusListener);
            }
            this.toolBarFocusListener = null;
        }
        this.handler = null;
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.toolBar, 1, inputMap);
        PaletteLazyActionMap.installLazyActionMap(this.toolBar, PaletteToolBarUI.class, "ToolBar.actionMap");
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)PaletteLookAndFeel.getInstance().get("ToolBar.ancestorInputMap");
        }
        return null;
    }

    static void loadActionMap(PaletteLazyActionMap paletteLazyActionMap) {
        paletteLazyActionMap.put(new Actions("navigateRight"));
        paletteLazyActionMap.put(new Actions("navigateLeft"));
        paletteLazyActionMap.put(new Actions("navigateUp"));
        paletteLazyActionMap.put(new Actions("navigateDown"));
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.toolBar, null);
        SwingUtilities.replaceUIInputMap(this.toolBar, 1, null);
    }

    protected void navigateFocusedComp(int n) {
        int n2 = this.toolBar.getComponentCount();
        block0 : switch (n) {
            case 3: 
            case 5: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= n2) break;
                int n3 = this.focusedCompIndex + 1;
                while (n3 != this.focusedCompIndex) {
                    Component component;
                    if (n3 >= n2) {
                        n3 = 0;
                    }
                    if ((component = this.toolBar.getComponentAtIndex(n3++)) == null || !component.isFocusTraversable() || !component.isEnabled()) continue;
                    component.requestFocus();
                    break block0;
                }
                break;
            }
            case 1: 
            case 7: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= n2) break;
                int n4 = this.focusedCompIndex - 1;
                while (n4 != this.focusedCompIndex) {
                    Component component;
                    if (n4 < 0) {
                        n4 = n2 - 1;
                    }
                    if ((component = this.toolBar.getComponentAtIndex(n4--)) == null || !component.isFocusTraversable() || !component.isEnabled()) continue;
                    component.requestFocus();
                    break block0;
                }
                break;
            }
        }
    }

    protected Border createRolloverBorder() {
        Object object = UIManager.get("ToolBar.rolloverBorder");
        if (object != null) {
            return (Border)object;
        }
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        return new EmptyBorder(0, 0, 0, 0);
    }

    protected Border createNonRolloverBorder() {
        Object object = UIManager.get("ToolBar.nonrolloverBorder");
        if (object != null) {
            return (Border)object;
        }
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        return new EmptyBorder(0, 0, 0, 0);
    }

    private Border createNonRolloverToggleBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        return new EmptyBorder(0, 0, 0, 0);
    }

    protected JFrame createFloatingFrame(JToolBar jToolBar) {
        Window window = SwingUtilities.getWindowAncestor(jToolBar);
        JFrame jFrame = new JFrame(jToolBar.getName(), window != null ? window.getGraphicsConfiguration() : null){

            @Override
            protected JRootPane createRootPane() {
                JRootPane jRootPane = new JRootPane(){
                    private boolean packing = false;

                    @Override
                    public void validate() {
                        super.validate();
                        if (!this.packing) {
                            this.packing = true;
                            this.pack();
                            this.packing = false;
                        }
                    }
                };
                jRootPane.setOpaque(true);
                return jRootPane;
            }
        };
        jFrame.getRootPane().setName("ToolBar.FloatingFrame");
        jFrame.setResizable(false);
        WindowListener windowListener = this.createFrameListener();
        jFrame.addWindowListener(windowListener);
        return jFrame;
    }

    protected RootPaneContainer createFloatingWindow(JToolBar jToolBar) {
        Window window = SwingUtilities.getWindowAncestor(jToolBar);
        class ToolBarDialog
        extends JDialog {
            public ToolBarDialog(Frame frame, String string, boolean bl) {
                super(frame, string, bl);
            }

            public ToolBarDialog(Dialog dialog, String string, boolean bl) {
                super(dialog, string, bl);
            }

            @Override
            protected JRootPane createRootPane() {
                JRootPane jRootPane = new JRootPane(){
                    private boolean packing = false;

                    @Override
                    public void validate() {
                        super.validate();
                        if (!this.packing) {
                            this.packing = true;
                            this.pack();
                            this.packing = false;
                        }
                    }
                };
                jRootPane.setOpaque(true);
                return jRootPane;
            }
        }
        ToolBarDialog toolBarDialog = window instanceof Frame ? new ToolBarDialog((Frame)window, jToolBar.getName(), false) : (window instanceof Dialog ? new ToolBarDialog((Dialog)window, jToolBar.getName(), false) : new ToolBarDialog((Frame)null, jToolBar.getName(), false));
        toolBarDialog.getRootPane().setName("ToolBar.FloatingWindow");
        toolBarDialog.setTitle(jToolBar.getName());
        toolBarDialog.setResizable(false);
        WindowListener windowListener = this.createFrameListener();
        toolBarDialog.addWindowListener(windowListener);
        return toolBarDialog;
    }

    protected DragWindow createDragWindow(JToolBar jToolBar) {
        Container container;
        Window window = null;
        if (this.toolBar != null) {
            for (container = this.toolBar.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
            }
            if (container != null && container instanceof Window) {
                window = (Window)container;
            }
        }
        if (this.floatingToolBar == null) {
            this.floatingToolBar = this.createFloatingWindow(this.toolBar);
        }
        if (this.floatingToolBar instanceof Window) {
            window = (Window)((Object)this.floatingToolBar);
        }
        if ((container = new DragWindow(window)) instanceof RootPaneContainer) {
            JRootPane jRootPane = container.getRootPane();
            jRootPane.putClientProperty("Window.alpha", new Float(0.6f));
        }
        return container;
    }

    public boolean isRolloverBorders() {
        return this.rolloverBorders;
    }

    public void setRolloverBorders(boolean bl) {
        this.rolloverBorders = bl;
        if (this.rolloverBorders) {
            this.installRolloverBorders(this.toolBar);
        } else {
            this.installNonRolloverBorders(this.toolBar);
        }
    }

    protected void installRolloverBorders(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JComponent)) continue;
            ((JComponent)componentArray[i]).updateUI();
            this.setBorderToRollover(componentArray[i]);
        }
    }

    protected void installNonRolloverBorders(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JComponent)) continue;
            ((JComponent)componentArray[i]).updateUI();
            this.setBorderToNonRollover(componentArray[i]);
        }
    }

    protected void installNormalBorders(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            this.setBorderToNormal(componentArray[i]);
        }
    }

    protected void setBorderToRollover(Component component) {
    }

    private Border getRolloverBorder(AbstractButton abstractButton) {
        Object object = UIManager.get("ToolBar.rolloverBorderProvider");
        if (object == null) {
            return rolloverBorder;
        }
        return null;
    }

    protected void setBorderToNonRollover(Component component) {
    }

    protected void setBorderToNormal(Component component) {
    }

    public void setFloatingLocation(int n, int n2) {
        this.floatingX = n;
        this.floatingY = n2;
    }

    public boolean isFloating() {
        return this.floating;
    }

    public void setFloating(boolean bl, Point point) {
        if (this.toolBar.isFloatable()) {
            if (this.dragWindow != null) {
                this.dragWindow.setVisible(false);
            }
            this.floating = bl;
            if (bl) {
                // empty if block
            }
            if (this.floatingToolBar == null) {
                this.floatingToolBar = this.createFloatingWindow(this.toolBar);
            }
            if (this.floatingToolBar instanceof Window) {
                ((Window)((Object)this.floatingToolBar)).setVisible(false);
            }
            this.floatingToolBar.getContentPane().remove(this.toolBar);
            Serializable serializable = this.getDockingConstraint(this.dockingSource, point);
            if (serializable == null) {
                serializable = new Integer(0);
            }
            int n = this.mapConstraintToOrientation(serializable);
            this.setOrientation(n);
            if (this.dockingSource == null) {
                this.dockingSource = this.toolBar.getParent();
            }
            if (this.propertyListener != null) {
                UIManager.removePropertyChangeListener(this.propertyListener);
            }
            this.dockingSource.add((Component)this.toolBar, (Integer)serializable);
            this.dockingSource.invalidate();
            serializable = this.dockingSource.getParent();
            if (serializable != null) {
                ((Container)serializable).validate();
            }
            this.dockingSource.repaint();
        }
    }

    private int mapConstraintToOrientation(Object object) {
        int n = this.toolBar.getOrientation();
        if (object != null) {
            if (object.equals("East") || object.equals("West")) {
                n = 1;
            } else if (object.equals("North") || object.equals("South")) {
                n = 0;
            }
        }
        return n;
    }

    public void setOrientation(int n) {
        this.toolBar.setOrientation(n);
        if (this.dragWindow != null) {
            this.dragWindow.setOrientation(n);
        }
    }

    public Color getDockingColor() {
        return this.dockingColor;
    }

    public void setDockingColor(Color color) {
        this.dockingColor = color;
    }

    public Color getFloatingColor() {
        return this.floatingColor;
    }

    public void setFloatingColor(Color color) {
        this.floatingColor = color;
    }

    private boolean isBlocked(Component component, Object object) {
        Container container;
        LayoutManager layoutManager;
        if (component instanceof Container && (layoutManager = (container = (Container)component).getLayout()) instanceof BorderLayout) {
            BorderLayout borderLayout = (BorderLayout)layoutManager;
            Component component2 = borderLayout.getLayoutComponent(container, object);
            return component2 != null && component2 != this.toolBar;
        }
        return false;
    }

    public boolean canDock(Component component, Point point) {
        return point != null && this.getDockingConstraint(component, point) != null;
    }

    private Integer calculateConstraint() {
        Integer n = null;
        LayoutManager layoutManager = this.dockingSource.getLayout();
        if (layoutManager instanceof BoxLayout) {
            int n2 = this.dockingSource.getComponentCount();
            for (int i = 0; i < n2; ++i) {
                if (this.dockingSource.getComponent(i) != this.toolBar) continue;
                n = new Integer(i);
                break;
            }
        }
        return n != null ? n : this.constraintBeforeFloating;
    }

    private Integer getDockingConstraint(Component component, Point point) {
        if (point == null) {
            return this.constraintBeforeFloating;
        }
        if (component.contains(point)) {
            int n = this.dockingSource.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Point point2;
                Component component2 = this.dockingSource.getComponent(i);
                if (!component2.contains(point2 = new Point(point.x - component2.getX(), point.y - component2.getY()))) continue;
                return new Integer(Math.min(n - 1, point2.x <= component2.getWidth() ? i : i + 1));
            }
            if (this.dockingSource.getComponentCount() == 0 || point.x < this.dockingSource.getComponent(0).getX()) {
                return 0;
            }
            return this.dockingSource.getComponentCount() - 1;
        }
        return null;
    }

    protected void dragTo(Point point, Point point2) {
        if (this.toolBar.isFloatable()) {
            try {
                Serializable serializable;
                Cloneable cloneable;
                Point point3;
                if (this.dragWindow == null) {
                    this.dragWindow = this.createDragWindow(this.toolBar);
                }
                if ((point3 = this.dragWindow.getOffset()) == null) {
                    cloneable = this.toolBar.getSize();
                    point3 = new Point(cloneable.width / 2, cloneable.height / 2);
                    this.dragWindow.setOffset(point3);
                }
                cloneable = new Point(point2.x + point.x, point2.y + point.y);
                Point point4 = new Point(((Point)cloneable).x - point3.x, ((Point)cloneable).y - point3.y);
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                this.constraintBeforeFloating = this.calculateConstraint();
                Point point5 = this.dockingSource.getLocationOnScreen();
                Point point6 = new Point(((Point)cloneable).x - point5.x, ((Point)cloneable).y - point5.y);
                if (this.canDock(this.dockingSource, point6)) {
                    this.dragWindow.setBackground(this.getDockingColor());
                    serializable = this.getDockingConstraint(this.dockingSource, point6);
                    int n = this.mapConstraintToOrientation(serializable);
                    this.dragWindow.setOrientation(n);
                    this.dragWindow.setBorderColor(this.dockingBorderColor);
                } else {
                    this.dragWindow.setBackground(this.getFloatingColor());
                    this.dragWindow.setBorderColor(this.floatingBorderColor);
                }
                this.dragWindow.setLocation(point4.x, point4.y);
                if (!this.dragWindow.isVisible()) {
                    serializable = this.toolBar.getSize();
                    this.dragWindow.setSize(((Dimension)serializable).width, ((Dimension)serializable).height);
                    this.dragWindow.show();
                }
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    protected void floatAt(Point point, Point point2) {
        if (this.toolBar.isFloatable()) {
            try {
                Point point3 = this.dragWindow.getOffset();
                if (point3 == null) {
                    point3 = point;
                    this.dragWindow.setOffset(point3);
                }
                Point point4 = new Point(point2.x + point.x, point2.y + point.y);
                this.setFloatingLocation(point4.x - point3.x, point4.y - point3.y);
                if (this.dockingSource != null) {
                    Point point5 = this.dockingSource.getLocationOnScreen();
                    Point point6 = new Point(point4.x - point5.x, point4.y - point5.y);
                    if (this.canDock(this.dockingSource, point6)) {
                        this.setFloating(false, point6);
                    } else {
                        this.setFloating(true, null);
                    }
                } else {
                    this.setFloating(true, null);
                }
                this.dragWindow.setOffset(null);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected ContainerListener createToolBarContListener() {
        return this.getHandler();
    }

    protected FocusListener createToolBarFocusListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createPropertyListener() {
        return this.getHandler();
    }

    protected MouseInputListener createDockingListener() {
        this.getHandler().tb = this.toolBar;
        return this.getHandler();
    }

    protected WindowListener createFrameListener() {
        return new FrameListener();
    }

    protected void paintDragWindow(Graphics graphics) {
        int n = this.dragWindow.getWidth();
        int n2 = this.dragWindow.getHeight();
        graphics.setColor(this.dragWindow.getBackground());
        graphics.fillRect(0, 0, n, n2);
        boolean bl = false;
        if (this.toolBar.isDoubleBuffered()) {
            bl = true;
            this.toolBar.setDoubleBuffered(false);
        }
        Graphics graphics2 = graphics.create();
        this.toolBar.paintAll(graphics2);
        graphics2.dispose();
        graphics.setColor(this.dragWindow.getBorderColor());
        graphics.drawRect(0, 0, n - 1, n2 - 1);
        if (bl) {
            this.toolBar.setDoubleBuffered(true);
        }
    }

    static {
        FOCUSED_COMP_INDEX = "JToolBar.focusedCompIndex";
    }

    private static class Actions
    extends AbstractAction {
        private static final String NAVIGATE_RIGHT = "navigateRight";
        private static final String NAVIGATE_LEFT = "navigateLeft";
        private static final String NAVIGATE_UP = "navigateUp";
        private static final String NAVIGATE_DOWN = "navigateDown";

        public Actions(String string) {
            super(string);
        }

        public String getName() {
            return (String)this.getValue("Name");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getName();
            JToolBar jToolBar = (JToolBar)actionEvent.getSource();
            PaletteToolBarUI paletteToolBarUI = (PaletteToolBarUI)PaletteLookAndFeel.getUIOfType(jToolBar.getUI(), PaletteToolBarUI.class);
            if (NAVIGATE_RIGHT == string) {
                paletteToolBarUI.navigateFocusedComp(3);
            } else if (NAVIGATE_LEFT == string) {
                paletteToolBarUI.navigateFocusedComp(7);
            } else if (NAVIGATE_UP == string) {
                paletteToolBarUI.navigateFocusedComp(1);
            } else if (NAVIGATE_DOWN == string) {
                paletteToolBarUI.navigateFocusedComp(5);
            }
        }
    }

    public class DockingListener
    implements MouseInputListener {
        protected JToolBar toolBar;
        protected boolean isDragging = false;
        protected Point origin = null;

        public DockingListener(JToolBar jToolBar) {
            this.toolBar = jToolBar;
            ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().tb = jToolBar;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            PaletteToolBarUI.this.getHandler().mouseClicked(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().tb = this.toolBar;
            PaletteToolBarUI.this.getHandler().mousePressed(mouseEvent);
            this.isDragging = ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().isDragging;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().tb = this.toolBar;
            ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().isDragging = this.isDragging;
            ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().origin = this.origin;
            PaletteToolBarUI.this.getHandler().mouseReleased(mouseEvent);
            this.isDragging = ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().isDragging;
            this.origin = ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().origin;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            PaletteToolBarUI.this.getHandler().mouseEntered(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            PaletteToolBarUI.this.getHandler().mouseExited(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().tb = this.toolBar;
            ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().origin = this.origin;
            PaletteToolBarUI.this.getHandler().mouseDragged(mouseEvent);
            this.isDragging = ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().isDragging;
            this.origin = ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().origin;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            PaletteToolBarUI.this.getHandler().mouseMoved(mouseEvent);
        }
    }

    protected class DragWindow
    extends JWindow {
        Color borderColor;
        int orientation;
        Point offset;

        DragWindow(Window window) {
            super(window);
            this.borderColor = Color.gray;
            this.orientation = PaletteToolBarUI.this.toolBar.getOrientation();
            this.getContentPane().add(new JPanel(){

                @Override
                public void paintComponent(Graphics graphics) {
                    PaletteToolBarUI.this.paintDragWindow(graphics);
                }
            });
        }

        public void setOrientation(int n) {
            if (this.isShowing()) {
                if (n == this.orientation) {
                    return;
                }
                this.orientation = n;
                Dimension dimension = this.getSize();
                this.setSize(new Dimension(dimension.height, dimension.width));
                if (this.offset != null) {
                    if (PaletteToolBarUI.this.toolBar.getComponentOrientation().isLeftToRight()) {
                        this.setOffset(new Point(this.offset.y, this.offset.x));
                    } else if (n == 0) {
                        this.setOffset(new Point(dimension.height - this.offset.y, this.offset.x));
                    } else {
                        this.setOffset(new Point(this.offset.y, dimension.width - this.offset.x));
                    }
                }
                this.repaint();
            }
        }

        public Point getOffset() {
            return this.offset;
        }

        public void setOffset(Point point) {
            this.offset = point;
        }

        public void setBorderColor(Color color) {
            if (this.borderColor == color) {
                return;
            }
            this.borderColor = color;
            this.repaint();
        }

        public Color getBorderColor() {
            return this.borderColor;
        }

        @Override
        public Insets getInsets() {
            return new Insets(1, 1, 1, 1);
        }
    }

    protected class FrameListener
    extends WindowAdapter {
        protected FrameListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (PaletteToolBarUI.this.toolBar.isFloatable()) {
                if (PaletteToolBarUI.this.dragWindow != null) {
                    PaletteToolBarUI.this.dragWindow.setVisible(false);
                }
                PaletteToolBarUI.this.floating = false;
                if (PaletteToolBarUI.this.floatingToolBar == null) {
                    PaletteToolBarUI.this.floatingToolBar = PaletteToolBarUI.this.createFloatingWindow(PaletteToolBarUI.this.toolBar);
                }
                if (PaletteToolBarUI.this.floatingToolBar instanceof Window) {
                    ((Window)((Object)PaletteToolBarUI.this.floatingToolBar)).setVisible(false);
                }
                PaletteToolBarUI.this.floatingToolBar.getContentPane().remove(PaletteToolBarUI.this.toolBar);
                Integer n = PaletteToolBarUI.this.constraintBeforeFloating;
                if (PaletteToolBarUI.this.dockingSource == null) {
                    PaletteToolBarUI.this.dockingSource = PaletteToolBarUI.this.toolBar.getParent();
                }
                if (PaletteToolBarUI.this.propertyListener != null) {
                    UIManager.removePropertyChangeListener(PaletteToolBarUI.this.propertyListener);
                }
                PaletteToolBarUI.this.dockingSource.add((Component)PaletteToolBarUI.this.toolBar, n);
                PaletteToolBarUI.this.dockingSource.invalidate();
                Container container = PaletteToolBarUI.this.dockingSource.getParent();
                if (container != null) {
                    container.validate();
                }
                PaletteToolBarUI.this.dockingSource.repaint();
            }
        }
    }

    private class Handler
    implements ContainerListener,
    FocusListener,
    MouseInputListener,
    PropertyChangeListener {
        JToolBar tb;
        boolean isDragging = false;
        Point origin = null;
        boolean isArmed = false;

        private Handler() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (PaletteToolBarUI.this.toolBarFocusListener != null) {
                component.addFocusListener(PaletteToolBarUI.this.toolBarFocusListener);
            }
            if (PaletteToolBarUI.this.isRolloverBorders()) {
                PaletteToolBarUI.this.setBorderToRollover(component);
            } else {
                PaletteToolBarUI.this.setBorderToNonRollover(component);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (PaletteToolBarUI.this.toolBarFocusListener != null) {
                component.removeFocusListener(PaletteToolBarUI.this.toolBarFocusListener);
            }
            PaletteToolBarUI.this.setBorderToNormal(component);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            PaletteToolBarUI.this.focusedCompIndex = PaletteToolBarUI.this.toolBar.getComponentIndex(component);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.tb.isEnabled()) {
                return;
            }
            this.isDragging = false;
            if (mouseEvent.getSource() instanceof JToolBar) {
                JComponent jComponent = (JComponent)mouseEvent.getSource();
                Insets insets = jComponent.getBorder() instanceof PaletteToolBarBorder ? ((PaletteToolBarBorder)jComponent.getBorder()).getDragInsets(jComponent) : jComponent.getInsets();
                this.isArmed = mouseEvent.getX() <= insets.left || mouseEvent.getX() >= jComponent.getWidth() - insets.right || mouseEvent.getY() <= insets.top || mouseEvent.getY() >= jComponent.getHeight() - insets.bottom;
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.tb.isEnabled()) {
                return;
            }
            if (this.isDragging) {
                Point point = mouseEvent.getPoint();
                if (this.origin == null) {
                    this.origin = mouseEvent.getComponent().getLocationOnScreen();
                }
                PaletteToolBarUI.this.floatAt(point, this.origin);
            }
            this.origin = null;
            this.isDragging = false;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this.tb.isEnabled()) {
                return;
            }
            if (!this.isArmed) {
                return;
            }
            this.isDragging = true;
            Point point = mouseEvent.getPoint();
            if (this.origin == null) {
                this.origin = mouseEvent.getComponent().getLocationOnScreen();
            }
            PaletteToolBarUI.this.dragTo(point, this.origin);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "lookAndFeel") {
                PaletteToolBarUI.this.toolBar.updateUI();
            } else if (string == "orientation") {
                Component[] componentArray = PaletteToolBarUI.this.toolBar.getComponents();
                int n = (Integer)propertyChangeEvent.getNewValue();
                for (int i = 0; i < componentArray.length; ++i) {
                    if (!(componentArray[i] instanceof JToolBar.Separator)) continue;
                    JToolBar.Separator separator = (JToolBar.Separator)componentArray[i];
                    if (n == 0) {
                        separator.setOrientation(1);
                    } else {
                        separator.setOrientation(0);
                    }
                    Dimension dimension = separator.getSeparatorSize();
                    if (dimension == null || dimension.width == dimension.height) continue;
                    Dimension dimension2 = new Dimension(dimension.height, dimension.width);
                    separator.setSeparatorSize(dimension2);
                }
            } else if (string == IS_ROLLOVER) {
                PaletteToolBarUI.this.installNormalBorders(PaletteToolBarUI.this.toolBar);
                PaletteToolBarUI.this.setRolloverBorders((Boolean)propertyChangeEvent.getNewValue());
            }
        }
    }

    protected class PropertyListener
    implements PropertyChangeListener {
        protected PropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PaletteToolBarUI.this.getHandler().propertyChange(propertyChangeEvent);
        }
    }

    protected class ToolBarContListener
    implements ContainerListener {
        protected ToolBarContListener() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            PaletteToolBarUI.this.getHandler().componentAdded(containerEvent);
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            PaletteToolBarUI.this.getHandler().componentRemoved(containerEvent);
        }
    }

    protected class ToolBarFocusListener
    implements FocusListener {
        protected ToolBarFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            PaletteToolBarUI.this.getHandler().focusGained(focusEvent);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            PaletteToolBarUI.this.getHandler().focusLost(focusEvent);
        }
    }
}

