/*
   Copyright (c) 2000,2001 Dave Carrigan <dave@rudedog.org>
   All rights reserved.
    
   This module is free software; you can redistribute it and/or modify
   it under the same terms as Apache itself. This module is
   distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. The copyright holder of this
   module can not be held liable for any general, special, incidental
   or consequential damages arising out of the use of the module.

   $Id: auth_ldap_cache_mgr.h,v 1.4 2001/02/16 23:06:20 dave Exp $
*/
#ifndef __AUTH_LDAP_CACHE_MGMR_H__
#define __AUTH_LDAP_CACHE_MGMR_H__

#ifdef WITH_SHARED_LDAP_CACHE
#include <ap_mm.h>
#endif

typedef struct cache_node {
  void *payload;		/* Pointer to the payload */
  time_t add_time;		/* Time node was added to cache */
  struct cache_node *next;
} cache_node;

typedef struct ald_cache {
  unsigned long size;		/* Size of cache array */
  unsigned long maxentries;	/* Maximum number of cache entries */
  unsigned long numentries;	/* Current number of cache entries */
  unsigned long fullmark;	/* Used to keep track of when cache becomes 3/4 full */
  time_t marktime;		/* Time that the cache became 3/4 full */
  unsigned long (*hash)(void *);  /* Func to hash the payload */
  int (*compare)(void *, void *); /* Func to compare two payloads */
  void * (*copy)(void *); /* Func to alloc mem and copy payload to new mem */
  void (*free)(void *);	  /* Func to free mem used by the payload */
  cache_node **nodes;

  unsigned long numpurges;	/* No. of times the cache has been purged */
  double avg_purgetime;		/* Average time to purge the cache */
  time_t last_purge;		/* Time of the last purge */
  unsigned long npurged;	/* Number of elements purged in last purge. This is not
				   obvious: it won't be 3/4 the size of the cache if 
				   there were a lot of expired entries. */

  unsigned long fetches;	/* Number of fetches */
  unsigned long hits;		/* Number of cache hits */
  unsigned long inserts;	/* Number of inserts */
  unsigned long removes;	/* Number of removes */
} ald_cache;

unsigned long ald_hash_string(int, ...);

char * ald_strdup(char *);
void * ald_alloc(int);
void ald_free(void *);

ald_cache *ald_create_cache(unsigned long, 
			    unsigned long (*)(void *),  /* hash */
			    int (*)(void *, void *),    /* compare */
			    void * (*)(void *), /* copy */
			    void (*)(void *));   /* free */
void ald_destroy_cache(ald_cache *);
void * ald_cache_fetch(ald_cache *, void *);
void ald_cache_insert(ald_cache *, void *);
void ald_cache_remove(ald_cache *, void *);
void ald_cache_display_stats(ald_cache *, request_rec *, char *);


#endif
