/***************************************************************************
                          misc.c  -  description
                             -------------------
    begin                : Thu Sep 6 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "lbreakout.h"
#include "config.h"
#include "event.h"
#include "misc.h"
#ifdef SOUND
#include "audio.h"
#endif

extern Sdl sdl;
extern SDL_Surface *offscreen;
extern int term_game;
int shadow_size = 10;
#ifdef SOUND
extern Sound_Chunk *wav_click;
#endif
extern int motion_button;
extern Config config;
extern int bkgnd_count;
extern SDL_Surface *bkgnds[BACK_COUNT];

char circle_msg[256];

/*
====================================================================
Load background according to id and draw background to offscreen.
Return Value: loaded background surface
====================================================================
*/
SDL_Surface* bkgnd_draw( int id )
{
    SDL_Surface *bkgnd = 0;
    SDL_Surface *pic = 0;
    int i, j;

	if ( id >= bkgnd_count ) id = 0;
    if ( id == -1 ) id = rand() % bkgnd_count;
    
    /* background is always the size of screen */
    bkgnd = create_surf( sdl.screen->w, sdl.screen->h, SDL_SWSURFACE );
    SDL_SetColorKey( bkgnd, 0, 0 );
    FULL_DEST( bkgnd ); fill_surf( 0x0 );

    /* load background */
    pic = bkgnds[id];
    for ( i = 0; i < bkgnd->w; i += pic->w ) {
        for ( j = 0; j < bkgnd->h; j += pic->h ) {
            DEST( bkgnd, i, j, pic->w, pic->h );
            SOURCE( pic, 0, 0 );
            blit_surf();
        }
    }

    /* draw to offscreen */
    FULL_DEST( offscreen ); FULL_SOURCE( bkgnd ); blit_surf();

    return bkgnd;
}
/*
====================================================================
Confirm request. Darkens screen a bit and display text.
Return Value: True if successful
====================================================================
*/
void draw_confirm_screen( Font *font, SDL_Surface *buffer, char *str )
{
    FULL_DEST(sdl.screen);
    fill_surf(0x0);
    FULL_SOURCE(buffer);
    alpha_blit_surf(128);
    font->align = ALIGN_X_CENTER | ALIGN_Y_CENTER;
    write_text(font, sdl.screen, sdl.screen->w / 2, sdl.screen->h / 2, str, 0);
}
int confirm( Font *font, char *str, int type )
{
    SDL_Event event;
    int go_on = 1;
    int ret = 0;
    SDL_Surface *buffer = create_surf(sdl.screen->w, sdl.screen->h, SDL_SWSURFACE);
    SDL_SetColorKey(buffer, 0, 0);

#ifdef SOUND
    sound_play( wav_click );
#endif

    event_block_motion( 1 );

    FULL_DEST(buffer);
    FULL_SOURCE(sdl.screen);
    blit_surf();
	draw_confirm_screen( font, buffer, str );
    refresh_screen( 0, 0, 0, 0 );

    while (go_on && !term_game) {
        SDL_WaitEvent(&event);
        /* TEST */
        switch ( event.type ) {
            case SDL_QUIT: term_game = 1; break;
            case SDL_MOUSEBUTTONUP:
                if ( type == CONFIRM_ANY_KEY ) {
                    ret = 1; go_on = 0;
                }
/*                else
                if ( type == CONFIRM_YES_NO ) {
                    if ( event.button.button == LEFT_BUTTON )
                        ret = 1;
                    else
                        ret = 0;
                    go_on = 0;
                }*/
                break;
            case SDL_KEYUP:
                if ( type == CONFIRM_ANY_KEY ) {
                    ret = 1; go_on = 0;
                    break;
                }
                else
                if ( type == CONFIRM_PAUSE ) {
                    if ( event.key.keysym.sym == SDLK_p ) {
                        ret = 1; go_on = 0;
                        break;
                    }
					else
					if ( event.key.keysym.sym == SDLK_f ) {
						config.fullscreen = !config.fullscreen;
						set_video_mode( std_video_mode( config.fullscreen ) );
						draw_confirm_screen( font, buffer, str );
						refresh_screen( 0, 0, 0, 0 );
					}
                }
                else
                switch (event.key.keysym.sym) {
                    case SDLK_y:
                        go_on = 0;
                        ret = 1;
                        break;
                    case SDLK_ESCAPE:
                    case SDLK_n:
                        go_on = 0;
                        ret = 0;
                    default:
                        break;
                }
                break;
        }
    }
#ifdef SOUND
    sound_play( wav_click );
#endif
    FULL_DEST(sdl.screen);
    FULL_SOURCE(buffer);
    blit_surf();
    refresh_screen( 0, 0, 0, 0 );
    SDL_FreeSurface(buffer);

    event_block_motion( 0 );

    return ret;
}
/*
====================================================================
Create shadow surface for specified region in surface.
Return Value: Shadow surface
====================================================================
*/
SDL_Surface* create_shadow( SDL_Surface *surf, int x, int y, int w, int h )
{
    SDL_Surface *shadow = 0;
    int i, j;
    Uint32 white = SDL_MapRGB( sdl.screen->format, 0xff, 0xff, 0xff );
    Uint32 black = SDL_MapRGB( sdl.screen->format, 0, 0, 0 );
    shadow = create_surf( w, h, SDL_SWSURFACE );
    SDL_SetColorKey( shadow, SDL_SRCCOLORKEY, white );
    for ( i = 0; i < w; i++ )
        for ( j = 0; j < h; j++ ) {
            if ( get_pixel( surf, i, j ) == surf->format->colorkey )
                set_pixel( shadow, i, j, white );
            else
                set_pixel( shadow, i, j, black );
        }
    return shadow;
}

/*
====================================================================
Return vector struct with the specified coordinates.
====================================================================
*/
Vector vector_get( float x, float y )
{
    Vector v = { x, y };
    return v;
}
/*
====================================================================
Give vector the normed length of 1.
====================================================================
*/
void vector_norm( Vector *v )
{
    float length;
    if ( v->x == 0 && v->y == 0 ) return; /* NULL vector may not be normed */
    length = sqrt( v->x * v->x + v->y * v->y );
    v->x /= length;
    v->y /= length;
}
/*
====================================================================
Return monotony of vector. If vertical return 0
====================================================================
*/
float vector_monotony( Vector v )
{
    if ( v.x == 0 ) return 0;
    return v.y / v.x;
}

/*
====================================================================
Initiate a line struct.
====================================================================
*/
void line_set( Line *line, float x, float y, float m )
{
    line->vertical = 0;
    line->m = m;
    line->n = y - m*x;
}
void line_set_vert( Line *line, float x )
{
    line->vertical = 1;
    line->x = x;
}
void line_set_hori( Line *line, float y )
{
    line->vertical = 0;
    line->m = 0;
    line->n = y;
}
void line_set_pts( Line *line, float x, float y, float x2, float y2 )
{
    if ( x == x2 && y == y2 ) {
        fprintf( stderr, "Warning! Can't create line from two identical points (%4.2f,%4.2f)... bailing out. Result is undefined.\n", x, y );
        return;
    }
    if ( y == y2 ) line_set_hori( line, y );
    else
    if ( x == x2 ) line_set_vert( line, x );
    else
        line_set( line, x, y, ( y2 - y ) / ( x2 - x ) );
}
/*
====================================================================
Intersect lines and set 'pos' to intersecting point.
Return Value: True if lines intersect.
====================================================================
*/
int line_intersect( Line *line, Line *target, Coord *pos )
{
    /* reset pos */
    pos->x = pos->y = 0;
    /* if lines are parallel return False */
    if ( line->vertical && target->vertical ) return 0; /* vertical parallels */ 
    if ( !line->vertical &&  !target->vertical && line->m == target->m ) return 0; /* non-vertical parallels */
    /* right now only one thing is supported: line horizontal */
    if ( line->m == 0 && line->vertical == 0 ) {
        pos->y = line->n;
        if ( target->vertical )
            pos->x = target->x;
        else
            pos->x = ( pos->y - target->n ) / target->m;
        return 1;
    }
    if ( line->vertical ) {
        if ( target->vertical ) return 0;
        pos->x = line->x;
        pos->y = target->m * pos->x + target->n;
        return 1;
    }
    if ( target->vertical ) {
        printf( "line_intersect: line non-vertical and target vertical not supported yet\n" );
        return 1;
    }
    /* compute if both lines are neither vertical nor horizontal */
    pos->x = ( line->n - target->n ) / ( target->m - line->m );
    pos->y = line->m * pos->x + line->n;
    return 1;
}
/*
====================================================================
Return f(x)
====================================================================
*/
float line_y( Line *line, float x )
{
    if ( line->vertical ) return 0;
    return line->m * x + line->n;
}

/*
====================================================================
Intersect line pos+t*v with circle (x+m)=r
Important length of v MUST be 1.
Return Value: True if intersecting, Intersecting points
====================================================================
*/
int circle_intersect( Vector m, int r, Vector pos, Vector v, Vector *t1, Vector *t2 )
{
    Vector delta = { pos.x - m.x, pos.y - m.y };
    float  delta_v = delta.x * v.x + delta.y * v.y;
    float dis = delta_v * delta_v + r * r - ( delta.x * delta.x + delta.y * delta.y );
    float t;

    if ( dis < 0 ) {
#ifdef WITH_BUG_REPORT
		sprintf( circle_msg, "Diskriminante < 0" );
#endif		
		return 0; 
	}
	dis = sqrt( dis );

    t = -delta_v + dis;
    t1->x = pos.x + t * v.x; t1->y = pos.y + t * v.y;
    t = -delta_v - dis;
    t2->x = pos.x + t * v.x; t2->y = pos.y + t * v.y;
#ifdef WITH_BUG_REPORT
	sprintf( circle_msg, "Intersection points: (%4.2f,%4.2f), (%4.2f,%4.2f)", t1->x, t1->y, t2->x, t2->y );
#endif
    return 1;
}

/*
====================================================================
Enter a string and return True if ENTER received and False
if ESCAPE received.
====================================================================
*/
int enter_string( Font *font, char *caption, char *edit, int limit )
{
    SDL_Event event;
    int go_on = 1;
    int ret = 0;
    SDL_Surface *buffer = create_surf(sdl.screen->w, sdl.screen->h, SDL_SWSURFACE);
    int length = strlen( edit );
    int update = 1;

    SDL_SetColorKey(buffer, 0, 0);

    event_block_motion( 1 );

    FULL_DEST(buffer);
    FULL_SOURCE(sdl.screen);
    blit_surf();
    font->align = ALIGN_X_CENTER | ALIGN_Y_CENTER;

    while ( go_on && !term_game ) {
        if ( update ) {
            FULL_DEST(sdl.screen);
            fill_surf(0x0);
            FULL_SOURCE(buffer);
            alpha_blit_surf(128);
            write_text(font, sdl.screen, sdl.screen->w / 2, sdl.screen->h / 2, caption, OPAQUE);
            write_text(font, sdl.screen, sdl.screen->w / 2, sdl.screen->h / 2 + font->height, edit, OPAQUE);
            refresh_screen( 0, 0, 0, 0 );
            update = 0;
        }
        SDL_WaitEvent(&event);
        /* TEST */
        switch ( event.type ) {
            case SDL_QUIT: term_game = 1; break;
            case SDL_KEYUP:
                switch ( event.key.keysym.sym ) {
                    case SDLK_ESCAPE:
                        ret = 0;
                        go_on = 0;
                        break;
                    case SDLK_RETURN:
                        ret = 1;
                        go_on = 0;
                        break;
                    case SDLK_BACKSPACE:
                        if ( length > 0 ) edit[--length] = 0;
                        update = 1;
                        break;
                    default:
                        if ( event.key.keysym.sym >= 32 && event.key.keysym.sym < 128 && length < limit ) {
                            edit[length++] = event.key.keysym.unicode;
                            edit[length] = 0;
                            update = 1;
                        }
                        break;
                }
                break;
        }
    }

    FULL_DEST(sdl.screen);
    FULL_SOURCE(buffer);
    blit_surf();
    refresh_screen( 0, 0, 0, 0 );
    SDL_FreeSurface(buffer);

    event_block_motion( 0 );

    return ret;
}
