/***************************************************************************
                          credit.c  -  description
                             -------------------
    begin                : Thu Sep 13 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "lbreakout.h"
#include "credit.h"

extern Sdl sdl;
extern Font *font;
extern SDL_Surface *offscreen;

SDL_Surface *credit_bkgnd = 0;
float       credit_alpha;
float       credit_pms = 0.2;
int         credit_cur;
int         credit_time = 4000;
int         credit_x, credit_y, credit_w, credit_h;
char        credit_str[64];
int         credit_status;

/*
====================================================================
Initiate credit.
====================================================================
*/
void credit_init( char *name, char *author, int level )
{
    credit_cur = 0; credit_alpha = 255; credit_status = 0;

    /* string */
    sprintf( credit_str, "%s (%i) - %s", name, level + 1, author );

    /* position */
    credit_w = text_width( font, credit_str) + 4;
    credit_h = font->height + 4;
    credit_x = (sdl.screen->w - credit_w) / 2;
    credit_y = sdl.screen->h - 2 - credit_h;
    
    /* background */
    if ( credit_bkgnd ) SDL_FreeSurface( credit_bkgnd );
    credit_bkgnd = create_surf( credit_w, credit_h, SDL_SWSURFACE );
    SDL_SetColorKey( credit_bkgnd, 0, 0 );
    FULL_DEST( credit_bkgnd );
    fill_surf( 0x0 );
}
void credit_clear()
{
    if ( credit_bkgnd ) SDL_FreeSurface( credit_bkgnd ); credit_bkgnd = 0;
}
/*
====================================================================
Show/Hide credits
====================================================================
*/
void credit_hide()
{
    if (credit_status == 3) return;
    DEST(sdl.screen, credit_x, credit_y, credit_w, credit_h);
    SOURCE(offscreen, credit_x, credit_y);
    blit_surf();
    add_refresh_rect(credit_x, credit_y, credit_w, credit_h);
}
void credit_show( )
{
    if (credit_status == 3) return;
    if ( credit_bkgnd ) {
        DEST( sdl.screen, credit_x, credit_y, credit_w, credit_h );
        SOURCE( credit_bkgnd, 0, 0 );
        alpha_blit_surf( ( credit_alpha / 2 ) + 128 );
    }
    font->align = ALIGN_X_LEFT | ALIGN_Y_TOP;
    write_text(font, sdl.screen, credit_x + 2, credit_y + 2, credit_str, (int)credit_alpha);
    font->align = ALIGN_X_CENTER | ALIGN_Y_CENTER;
}
void credit_alphashow( int alpha )
{
    if (credit_status == 3) return;
    font->align = ALIGN_X_LEFT | ALIGN_Y_TOP;
    write_text(font, sdl.screen, credit_x + 2, credit_y + 2, credit_str, (int)alpha);
    font->align = ALIGN_X_CENTER | ALIGN_Y_CENTER;
    add_refresh_rect(credit_x, credit_y, credit_w, credit_h);
}
void credit_update( int ms )
{
    /* appearing */
    if (credit_status == 0) {
        credit_alpha -= credit_pms * ms;
        if (credit_alpha <= 0) {
            credit_status = 1;
            credit_alpha = 0;
        }
    }
    else
        /* visible */
        if (credit_status == 1) {
            credit_cur += ms;
            if (credit_cur > credit_time)
                credit_status = 2;
        }
        else
            /* disappearing */
            if (credit_status == 2) {
                credit_alpha += credit_pms * ms;
                if (credit_alpha >= 255)
                    credit_status = 3;
            }
    /* credit_status == 3 means credit disappeared */
}
