#ifndef SIMO_UTIL_CURSOR_H
#define SIMO_UTIL_CURSOR_H

#define SIMO_WAIT GDK_WATCH
#define SIMO_HAND GDK_HAND2
#define SIMO_ARROW GDK_ARROW

typedef GdkCursor * SimoCursor;

#define simo_cursor_new( t ) gdk_cursor_new( t )
#define simo_cursor_free( c ) gdk_cursor_unref( (GdkCursor*)c )
#define simo_cursor_set_delay( win, cursor )gdk_window_set_cursor( win, (GdkCursor*)cursor )

#ifdef GDK_WINDOWING_X11

  #define simo_cursor_set( win, cursor ) \
    gdk_window_set_cursor( win, cursor );

#elif defined( GDK_WINDOWING_WIN32 )
  
  typedef struct _GdkCursorPrivate GdkCursorPrivate;
  struct _GdkCursorPrivate
  {
    GdkCursor cursor;
    HCURSOR hcursor;
  };

  #define simo_cursor_set( win, cursor ) \
    if( cursor ){ \
      GdkCursorPrivate *priv = (GdkCursorPrivate*)cursor; \
      gdk_window_set_cursor( win, (GdkCursor*)cursor ); \
      SetCursor( priv->hcursor ); \
    }else{ \
      gdk_window_set_cursor( win, NULL ); \
      SetCursor( NULL ); \
    }

#endif
/*

//#define SIMO_WAIT GDK_WATCH
//#define SIMO_HAND GDK_HAND1
//#define SIMO_ARROW GDK_ARROW

  #if 0
  // as defined in gdkcursor-win32.h 
  // for getting access to the internals of GdkCursor
  typedef struct _GdkCursorPrivate GdkCursorPrivate;
  struct _GdkCursorPrivate
  {
    GdkCursor cursor;
    HCURSOR hcursor;
  };



  //#define SIMO_WAIT IDC_WAIT
  //#define SIMO_HAND IDC_HAND

  typedef gpointer SimoCursor;

  #define simo_cursor_set( win, cursor )\
    if( cursor ){ \
      GdkCursorPrivate *priv = (GdkCursorPrivate*)cursor; \
      gdk_window_set_cursor( win, (GdkCursor*)cursor ); \
      SetCursor( priv->hcursor ); \
    }else{ \
      gdk_window_set_cursor( win, (GdkCursor*)default_cursor ); \
      SetCursor( NULL ); \
    }
  #endif
#ifdef __cplusplus
  extern "C"{
#endif
typedef enum _SimoCursorType{
  SIMO_ARROW,
  SIMO_HAND,
  SIMO_WAIT
}SimoCursorType;

struct _SimoCursor{
  GdkCursor *cursor;
  SimoCursorType type;
};
typedef struct _SimoCursor * SimoCursor;

extern __declspec( dllexport ) SimoCursor simo_cursor_new( SimoCursorType type );
extern __declspec( dllexport ) void simo_cursor_free( SimoCursor c );
extern __declspec( dllexport ) SimoCursor simo_cursor_set( GdkWindow *win, SimoCursor cursor );
//#define simo_cursor_new( t ) gdk_cursor_new( t )
//#define simo_cursor_free( c )gdk_cursor_unref( (GdkCursor*)c )

#ifdef __cplusplus
  }
#endif

#endif
*/
#endif
