#include <ctype.h>
#include <iostream.h>

#include <qlabel.h>
#include <qframe.h>
#include <qwidget.h>
#include <qtooltip.h>
#include <qbuttongroup.h>

#include <kapp.h>
#include <kdebug.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kmessagebox.h>

#include "EditLimit.moc"
#include "TimeValidator.h"

EditLimit::EditLimit(ftplimit *limit, ftpclass *fcls, 
		     QWidget * parent, char * wname): QWidget(parent, wname)
{
	int y=0;
	current=limit;
	fclass=fcls;
	QString caption;
	if(limit)
		if(fcls)
			caption=i18n("Edit limit for class") + " " + fcls->getName();
		else
			caption=i18n("Edit limit");
	else
		if(fcls)
			caption=i18n("Add limit for class") + " " + fcls->getName();
		else
			caption=i18n("Add limit");
	this->setCaption(caption);
	resize(350,330);
	setFixedSize(350,330);
	QButtonGroup *rButtons=new QButtonGroup();
	any=new QRadioButton(this);
	any->setText(i18n("Limit &always in effect"));
	any->setGeometry(5,y,width()-10,any->height()); y+=any->height(); rButtons->insert(any);
	connect(any, SIGNAL(clicked()), SLOT(anyPressed()));
	notAny=new QRadioButton(this);
	notAny->setText(i18n("Limit in effect at the following &days/hours:"));
	notAny->setGeometry(5,y,width()-10,notAny->height());y+=any->height(); rButtons->insert(notAny);
	connect(notAny, SIGNAL(clicked()), SLOT(notAnyPressed()));
	QFrame *QF=new QFrame(this);
	QF->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	QF->setGeometry(25,y,width()-30,height()-y-130); y+=5;
	mo=new QCheckBox(this);	mo->setText(i18n("&Monday"));
	mo->move(30,y);
	tu=new QCheckBox(this);	tu->setText(i18n("&Tuesday"));
	tu->move(25+QF->width()/3,y);
	we=new QCheckBox(this);	we->setText(i18n("&Wednesday"));
	we->move(25+2*QF->width()/3,y); y+=we->height();
	th=new QCheckBox(this); th->setText(i18n("Thu&rsday"));
	th->move(30,y);
	fr=new QCheckBox(this); fr->setText(i18n("&Friday"));
	fr->move(25+QF->width()/3,y);
	sa=new QCheckBox(this); sa->setText(i18n("&Saturday"));
	sa->move(25+2*QF->width()/3,y); y+=sa->height();
	su=new QCheckBox(this); su->setText(i18n("S&unday"));
	su->move(30,y); y+=su->height();
	QLabel *lbl1=new QLabel(this);
	lbl1->setText(i18n("&Hours:"));
	lbl1->setGeometry(30,y,lbl1->sizeHint().width(),lbl1->height());
	hrs=new QLineEdit(this);
	lbl1->setBuddy(hrs);
	hrs->setGeometry(25+lbl1->width(),y,QF->width()-lbl1->width()-10,hrs->height());
	QToolTip::add(lbl1,i18n("Use this to specify at which hours this limit is in effect.\nExample:\n0630-1310 -> 06:30 AM - 01:10 PM\nDefaults to 0000-2400."));
	QToolTip::add(hrs, i18n("Use this to specify at which hours this limit is in effect.\nExample:\n0630-1310 -> 06:30 AM - 01:10 PM\nDefaults to 0000-2400."));
	TimeValidator const *t=new TimeValidator(hrs);
	hrs->setValidator(t);
	y=QF->y()+QF->height()+5;
	QButtonGroup *limitYesNo=new QButtonGroup();
	limitYes=new QRadioButton(this); limitYes->setText(i18n("&Limit to"));
	connect(limitYes, SIGNAL(clicked()), SLOT(limitPressed()));
	limitYesNo->insert(limitYes);
	limitYes->setGeometry(5,y,limitYes->sizeHint().width(),limitYes->height());
	users=new QSpinBox(0,999999,1,this);
	users->move(5+limitYes->width(),y);
	QLabel *lbl3=new QLabel(this);
	lbl3->setText(i18n("users"));
	lbl3->move(users->x()+users->width()+5,y);
	y+=users->height();
	limitNo=new QRadioButton(this); limitNo->setText(i18n("&No limit"));
	connect(limitNo, SIGNAL(clicked()), SLOT(noLimitPressed()));
	limitYesNo->insert(limitNo);
	limitNo->move(5,y); y+=limitNo->height();
	msgFile=new InputFileCtl(i18n("M&essage at violation:"),0,false,0,this);
	msgFile->setGeometry(5,y,width()-10,msgFile->height());
	y+=msgFile->height()+5;
	ok=new QPushButton(i18n("&OK"),this);
	ok->setGeometry(5,y,width()/2-10,ok->height());
	ok->setDefault(TRUE);
	connect(ok,SIGNAL(clicked()),SLOT(okButtonPressed()));
	cancel=new QPushButton(i18n("&Cancel"), this);
	cancel->setGeometry(width()/2+5,y,width()/2-10,cancel->height());
	connect(cancel, SIGNAL(clicked()), SLOT(cancelButtonPressed()));
	if(current==0) {
		current=new ftplimit;
		current->setAny(true);
		any->setChecked(true);	anyPressed();
		current->setNum(-1);
		limitNo->setChecked(true);
		current->setMsgfile("/etc/msgs.toomany");
	}
	if(current->isAny()) {
		any->setChecked(true);
		anyPressed();	// disable weekday controls
	} else {
		notAny->setChecked(true);
		mo->setChecked(current->isMo());
		tu->setChecked(current->isTu());
		we->setChecked(current->isWe());
		th->setChecked(current->isTh());
		fr->setChecked(current->isFr());
		sa->setChecked(current->isSa());
		su->setChecked(current->isSu());
	}
	if(current->getNum()<0)
		limitNo->setChecked(true);
	else {
		limitYes->setChecked(true);
		users->setValue(current->getNum());
	}
	QString a=current->getHours();
	kdDebug() << a << endl;
	if(!a.isNull())
		hrs->setText(a);
	msgFile->setText(current->getMsgfile());
	show();
}
EditLimit::~EditLimit()
{
	delete any;
	delete notAny;
	delete mo;
	delete tu;
	delete we;
	delete th;
	delete fr;
	delete sa;
	delete su;
	delete hrs;
	delete users;
	delete limitYes;
	delete limitNo;
	delete ok;
	delete cancel;
}
void EditLimit::selectFilePressed() // SLOT
{
	KURL url;
	
	url = KFileDialog::getOpenURL("/etc","*",this,i18n("Select message file"));

	if( !url.isLocalFile() )
	{
	  KMessageBox::sorry( 0L, i18n( "Only local files are currently supported." ) );
	  return;
	}
	
	msgFile->setText(url.path());
}
void EditLimit::okButtonPressed() // SLOT
{
	if(any->isChecked()) {
		current->setAny(true);
		current->setMo(false);
		current->setTu(false);
		current->setWe(false);
		current->setTh(false);
		current->setFr(false);
		current->setSa(false);
		current->setSu(false);
		current->setHours(0);
	} else {
		current->setAny(false);
		current->setMo(mo->isChecked());
		current->setTu(tu->isChecked());
		current->setWe(we->isChecked());
		current->setTh(th->isChecked());
		current->setFr(fr->isChecked());
		current->setSa(sa->isChecked());
		current->setSu(su->isChecked());
		if(!hrs->text().isEmpty())
			current->setHours(hrs->text());
	}
	if(limitYes->isChecked())
		current->setNum(users->value());
	else
		current->setNum(-1);
	current->setMsgfile(msgFile->text());
	emit EditLimitOk(current, fclass);
	delete this;
}
void EditLimit::cancelButtonPressed() // SLOT
{
	delete this;
}
void EditLimit::anyPressed() // SLOT
{
	mo->setEnabled(false);
	tu->setEnabled(false);
	we->setEnabled(false);
	th->setEnabled(false);
	fr->setEnabled(false);
	sa->setEnabled(false);
	su->setEnabled(false);
	hrs->setEnabled(false);
}
void EditLimit::notAnyPressed() // SLOT
{
	mo->setEnabled(true);
	tu->setEnabled(true);
	we->setEnabled(true);
	th->setEnabled(true);
	fr->setEnabled(true);
	sa->setEnabled(true);
	su->setEnabled(true);
	hrs->setEnabled(true);
}
void EditLimit::noLimitPressed() // SLOT
{
	users->setEnabled(false);
}
void EditLimit::limitPressed() // SLOT
{
	users->setEnabled(true);
}
