//////////////////////////////////////////////////////////////
//      $Id: debInterface.h,v 1.17 2001/04/02 16:27:50 toivo Exp $ 
//
// Author: Toivo Pedaste
//
//////////////////////////////////////////////////////////////

#ifndef DEB_IFACE_H
#define DEB_IFACE_H

#include "../config.h"

#include <qlist.h>
#include <qdir.h> 
#include <qfile.h> 
#include <qfileinf.h> 
#include <qtextstream.h>
#include <qstringlist.h> 

#include <kprocess.h>

#include "pkgInterface.h"

class packageInfo;
class updateLoc;
class cacheObj;

#define AVAIL          "/var/lib/dpkg/available"
#define STATUS          "/var/lib/dpkg/status"

#define INFODIR         "/var/lib/dpkg/info/"


class DEB: public pkgInterface
{
  Q_OBJECT

public:
  DEB(QString remote);
  ~DEB();
  
  virtual bool isType(char *buf, const QString &fname);

  virtual packageInfo *getPackageInfo(char mode, const QString &name,
			      const QString &version);
  virtual QStringList getFileList(packageInfo *p);

  virtual void listInstalledPackages(QList<packageInfo> *pki);

  virtual QStringList FindFile(const QString &name);
  virtual bool parseName(QString name, QString *n, QString *v);

  virtual packageInfo* collectInfo(QStringList &inp);

  QString uninstall(int uninstallFlags, QList<packageInfo> *p,
				  bool &test);
  QString install(int installFlags, QList<packageInfo> *p,
				  bool &test);
  QString doInstall(int installFlags, QString packs, bool &test);

public slots:
  void setLocation();
  void setAvail(LcacheObj *);

protected:
  packageInfo *getIPackageInfo(const QString &name);
  packageInfo *getUPackageInfo(const QString &name);

  void listPackList(QList<packageInfo> *pki,
		    const QString &fname, cacheObj *cp);

  void distPackages(QList<packageInfo> *pki, cacheObj *cp);
  void listUnIPackages(QList<packageInfo> *pki, LcacheObj *pCache);

  QStringList getIFileList(packageInfo *p);
  QStringList getUFileList(QString fn);
};

#endif



