//////////////////////////////////////////////////////////////         
//      $Id: cache.cpp,v 1.11 2000/12/05 13:51:40 toivo Exp $ 
//
// Author: Toivo Pedaste
//
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "kpackage.h"
#include "options.h"
#include "cache.h"
#include <klocale.h>

extern Opts *opts;
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
cacheObj::cacheObj(QString Pbase, QString Plocation, QString PcacheFile,
		   QString Poption, bool Psubdirs)
{
  base = Pbase;
  location = Plocation;
  cacheFile = PcacheFile;
  option = Poption;
  subdirs = Psubdirs;
}

cacheObj::~cacheObj()
{}

QString cacheObj::PDir()
{
  QString tmpd = QDir::homeDirPath();
  struct stat buf;
  stat(QFile::encodeName(tmpd), &buf);
    
  tmpd += "/.kpackage/";

  QDir d(tmpd);
  if (!d.exists()) {
    if (!d.mkdir(tmpd)) {
      KpMsgE(i18n("Cannot create directory %1").arg(tmpd),TRUE);
      tmpd = "";
    } else {
      chown(QFile::encodeName(tmpd),buf.st_uid,buf.st_gid);
    }
  }
  return tmpd;
}

QString cacheObj::CDir()
{
  QString tmpd = PDir();
  if (!tmpd.isEmpty()) {
    struct stat buf;
    stat(QFile::encodeName(tmpd),&buf);
    
    tmpd += "dir/";

    QDir d(tmpd);
    if (!d.exists()) {
      if (!d.mkdir(tmpd)) {
	KpMsgE(i18n("Cannot create directory %1").arg(tmpd),TRUE);
	tmpd = "";
      } else {
	chown(QFile::encodeName(tmpd),buf.st_uid,buf.st_gid);
      }
    }
  }
  return tmpd;
}

int cacheObj::newDCache(QString url, QString fn, QString  &fname) {

  KURL *u = new KURL(url );
  if ( u->isMalformed() ) {
    KpMsgE(i18n("Malformed URL: %1").arg(url),TRUE);
    return -1;
  }

  QString tmpd = cacheObj::CDir();
  if (tmpd.isEmpty()) {
    return -1;
  } else {
    if (u->protocol() == "file") {
      fname =  u->path();
      return 0;    
    }

    fname = tmpd + fn;

    if (opts->DCache == Opts::NEVER) {
      return 1;
    }

    QFileInfo f(fname);

    if (f.exists() && f.size() > 0) {
      return 0;;
    } else {
      if (f.size() == 0)
	rmDCache(fname);
      return 1;
    }
  }
}

void  cacheObj::rmDCache(QString fn) {
  QString tmpd = cacheObj::CDir();
  tmpd += fn;

  if (!tmpd.isEmpty()) {
    unlink(QFile::encodeName(tmpd));
  }
}

void  cacheObj::clearDCache() {
  QString tmpd = cacheObj::CDir();

  if (!tmpd.isEmpty()) {
    QDir d(tmpd);
    if (const QFileInfoList *list = d.entryInfoList()) {
      QFileInfoListIterator it( *list ); 
      QFileInfo *fi;                          

      while ( (fi=it.current()) ) {
	if (!fi->isDir()) {
	  QString s = tmpd;
	  s += fi->fileName();
	  unlink(QFile::encodeName(s));
	}
	++it;      
      }
    }
  }
}

void  cacheObj::clearPCache() {
  QString tmpd = cacheObj::PDir();

  if (!tmpd.isEmpty()) {
    QDir d(tmpd);
    if (const QFileInfoList *list = d.entryInfoList()) {
      QFileInfoListIterator it( *list ); 
      QFileInfo *fi;                          

      while ( (fi=it.current()) ) {
	if (!fi->isDir()) {
	  QString s = tmpd;
	  s += fi->fileName();
	  unlink(QFile::encodeName(s));
	}
	++it;
      }
    }
  }
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
LcacheObj::LcacheObj()
{
  setAutoDelete(TRUE);
}

LcacheObj::~LcacheObj()
{
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

