/* Copyright (C) 1994, 1995 Aladdin Enterprises.  All rights reserved.
  
  This file is part of GNU Ghostscript.
  
  GNU Ghostscript is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility to
  anyone for the consequences of using it or for whether it serves any
  particular purpose or works at all, unless he says so in writing.  Refer to
  the GNU General Public License for full details.
  
  Everyone is granted permission to copy, modify and redistribute GNU
  Ghostscript, but only under the conditions described in the GNU General
  Public License.  A copy of this license is supposed to have been given to
  you along with GNU Ghostscript so you can know your rights and
  responsibilities.  It should be in a file named COPYING.  Among other
  things, the copyright notice and this notice must be preserved on all
  copies.
  
  Aladdin Enterprises is not affiliated with the Free Software Foundation or
  the GNU Project.  GNU Ghostscript, as distributed by Aladdin Enterprises,
  does not depend on any other GNU software.
*/

/* iscantab.c */
/* Scanner table for Ghostscript interpreter */
#include "stdpre.h"
#include "scommon.h"
#include "scanchar.h"		/* defines interface */

/* Define the character scanning table (see scanchar.h). */
const byte scan_char_array[max_stream_exception + 256] =
{	stream_exception_repeat(ctype_exception),
		/* Control characters 0-31. */
	ctype_space,		/* NULL - standard only in Level 2 */
	ctype_name, ctype_name, ctype_name,
	ctype_other,		/* EOT (^D, \004) - not PostScript standard */
	ctype_name,
	ctype_name, ctype_name, ctype_name,
	ctype_space,		/* TAB (\t) */
	ctype_space,		/* LF (\n) */
	ctype_space,		/* VT - not PostScript standard */
	ctype_space,		/* FF (\f) */
	ctype_space,		/* CR (\r) */
	ctype_name, ctype_name, ctype_name, ctype_name, ctype_name,
	ctype_name, ctype_name, ctype_name, ctype_name, ctype_name,
	ctype_name, ctype_name,
	ctype_other,		/* DOS EOF - not PostScript standard */
	ctype_name, ctype_name, ctype_name, ctype_name, ctype_name,
		/* Printable characters 32-63 */
	ctype_space,		/* space (\s) */
	ctype_name, ctype_name, ctype_name, ctype_name,
	ctype_other,		/* % */
	ctype_name, ctype_name,
	ctype_other,		/* ( */
	ctype_other,		/* ) */
	ctype_name, ctype_name, ctype_name, ctype_name, ctype_name,
	ctype_other,		/* / */
	0, 1, 2, 3, 4, 5, 6, 7, 8, 9,	/* digits 0-9 */
	ctype_name, ctype_name,
	ctype_other,		/* < */
	ctype_name,
	ctype_other,		/* > */
	ctype_name,
		/* Printable characters 64-95 */
	ctype_name,
	10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
	20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
	30, 31, 32, 33, 34, 35,
	ctype_other,		/* [ */
	ctype_name,
	ctype_other,		/* ] */
	ctype_name, ctype_name,
		/* Printable characters 96-126 and DEL */
	ctype_name,
	10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
	20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
	30, 31, 32, 33, 34, 35,
	ctype_other,		/* { */
	ctype_name,
	ctype_other,		/* } */
	ctype_name, ctype_name,
		/* Characters 128-159, binary tokens */
	ctype_btoken, ctype_btoken, ctype_btoken, ctype_btoken, ctype_btoken,
	ctype_btoken, ctype_btoken, ctype_btoken, ctype_btoken, ctype_btoken,
	ctype_btoken, ctype_btoken, ctype_btoken, ctype_btoken, ctype_btoken,
	ctype_btoken, ctype_btoken, ctype_btoken, ctype_btoken, ctype_btoken,
	ctype_btoken, ctype_btoken, ctype_btoken, ctype_btoken, ctype_btoken,
	ctype_btoken, ctype_btoken, ctype_btoken, ctype_btoken, ctype_btoken,
	ctype_btoken, ctype_btoken,
		/* Characters 160-191, not defined */
	ctype_name, ctype_name, ctype_name, ctype_name, ctype_name,
	ctype_name, ctype_name, ctype_name, ctype_name, ctype_name,
	ctype_name, ctype_name, ctype_name, ctype_name, ctype_name,
	ctype_name, ctype_name, ctype_name, ctype_name, ctype_name,
	ctype_name, ctype_name, ctype_name, ctype_name, ctype_name,
	ctype_name, ctype_name, ctype_name, ctype_name, ctype_name,
	ctype_name, ctype_name,
		/* Characters 192-223, not defined */
	ctype_name, ctype_name, ctype_name, ctype_name, ctype_name,
	ctype_name, ctype_name, ctype_name, ctype_name, ctype_name,
	ctype_name, ctype_name, ctype_name, ctype_name, ctype_name,
	ctype_name, ctype_name, ctype_name, ctype_name, ctype_name,
	ctype_name, ctype_name, ctype_name, ctype_name, ctype_name,
	ctype_name, ctype_name, ctype_name, ctype_name, ctype_name,
	ctype_name, ctype_name,
		/* Characters 224-255, not defined */
	ctype_name, ctype_name, ctype_name, ctype_name, ctype_name,
	ctype_name, ctype_name, ctype_name, ctype_name, ctype_name,
	ctype_name, ctype_name, ctype_name, ctype_name, ctype_name,
	ctype_name, ctype_name, ctype_name, ctype_name, ctype_name,
	ctype_name, ctype_name, ctype_name, ctype_name, ctype_name,
	ctype_name, ctype_name, ctype_name, ctype_name, ctype_name,
	ctype_name, ctype_name
};
