/*
 * jaZip for Linux  (c) 1996  Jarrod A. Smith
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or 
 * implied warranty.
 */

#include <stdio.h>
#include <mntent.h>
#include <forms.h>
#include <errno.h>
#include <sys/mount.h>
#include <fcntl.h>
#include "jazip.h"

int z_umount (char *dev)
{
	FILE	*mtab, *newmtab;
	struct mntent *mp;

	if (!is_mounted(dev)){
		sprintf (mesg, "No disks are mounted!");
		return (0);
	}

	seteuid(0);

	if (!(newmtab = fdopen (open (LOCK_FILE, O_WRONLY|O_CREAT|O_EXCL, 0666), "w"))) {
		sprintf (mesg, "A lock-file exists.  umount denied.");
		seteuid(getuid());
		return (0);
	}
	if (!(mtab = setmntent (MOUNTED, "r"))) {
		sprintf (mesg, "%s : %s", MOUNTED, strerror (errno));
		endmntent (newmtab);
		unlink (LOCK_FILE);
		seteuid(getuid());
		return (0);
	}
	while ((mp = getmntent (mtab))) {
		if (!mp->mnt_opts || !mp->mnt_opts[0]) mp->mnt_opts = "defaults";
		if (!strcmp (mnt_fsname, mp->mnt_fsname) ||
			 !strcmp (mnt_dir, mp->mnt_dir)) { 
			if (umount (mnt_fsname) < 0) {
				sprintf (mesg, "umount %s : %s", mnt_dir, strerror (errno));
				endmntent (mtab);
				endmntent (newmtab);
				unlink (LOCK_FILE);
				seteuid(getuid());
				return (0);
			} else {
				sprintf (mesg, "Unmounted %s", mp->mnt_dir);
			}
		} else {
			addmntent (newmtab, mp);
		}
	}
	endmntent (newmtab);
	endmntent (mtab);
	unlink (MOUNTED);
	link (LOCK_FILE, MOUNTED);
	unlink (LOCK_FILE);
	seteuid(getuid());
	return (1);
}
