/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the XMPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * XMPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: xmpi_error.cc,v 1.5 2003/09/03 04:28:54 jsquyres Exp $
 *
 *	Function:	- error dialog
 */

#include <Xm/MessageB.h>
#include <Xm/Form.h>
#include <X11/cursorfont.h>

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "lam.h"
#include "xmpi.h"
#include "xmpi_error.h"

#include <sfh.h>

/*
 * local functions
 */
static char *errorstr(char*);

/*
 * local variables
 */
#define BUFLEN		1024
#define MAXERRMSGLEN	64

static char buffer[BUFLEN];	       /* complete message */

const char *errmsg[] = {
  "improper command invocation",       /* EUSAGE */
  "delete from list failed",	       /* EDELETE */
  "bad magic number",		       /* EMAGIC */
  "invalid ID specification",	       /* EBADIDSPEC */
  "impossible, ergo a bug",	       /* EIMPOSSIBLE */
};

/*
 *	xmpi_error
 *
 *	Function:	- widget child of the desired centering shell
 *			  displays error message in dialog
 *			- displays appended user and system error message
 *                        System Error only displayed if 3rd argument true
 *	Accepts:	- parent widget (or NULL)
 *			- user error message
 */
void
xmpi_error(Widget w, const char *usrmsg, bool DisplaySystem)
{
  Widget dialog_w;

  XmString str;

  Arg args[3];

  w = (w == 0) ? xmpi_shell : xmpi_wmshell(w);

  char *tmpmsg = strdup(usrmsg);

  if (DisplaySystem)
    str = XmStringCreateLtoR(errorstr(tmpmsg), XmSTRING_DEFAULT_CHARSET);
  else
    str = XmStringCreateLtoR(tmpmsg, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(args[0], XmNmessageString, str);
  XtSetArg(args[1], XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL);
  XtSetArg(args[2], XmNautoUnmanage, False);
  dialog_w = XmCreateErrorDialog(w, (char*) "error_pop", args, 3);
  XmStringFree(str);
  XtAddCallback(dialog_w, XmNokCallback,
		(XtCallbackProc) XtDestroyWidget, NULL);
  XtUnmanageChild(XmMessageBoxGetChild(dialog_w, XmDIALOG_HELP_BUTTON));
  XtUnmanageChild(XmMessageBoxGetChild(dialog_w,
				       XmDIALOG_CANCEL_BUTTON));
  XtManageChild(dialog_w);
  XtPopup(XtParent(dialog_w), XtGrabNone);
}

/*
 *	errorstr
 *
 *	Function:	- forms XMPI error message
 *			- uses system dependent and UNIX error message tables
 *			- returned message is stored in a static buffer
 *	Accepts:	- user's error message
 *	Returns:	- extended error message
 */
static char *
errorstr(char *msg)
{
  char anum[16];		       /* ascii error code */

  char *syserr;			       /* system dep. error string */

  buffer[0] = '\0';
/*
 * Check for specific XMPI errors first.
 */
  if (msg && *msg) {
    strncpy(buffer, msg, BUFLEN - MAXERRMSGLEN);
  }
  if (XMPI_ERR_LOW <= errno && errno <= XMPI_ERR_HIGH) {
    strcat(buffer, ": ");
    strcat(buffer, errmsg[errno - XMPI_ERR_LOW]);
  }
/*
 * Pass through to system dependent error message routine.
 */
  else {
    syserr = xmpi_sys_errorstr(errno);

    if (syserr) {
      strcat(buffer, ": ");
      strcat(buffer, syserr);
    } else {
      if (errno != 0) {
	strcat(buffer, ": Unknown error ");
	sfh_itoa(errno, anum);
	strcat(buffer, anum);
      }
    }
  }

  return (buffer);
}
