/*
 *   BSD LICENSE
 *
 *   Copyright(c) 2016-2017 Netronome.
 *   All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in
 *       the documentation and/or other materials provided with the
 *       distribution.
 *     * Neither the name of Netronome nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef VRELAY_VERSION_H
#define VRELAY_VERSION_H

#ifdef	__cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <string.h>
#include <stdio.h>

#define VIRTIO_FWD_VERSION_MAJOR 1 // Autogenerated from Makefile
#define VIRTIO_FWD_VERSION_MINOR 1 // Autogenerated from Makefile
#define VIRTIO_FWD_VERSION_PATCH 99 // Autogenerated from Makefile
#define VIRTIO_FWD_VERSION_BUILD 51 // Autogenerated from Makefile
#define VIRTIO_FWD_VERSION_SHASH "g78aadc2" // Autogenerated from Makefile

/**
 * @brief Return virtio-forwarder version number string.
 * @return string
 */
static inline const char *virtio_forwarder_version(void)
{
	static char version[32];

	if (version[0])
		return version;
	snprintf(version, sizeof(version), "%u.%u.%u-%u-%s",
		VIRTIO_FWD_VERSION_MAJOR, VIRTIO_FWD_VERSION_MINOR,
		VIRTIO_FWD_VERSION_PATCH, VIRTIO_FWD_VERSION_BUILD,
		VIRTIO_FWD_VERSION_SHASH);

	return version;
}

#ifdef	__cplusplus
}
#endif

#endif	/* VRELAY_VERSION_H */
