/* rygel-media-export-generic-extractor.c generated by valac 0.40.8, the Vala compiler
 * generated from rygel-media-export-generic-extractor.vala, do not modify */

/*
 * Copyright (C) 2016 Jens Georg <mail@jensge.org>
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gst/pbutils/pbutils.h>
#include <libgupnp-dlna/gupnp-dlna.h>
#include <libmediaart/mediaart.h>
#include <gst/gst.h>
#include <libgupnp-dlna/gupnp-dlna-gst-utils.h>
#include <gst/tag/tag.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR (rygel_media_export_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor))
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorClass))

typedef struct _RygelMediaExportExtractor RygelMediaExportExtractor;
typedef struct _RygelMediaExportExtractorClass RygelMediaExportExtractorClass;
typedef struct _RygelMediaExportExtractorPrivate RygelMediaExportExtractorPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR (rygel_media_export_generic_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, RygelMediaExportGenericExtractor))
#define RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, RygelMediaExportGenericExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_GENERIC_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_GENERIC_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, RygelMediaExportGenericExtractorClass))

typedef struct _RygelMediaExportGenericExtractor RygelMediaExportGenericExtractor;
typedef struct _RygelMediaExportGenericExtractorClass RygelMediaExportGenericExtractorClass;
typedef struct _RygelMediaExportGenericExtractorPrivate RygelMediaExportGenericExtractorPrivate;
enum  {
	RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR_0_PROPERTY,
	RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR_NUM_PROPERTIES
};
static GParamSpec* rygel_media_export_generic_extractor_properties[RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_date_time_unref0(var) ((var == NULL) ? NULL : (var = (gst_date_time_unref (var), NULL)))
#define _gst_sample_unref0(var) ((var == NULL) ? NULL : (var = (gst_sample_unref (var), NULL)))
#define _gst_tag_list_unref0(var) ((var == NULL) ? NULL : (var = (gst_tag_list_unref (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
typedef struct _RygelMediaExportGenericExtractorRunData RygelMediaExportGenericExtractorRunData;

struct _RygelMediaExportExtractor {
	GObject parent_instance;
	RygelMediaExportExtractorPrivate * priv;
	GVariantDict* serialized_info;
};

struct _RygelMediaExportExtractorClass {
	GObjectClass parent_class;
	void (*run) (RygelMediaExportExtractor* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelMediaExportExtractor* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportGenericExtractor {
	RygelMediaExportExtractor parent_instance;
	RygelMediaExportGenericExtractorPrivate * priv;
};

struct _RygelMediaExportGenericExtractorClass {
	RygelMediaExportExtractorClass parent_class;
};

struct _RygelMediaExportGenericExtractorPrivate {
	gchar* upnp_class;
	gchar* mime_type;
};

struct _Block1Data {
	int _ref_count_;
	RygelMediaExportGenericExtractor* self;
	GError* _error_;
	GstDiscovererInfo* info;
	gpointer _async_data_;
};

typedef enum  {
	EXTRACTOR_ERROR_GENERAL,
	EXTRACTOR_ERROR_INVALID
} ExtractorError;
#define EXTRACTOR_ERROR extractor_error_quark ()
struct _RygelMediaExportGenericExtractorRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelMediaExportGenericExtractor* self;
	Block1Data* _data1_;
	GstDiscoverer* _tmp0_;
	GError* _tmp1_;
	gulong id;
	GstDiscoverer* _tmp2_;
	gulong _tmp3_;
	gchar* path;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* _tmp6_;
	gchar* uri;
	GFile* _tmp7_;
	GFile* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GstDiscoverer* _tmp15_;
	const gchar* _tmp16_;
	GstDiscoverer* _tmp17_;
	gulong _tmp18_;
	GError* _tmp19_;
	GstDiscoverer* _tmp20_;
	GstDiscoverer* _tmp21_;
	GstDiscoverer* _tmp22_;
	GstDiscoverer* _tmp23_;
	GstDiscoverer* _tmp24_;
	GstDiscovererResult _result_;
	GstDiscovererInfo* _tmp25_;
	GstDiscovererResult _tmp26_;
	GFile* _tmp27_;
	GFile* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GstDiscovererResult _tmp31_;
	GFile* _tmp32_;
	GFile* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GError* _tmp36_;
	GError* _tmp37_;
	GList* audio_streams;
	GstDiscovererInfo* _tmp38_;
	GList* _tmp39_;
	GList* video_streams;
	GstDiscovererInfo* _tmp40_;
	GList* _tmp41_;
	gboolean _tmp42_;
	GList* _tmp43_;
	GList* _tmp44_;
	GFile* _tmp45_;
	GFile* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	GError* _tmp49_;
	gchar* _tmp50_;
	gboolean _tmp51_;
	GList* _tmp52_;
	GList* _tmp53_;
	gconstpointer _tmp54_;
	gchar* _tmp55_;
	GList* _tmp56_;
	gchar* _tmp57_;
	GList* _tmp58_;
	gchar* _tmp59_;
	GVariantDict* _tmp60_;
	const gchar* _tmp61_;
	GUPnPDLNAInformation* dlna_info;
	GstDiscovererInfo* _tmp62_;
	GUPnPDLNAInformation* _tmp63_;
	GUPnPDLNAProfile* dlna;
	GUPnPDLNAProfileGuesser* _tmp64_;
	GUPnPDLNAInformation* _tmp65_;
	GUPnPDLNAProfile* _tmp66_;
	GUPnPDLNAProfile* _tmp67_;
	GUPnPDLNAProfile* _tmp68_;
	GVariantDict* _tmp69_;
	GUPnPDLNAProfile* _tmp70_;
	const gchar* _tmp71_;
	const gchar* _tmp72_;
	GVariantDict* _tmp73_;
	GUPnPDLNAProfile* _tmp74_;
	const gchar* _tmp75_;
	const gchar* _tmp76_;
	GVariantDict* _tmp77_;
	glong duration;
	GstDiscovererInfo* _tmp78_;
	GstDiscovererInfo* _tmp79_;
	GVariantDict* _tmp80_;
	glong _tmp81_;
	GstTagList* tags;
	GstDiscovererInfo* _tmp82_;
	GstTagList* _tmp83_;
	GstTagList* _tmp84_;
	GstTagList* _tmp85_;
	gchar* title;
	GstTagList* _tmp86_;
	gchar* _tmp87_;
	gboolean _tmp88_;
	gboolean _tmp89_;
	const gchar* _tmp90_;
	const gchar* _tmp91_;
	GVariantDict* _tmp92_;
	const gchar* _tmp93_;
	gchar* date;
	GstDateTime* dt;
	GstTagList* _tmp94_;
	GstDateTime* _tmp95_;
	gboolean _tmp96_;
	gboolean _tmp97_;
	GstDateTime* _tmp98_;
	GstDateTime* _tmp99_;
	gint _tmp100_;
	GstDateTime* _tmp101_;
	GstDateTime* _tmp102_;
	gint _tmp103_;
	GstDateTime* _tmp104_;
	GstDateTime* _tmp105_;
	GstDateTime* _tmp106_;
	gchar* _tmp107_;
	GstDateTime* _tmp108_;
	gchar* _tmp109_;
	GVariantDict* _tmp110_;
	const gchar* _tmp111_;
	gboolean _tmp112_;
	GList* _tmp113_;
	GList* _tmp114_;
	gconstpointer _tmp115_;
	GstDiscovererVideoInfo* vinfo;
	GList* _tmp116_;
	gconstpointer _tmp117_;
	GstDiscovererVideoInfo* _tmp118_;
	GVariantDict* _tmp119_;
	GstDiscovererVideoInfo* _tmp120_;
	GVariantDict* _tmp121_;
	GstDiscovererVideoInfo* _tmp122_;
	guint _tmp123_;
	GstDiscovererVideoInfo* _tmp124_;
	GstDiscovererVideoInfo* _tmp125_;
	GVariantDict* _tmp126_;
	gboolean _tmp127_;
	GList* _tmp128_;
	GList* _tmp129_;
	gconstpointer _tmp130_;
	GstDiscovererAudioInfo* ainfo;
	GList* _tmp131_;
	gconstpointer _tmp132_;
	GstDiscovererAudioInfo* _tmp133_;
	GVariantDict* _tmp134_;
	GstDiscovererAudioInfo* _tmp135_;
	GVariantDict* _tmp136_;
	GstDiscovererAudioInfo* _tmp137_;
	GstTagList* atags;
	GstDiscovererAudioInfo* _tmp138_;
	GstTagList* _tmp139_;
	GstTagList* _tmp140_;
	GstTagList* _tmp141_;
	gchar* artist;
	gboolean _tmp142_;
	GstTagList* _tmp143_;
	gchar* _tmp144_;
	gboolean _tmp145_;
	const gchar* _tmp146_;
	GVariantDict* _tmp147_;
	const gchar* _tmp148_;
	gchar* album;
	GstTagList* _tmp149_;
	gchar* _tmp150_;
	gboolean _tmp151_;
	GVariantDict* _tmp152_;
	const gchar* _tmp153_;
	gchar* genre;
	GstTagList* _tmp154_;
	gchar* _tmp155_;
	gboolean _tmp156_;
	GVariantDict* _tmp157_;
	const gchar* _tmp158_;
	guint volume;
	GstTagList* _tmp159_;
	guint _tmp160_;
	gboolean _tmp161_;
	GVariantDict* _tmp162_;
	guint _tmp163_;
	guint track;
	GstTagList* _tmp164_;
	guint _tmp165_;
	gboolean _tmp166_;
	GVariantDict* _tmp167_;
	guint _tmp168_;
	guint bitrate;
	GstTagList* _tmp169_;
	guint _tmp170_;
	gboolean _tmp171_;
	GVariantDict* _tmp172_;
	guint _tmp173_;
	MediaArtProcess* _tmp174_;
	GstSample* sample;
	GstTagList* _tmp175_;
	GstSample* _tmp176_;
	GstSample* _tmp177_;
	GstTagList* _tmp178_;
	GstSample* _tmp179_;
	GstSample* _tmp180_;
	gboolean _tmp181_;
	const gchar* _tmp182_;
	const gchar* _tmp183_;
	MediaArtProcess* _tmp184_;
	GFile* _tmp185_;
	GFile* _tmp186_;
	const gchar* _tmp187_;
	const gchar* _tmp188_;
	GError* _error_;
	GError* _tmp189_;
	const gchar* _tmp190_;
	GstCaps* caps;
	GstSample* _tmp191_;
	GstCaps* _tmp192_;
	GstCaps* _tmp193_;
	GstStructure* structure;
	GstCaps* _tmp194_;
	GstStructure* _tmp195_;
	gint image_type;
	GstStructure* _tmp196_;
	gint _tmp197_;
	gboolean _tmp198_;
	gint _tmp199_;
	gint _tmp200_;
	GstMapInfo map_info;
	GstSample* _tmp201_;
	GstBuffer* _tmp202_;
	GstMapInfo _tmp203_;
	guint8* data;
	GstMapInfo _tmp204_;
	guint8* _tmp205_;
	gint _tmp205__length1;
	gint data_length1;
	gint _data_size_;
	GstMapInfo _tmp206_;
	gsize _tmp207_;
	gint _tmp208_;
	MediaArtProcess* _tmp209_;
	GFile* _tmp210_;
	GFile* _tmp211_;
	guint8* _tmp212_;
	gint _tmp212__length1;
	GstStructure* _tmp213_;
	const gchar* _tmp214_;
	const gchar* _tmp215_;
	const gchar* _tmp216_;
	GError* _vala1__error_;
	GError* _tmp217_;
	const gchar* _tmp218_;
	GstSample* _tmp219_;
	GstBuffer* _tmp220_;
	GstMapInfo _tmp221_;
	GError * _inner_error_;
};


static gpointer rygel_media_export_generic_extractor_parent_class = NULL;
static GstDiscoverer* rygel_media_export_generic_extractor_discoverer;
static GstDiscoverer* rygel_media_export_generic_extractor_discoverer = NULL;
static GUPnPDLNAProfileGuesser* rygel_media_export_generic_extractor_guesser;
static GUPnPDLNAProfileGuesser* rygel_media_export_generic_extractor_guesser = NULL;
static MediaArtProcess* rygel_media_export_generic_extractor_media_art;
static MediaArtProcess* rygel_media_export_generic_extractor_media_art = NULL;

GType rygel_media_export_extractor_get_type (void) G_GNUC_CONST;
GType rygel_media_export_generic_extractor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, RygelMediaExportGenericExtractorPrivate))
RygelMediaExportGenericExtractor* rygel_media_export_generic_extractor_new (GFile* file);
RygelMediaExportGenericExtractor* rygel_media_export_generic_extractor_construct (GType object_type,
                                                                                  GFile* file);
static void rygel_media_export_generic_extractor_real_run_data_free (gpointer _data);
static void rygel_media_export_generic_extractor_real_run_async_ready_wrapper (GObject *source_object,
                                                                        GAsyncResult *res,
                                                                        void *user_data);
static void rygel_media_export_generic_extractor_real_run (RygelMediaExportExtractor* base,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static gboolean rygel_media_export_generic_extractor_real_run_co (RygelMediaExportGenericExtractorRunData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void rygel_media_export_extractor_run (RygelMediaExportExtractor* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
void rygel_media_export_extractor_run_finish (RygelMediaExportExtractor* self,
                                              GAsyncResult* _res_,
                                              GError** error);
static void rygel_media_export_generic_extractor_run_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
GQuark extractor_error_quark (void);
static void __lambda4_ (Block1Data* _data1_,
                 GstDiscovererInfo* _info,
                 GError* _error);
static void ___lambda4__gst_discoverer_discovered (GstDiscoverer* _sender,
                                            GstDiscovererInfo* info,
                                            GError* err,
                                            gpointer self);
GFile* rygel_media_export_extractor_get_file (RygelMediaExportExtractor* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
#define UPNP_CLASS_PHOTO "object.item.imageItem.photo"
#define UPNP_CLASS_VIDEO "object.item.videoItem"
#define UPNP_CLASS_MUSIC "object.item.audioItem.musicTrack"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_UPNP_CLASS "UPnPClass"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_DLNA_PROFILE "DLNAProfile"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_MIME_TYPE "MimeType"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_DURATION "Duration"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_TITLE "Title"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_DATE "Date"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_WIDTH "VideoWidth"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_HEIGHT "VideoHeight"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_DEPTH "VideoDepth"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_CHANNELS "AudioChannels"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_RATE "AudioRate"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_ARTIST "Artist"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_ALBUM "Album"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_GENRE "Genre"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_VOLUME_NUMBER "VolumeNumber"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_TRACK_NUMBER "TrackNumber"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_BITRATE "AudioBitrate"
static void rygel_media_export_generic_extractor_finalize (GObject * obj);


RygelMediaExportGenericExtractor*
rygel_media_export_generic_extractor_construct (GType object_type,
                                                GFile* file)
{
	RygelMediaExportGenericExtractor * self = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (RygelMediaExportGenericExtractor*) g_object_new (object_type, "file", file, NULL);
	return self;
}


RygelMediaExportGenericExtractor*
rygel_media_export_generic_extractor_new (GFile* file)
{
	return rygel_media_export_generic_extractor_construct (RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, file);
}


static void
rygel_media_export_generic_extractor_real_run_data_free (gpointer _data)
{
	RygelMediaExportGenericExtractorRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportGenericExtractorRunData, _data_);
}


static void
rygel_media_export_generic_extractor_real_run_async_ready_wrapper (GObject *source_object,
                                                                   GAsyncResult *res,
                                                                   void *user_data)
{
	RygelMediaExportGenericExtractorRunData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
rygel_media_export_generic_extractor_real_run (RygelMediaExportExtractor* base,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	RygelMediaExportGenericExtractor * self;
	RygelMediaExportGenericExtractorRunData* _data_;
	RygelMediaExportGenericExtractor* _tmp0_;
	self = (RygelMediaExportGenericExtractor*) base;
	_data_ = g_slice_new0 (RygelMediaExportGenericExtractorRunData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_media_export_generic_extractor_real_run_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_export_generic_extractor_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_export_generic_extractor_real_run_co (_data_);
}


static void
rygel_media_export_generic_extractor_real_run_finish (RygelMediaExportExtractor* base,
                                                      GAsyncResult* _res_,
                                                      GError** error)
{
	RygelMediaExportGenericExtractorRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RygelMediaExportGenericExtractor* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->info);
		_g_error_free0 (_data1_->_error_);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void
rygel_media_export_generic_extractor_run_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	RygelMediaExportGenericExtractorRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_media_export_generic_extractor_real_run_co (_data_);
}


static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}


static void
__lambda4_ (Block1Data* _data1_,
            GstDiscovererInfo* _info,
            GError* _error)
{
	RygelMediaExportGenericExtractor* self;
	GstDiscovererInfo* _tmp0_;
	GError* _tmp1_;
	self = _data1_->self;
	g_return_if_fail (_info != NULL);
	_tmp0_ = _g_object_ref0 (_info);
	_g_object_unref0 (_data1_->info);
	_data1_->info = _tmp0_;
	_tmp1_ = _g_error_copy0 (_error);
	_g_error_free0 (_data1_->_error_);
	_data1_->_error_ = _tmp1_;
	rygel_media_export_generic_extractor_real_run_co (_data1_->_async_data_);
}


static void
___lambda4__gst_discoverer_discovered (GstDiscoverer* _sender,
                                       GstDiscovererInfo* info,
                                       GError* err,
                                       gpointer self)
{
	__lambda4_ (self, info, err);
}


static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


static gpointer
_gst_tag_list_ref0 (gpointer self)
{
	return self ? gst_tag_list_ref (self) : NULL;
}


static gpointer
_gst_caps_ref0 (gpointer self)
{
	return self ? gst_caps_ref (self) : NULL;
}


static gboolean
rygel_media_export_generic_extractor_real_run_co (RygelMediaExportGenericExtractorRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->_state_ = 1;
	RYGEL_MEDIA_EXPORT_EXTRACTOR_CLASS (rygel_media_export_generic_extractor_parent_class)->run (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor), rygel_media_export_generic_extractor_run_ready, _data_);
	return FALSE;
	_state_1:
	RYGEL_MEDIA_EXPORT_EXTRACTOR_CLASS (rygel_media_export_generic_extractor_parent_class)->run_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor), _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = rygel_media_export_generic_extractor_discoverer;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = g_error_new_literal (EXTRACTOR_ERROR, EXTRACTOR_ERROR_GENERAL, "Backend not avaliable");
		_data_->_inner_error_ = _data_->_tmp1_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_data1_->_error_ = NULL;
	_data_->_data1_->info = NULL;
	_data_->_tmp2_ = rygel_media_export_generic_extractor_discoverer;
	_data_->_tmp3_ = g_signal_connect_data (_data_->_tmp2_, "discovered", (GCallback) ___lambda4__gst_discoverer_discovered, block1_data_ref (_data_->_data1_), (GClosureNotify) block1_data_unref, 0);
	_data_->id = _data_->_tmp3_;
	_data_->_tmp4_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = g_file_get_path (_data_->_tmp5_);
	_data_->path = _data_->_tmp6_;
	_data_->_tmp7_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = g_file_get_uri (_data_->_tmp8_);
	_data_->uri = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->path;
	if (_data_->_tmp10_ != NULL) {
		_data_->_tmp12_ = _data_->path;
		_data_->_tmp13_ = g_filename_to_uri (_data_->_tmp12_, NULL, &_data_->_inner_error_);
		_data_->_tmp11_ = _data_->_tmp13_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			_g_free0 (_data_->uri);
			_g_free0 (_data_->path);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp14_ = _data_->_tmp11_;
		_data_->_tmp11_ = NULL;
		_g_free0 (_data_->uri);
		_data_->uri = _data_->_tmp14_;
		_g_free0 (_data_->_tmp11_);
	}
	_data_->_tmp15_ = rygel_media_export_generic_extractor_discoverer;
	_data_->_tmp16_ = _data_->uri;
	gst_discoverer_discover_uri_async (_data_->_tmp15_, _data_->_tmp16_);
	_data_->_state_ = 2;
	return FALSE;
	_state_2:
	;
	_data_->_tmp17_ = rygel_media_export_generic_extractor_discoverer;
	_data_->_tmp18_ = _data_->id;
	g_signal_handler_disconnect ((GObject*) _data_->_tmp17_, _data_->_tmp18_);
	_data_->_tmp19_ = _data_->_data1_->_error_;
	if (_data_->_tmp19_ != NULL) {
		_data_->_tmp20_ = rygel_media_export_generic_extractor_discoverer;
		gst_discoverer_stop (_data_->_tmp20_);
		_g_object_unref0 (rygel_media_export_generic_extractor_discoverer);
		rygel_media_export_generic_extractor_discoverer = NULL;
		_data_->_tmp22_ = gst_discoverer_new ((GstClockTime) (10 * GST_SECOND), &_data_->_inner_error_);
		_data_->_tmp21_ = _data_->_tmp22_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			_g_free0 (_data_->uri);
			_g_free0 (_data_->path);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp23_ = _data_->_tmp21_;
		_data_->_tmp21_ = NULL;
		_g_object_unref0 (rygel_media_export_generic_extractor_discoverer);
		rygel_media_export_generic_extractor_discoverer = _data_->_tmp23_;
		_data_->_tmp24_ = rygel_media_export_generic_extractor_discoverer;
		gst_discoverer_start (_data_->_tmp24_);
		_data_->_tmp25_ = _data_->_data1_->info;
		_data_->_result_ = gst_discoverer_info_get_result (_data_->_tmp25_);
		_data_->_tmp26_ = _data_->_result_;
		if (_data_->_tmp26_ == GST_DISCOVERER_TIMEOUT) {
			_data_->_tmp27_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
			_data_->_tmp28_ = _data_->_tmp27_;
			_data_->_tmp29_ = g_file_get_uri (_data_->_tmp28_);
			_data_->_tmp30_ = _data_->_tmp29_;
			g_debug ("rygel-media-export-generic-extractor.vala:93: Extraction timed out on " \
"%s", _data_->_tmp30_);
			_g_free0 (_data_->_tmp30_);
		} else {
			_data_->_tmp31_ = _data_->_result_;
			if (_data_->_tmp31_ == GST_DISCOVERER_MISSING_PLUGINS) {
				_data_->_tmp32_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
				_data_->_tmp33_ = _data_->_tmp32_;
				_data_->_tmp34_ = g_file_get_uri (_data_->_tmp33_);
				_data_->_tmp35_ = _data_->_tmp34_;
				g_debug ("rygel-media-export-generic-extractor.vala:95: Plugins are missing for " \
"extraction of file %s", _data_->_tmp35_);
				_g_free0 (_data_->_tmp35_);
			}
		}
		_data_->_tmp36_ = _data_->_data1_->_error_;
		_data_->_tmp37_ = _g_error_copy0 (_data_->_tmp36_);
		_data_->_inner_error_ = _data_->_tmp37_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_object_unref0 (_data_->_tmp21_);
		_g_free0 (_data_->uri);
		_g_free0 (_data_->path);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp38_ = _data_->_data1_->info;
	_data_->_tmp39_ = gst_discoverer_info_get_audio_streams (_data_->_tmp38_);
	_data_->audio_streams = (GList*) _data_->_tmp39_;
	_data_->_tmp40_ = _data_->_data1_->info;
	_data_->_tmp41_ = gst_discoverer_info_get_video_streams (_data_->_tmp40_);
	_data_->video_streams = (GList*) _data_->_tmp41_;
	_data_->_tmp43_ = _data_->audio_streams;
	if (_data_->_tmp43_ == NULL) {
		_data_->_tmp44_ = _data_->video_streams;
		_data_->_tmp42_ = _data_->_tmp44_ == NULL;
	} else {
		_data_->_tmp42_ = FALSE;
	}
	if (_data_->_tmp42_) {
		_data_->_tmp45_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
		_data_->_tmp46_ = _data_->_tmp45_;
		_data_->_tmp47_ = g_file_get_uri (_data_->_tmp46_);
		_data_->_tmp48_ = _data_->_tmp47_;
		g_debug ("rygel-media-export-generic-extractor.vala:108: %s had neither audio no" \
"r video/picture streams. Ignoring.", _data_->_tmp48_);
		_g_free0 (_data_->_tmp48_);
		_data_->_tmp49_ = g_error_new_literal (EXTRACTOR_ERROR, EXTRACTOR_ERROR_GENERAL, "No stream information");
		_data_->_inner_error_ = _data_->_tmp49_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		(_data_->video_streams == NULL) ? NULL : (_data_->video_streams = (_g_list_free__g_object_unref0_ (_data_->video_streams), NULL));
		(_data_->audio_streams == NULL) ? NULL : (_data_->audio_streams = (_g_list_free__g_object_unref0_ (_data_->audio_streams), NULL));
		_g_free0 (_data_->uri);
		_g_free0 (_data_->path);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp50_ = g_strdup ("object.item");
	_g_free0 (_data_->self->priv->upnp_class);
	_data_->self->priv->upnp_class = _data_->_tmp50_;
	_data_->_tmp52_ = _data_->audio_streams;
	if (_data_->_tmp52_ == NULL) {
		_data_->_tmp53_ = _data_->video_streams;
		_data_->_tmp54_ = _data_->_tmp53_->data;
		_data_->_tmp51_ = gst_discoverer_video_info_is_image ((GstDiscovererVideoInfo*) _data_->_tmp54_);
	} else {
		_data_->_tmp51_ = FALSE;
	}
	if (_data_->_tmp51_) {
		_data_->_tmp55_ = g_strdup (UPNP_CLASS_PHOTO);
		_g_free0 (_data_->self->priv->upnp_class);
		_data_->self->priv->upnp_class = _data_->_tmp55_;
	} else {
		_data_->_tmp56_ = _data_->video_streams;
		if (_data_->_tmp56_ != NULL) {
			_data_->_tmp57_ = g_strdup (UPNP_CLASS_VIDEO);
			_g_free0 (_data_->self->priv->upnp_class);
			_data_->self->priv->upnp_class = _data_->_tmp57_;
		} else {
			_data_->_tmp58_ = _data_->audio_streams;
			if (_data_->_tmp58_ != NULL) {
				_data_->_tmp59_ = g_strdup (UPNP_CLASS_MUSIC);
				_g_free0 (_data_->self->priv->upnp_class);
				_data_->self->priv->upnp_class = _data_->_tmp59_;
			}
		}
	}
	_data_->_tmp60_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
	_data_->_tmp61_ = _data_->self->priv->upnp_class;
	g_variant_dict_insert (_data_->_tmp60_, RYGEL_MEDIA_EXPORT_SERIALIZER_UPNP_CLASS, "s", _data_->_tmp61_, NULL);
	_data_->_tmp62_ = _data_->_data1_->info;
	_data_->_tmp63_ = gupnp_dlna_gst_utils_information_from_discoverer_info (_data_->_tmp62_);
	_data_->dlna_info = _data_->_tmp63_;
	_data_->_tmp64_ = rygel_media_export_generic_extractor_guesser;
	_data_->_tmp65_ = _data_->dlna_info;
	_data_->_tmp66_ = gupnp_dlna_profile_guesser_guess_profile_from_info (_data_->_tmp64_, _data_->_tmp65_);
	_data_->_tmp67_ = _g_object_ref0 (_data_->_tmp66_);
	_data_->dlna = _data_->_tmp67_;
	_data_->_tmp68_ = _data_->dlna;
	if (_data_->_tmp68_ != NULL) {
		_data_->_tmp69_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp70_ = _data_->dlna;
		_data_->_tmp71_ = gupnp_dlna_profile_get_name (_data_->_tmp70_);
		_data_->_tmp72_ = _data_->_tmp71_;
		g_variant_dict_insert (_data_->_tmp69_, RYGEL_MEDIA_EXPORT_SERIALIZER_DLNA_PROFILE, "s", _data_->_tmp72_, NULL);
		_data_->_tmp73_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp74_ = _data_->dlna;
		_data_->_tmp75_ = gupnp_dlna_profile_get_mime (_data_->_tmp74_);
		_data_->_tmp76_ = _data_->_tmp75_;
		g_variant_dict_insert (_data_->_tmp73_, RYGEL_MEDIA_EXPORT_SERIALIZER_MIME_TYPE, "s", _data_->_tmp76_, NULL);
	}
	_data_->_tmp77_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
	g_variant_dict_lookup (_data_->_tmp77_, RYGEL_MEDIA_EXPORT_SERIALIZER_MIME_TYPE, "s", &_data_->self->priv->mime_type, NULL);
	_data_->duration = (glong) -1;
	_data_->_tmp78_ = _data_->_data1_->info;
	if (gst_discoverer_info_get_duration (_data_->_tmp78_) > ((GstClockTime) 0)) {
		_data_->_tmp79_ = _data_->_data1_->info;
		_data_->duration = (glong) (gst_discoverer_info_get_duration (_data_->_tmp79_) / GST_SECOND);
		_data_->_tmp80_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp81_ = _data_->duration;
		g_variant_dict_insert (_data_->_tmp80_, RYGEL_MEDIA_EXPORT_SERIALIZER_DURATION, "i", _data_->_tmp81_, NULL);
	}
	_data_->_tmp82_ = _data_->_data1_->info;
	_data_->_tmp83_ = gst_discoverer_info_get_tags (_data_->_tmp82_);
	_data_->_tmp84_ = _gst_tag_list_ref0 (_data_->_tmp83_);
	_data_->tags = _data_->_tmp84_;
	_data_->_tmp85_ = _data_->tags;
	if (_data_->_tmp85_ != NULL) {
		_data_->title = NULL;
		_data_->_tmp86_ = _data_->tags;
		_data_->_tmp87_ = NULL;
		_data_->_tmp88_ = gst_tag_list_get_string (_data_->_tmp86_, GST_TAG_TITLE, &_data_->_tmp87_);
		_g_free0 (_data_->title);
		_data_->title = _data_->_tmp87_;
		if (_data_->_tmp88_) {
			_data_->_tmp90_ = _data_->self->priv->mime_type;
			if (g_strcmp0 (_data_->_tmp90_, "video/x-msvideo") != 0) {
				_data_->_tmp91_ = _data_->title;
				_data_->_tmp89_ = _data_->_tmp91_ != NULL;
			} else {
				_data_->_tmp89_ = FALSE;
			}
			if (_data_->_tmp89_) {
				_data_->_tmp92_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
				_data_->_tmp93_ = _data_->title;
				g_variant_dict_insert (_data_->_tmp92_, RYGEL_MEDIA_EXPORT_SERIALIZER_TITLE, "s", _data_->_tmp93_, NULL);
			}
		}
		_data_->date = NULL;
		_data_->dt = NULL;
		_data_->_tmp94_ = _data_->tags;
		_data_->_tmp95_ = NULL;
		_data_->_tmp96_ = gst_tag_list_get_date_time (_data_->_tmp94_, GST_TAG_DATE_TIME, &_data_->_tmp95_);
		_gst_date_time_unref0 (_data_->dt);
		_data_->dt = _data_->_tmp95_;
		if (_data_->_tmp96_) {
			_data_->_tmp98_ = _data_->dt;
			if (!gst_date_time_has_day (_data_->_tmp98_)) {
				_data_->_tmp97_ = TRUE;
			} else {
				_data_->_tmp99_ = _data_->dt;
				_data_->_tmp97_ = !gst_date_time_has_month (_data_->_tmp99_);
			}
			if (_data_->_tmp97_) {
				_data_->_tmp101_ = _data_->dt;
				if (gst_date_time_has_month (_data_->_tmp101_)) {
					_data_->_tmp102_ = _data_->dt;
					_data_->_tmp100_ = gst_date_time_get_month (_data_->_tmp102_);
				} else {
					_data_->_tmp100_ = 1;
				}
				_data_->_tmp104_ = _data_->dt;
				if (gst_date_time_has_day (_data_->_tmp104_)) {
					_data_->_tmp105_ = _data_->dt;
					_data_->_tmp103_ = gst_date_time_get_day (_data_->_tmp105_);
				} else {
					_data_->_tmp103_ = 1;
				}
				_data_->_tmp106_ = _data_->dt;
				_data_->_tmp107_ = g_strdup_printf ("%d-%02d-%02d", gst_date_time_get_year (_data_->_tmp106_), _data_->_tmp100_, _data_->_tmp103_);
				_g_free0 (_data_->date);
				_data_->date = _data_->_tmp107_;
			} else {
				_data_->_tmp108_ = _data_->dt;
				_data_->_tmp109_ = gst_date_time_to_iso8601_string (_data_->_tmp108_);
				_g_free0 (_data_->date);
				_data_->date = _data_->_tmp109_;
			}
			_data_->_tmp110_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
			_data_->_tmp111_ = _data_->date;
			g_variant_dict_insert (_data_->_tmp110_, RYGEL_MEDIA_EXPORT_SERIALIZER_DATE, "s", _data_->_tmp111_, NULL);
		}
		_gst_date_time_unref0 (_data_->dt);
		_g_free0 (_data_->date);
		_g_free0 (_data_->title);
	}
	_data_->_tmp113_ = _data_->video_streams;
	if (_data_->_tmp113_ != NULL) {
		_data_->_tmp114_ = _data_->video_streams;
		_data_->_tmp115_ = _data_->_tmp114_->data;
		_data_->_tmp112_ = ((GstDiscovererVideoInfo*) _data_->_tmp115_) != NULL;
	} else {
		_data_->_tmp112_ = FALSE;
	}
	if (_data_->_tmp112_) {
		_data_->_tmp116_ = _data_->video_streams;
		_data_->_tmp117_ = _data_->_tmp116_->data;
		_data_->_tmp118_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((GstDiscovererVideoInfo*) _data_->_tmp117_, gst_discoverer_video_info_get_type (), GstDiscovererVideoInfo));
		_data_->vinfo = _data_->_tmp118_;
		_data_->_tmp119_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp120_ = _data_->vinfo;
		g_variant_dict_insert (_data_->_tmp119_, RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_WIDTH, "i", (gint) gst_discoverer_video_info_get_width (_data_->_tmp120_), NULL);
		_data_->_tmp121_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp122_ = _data_->vinfo;
		g_variant_dict_insert (_data_->_tmp121_, RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_HEIGHT, "i", (gint) gst_discoverer_video_info_get_height (_data_->_tmp122_), NULL);
		_data_->_tmp124_ = _data_->vinfo;
		if (gst_discoverer_video_info_get_depth (_data_->_tmp124_) > ((guint) 0)) {
			_data_->_tmp125_ = _data_->vinfo;
			_data_->_tmp123_ = gst_discoverer_video_info_get_depth (_data_->_tmp125_);
		} else {
			_data_->_tmp123_ = (guint) -1;
		}
		_data_->_tmp126_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		g_variant_dict_insert (_data_->_tmp126_, RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_DEPTH, "i", _data_->_tmp123_, NULL);
		_g_object_unref0 (_data_->vinfo);
	}
	_data_->_tmp128_ = _data_->audio_streams;
	if (_data_->_tmp128_ != NULL) {
		_data_->_tmp129_ = _data_->audio_streams;
		_data_->_tmp130_ = _data_->_tmp129_->data;
		_data_->_tmp127_ = ((GstDiscovererAudioInfo*) _data_->_tmp130_) != NULL;
	} else {
		_data_->_tmp127_ = FALSE;
	}
	if (_data_->_tmp127_) {
		_data_->_tmp131_ = _data_->audio_streams;
		_data_->_tmp132_ = _data_->_tmp131_->data;
		_data_->_tmp133_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((GstDiscovererAudioInfo*) _data_->_tmp132_, gst_discoverer_audio_info_get_type (), GstDiscovererAudioInfo));
		_data_->ainfo = _data_->_tmp133_;
		_data_->_tmp134_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp135_ = _data_->ainfo;
		g_variant_dict_insert (_data_->_tmp134_, RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_CHANNELS, "i", (gint) gst_discoverer_audio_info_get_channels (_data_->_tmp135_), NULL);
		_data_->_tmp136_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp137_ = _data_->ainfo;
		g_variant_dict_insert (_data_->_tmp136_, RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_RATE, "i", (gint) gst_discoverer_audio_info_get_sample_rate (_data_->_tmp137_), NULL);
		_data_->_tmp138_ = _data_->ainfo;
		_data_->_tmp139_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _data_->_tmp138_);
		_data_->_tmp140_ = _gst_tag_list_ref0 (_data_->_tmp139_);
		_data_->atags = _data_->_tmp140_;
		_data_->_tmp141_ = _data_->atags;
		if (_data_->_tmp141_ != NULL) {
			_data_->artist = NULL;
			_data_->_tmp143_ = _data_->atags;
			_data_->_tmp144_ = NULL;
			_data_->_tmp145_ = gst_tag_list_get_string (_data_->_tmp143_, GST_TAG_ARTIST, &_data_->_tmp144_);
			_g_free0 (_data_->artist);
			_data_->artist = _data_->_tmp144_;
			if (_data_->_tmp145_) {
				_data_->_tmp146_ = _data_->self->priv->mime_type;
				_data_->_tmp142_ = g_strcmp0 (_data_->_tmp146_, "video/x-msvideo") != 0;
			} else {
				_data_->_tmp142_ = FALSE;
			}
			if (_data_->_tmp142_) {
				_data_->_tmp147_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
				_data_->_tmp148_ = _data_->artist;
				g_variant_dict_insert (_data_->_tmp147_, RYGEL_MEDIA_EXPORT_SERIALIZER_ARTIST, "s", _data_->_tmp148_, NULL);
			}
			_data_->album = NULL;
			_data_->_tmp149_ = _data_->atags;
			_data_->_tmp150_ = NULL;
			_data_->_tmp151_ = gst_tag_list_get_string (_data_->_tmp149_, GST_TAG_ALBUM, &_data_->_tmp150_);
			_g_free0 (_data_->album);
			_data_->album = _data_->_tmp150_;
			if (_data_->_tmp151_) {
				_data_->_tmp152_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
				_data_->_tmp153_ = _data_->album;
				g_variant_dict_insert (_data_->_tmp152_, RYGEL_MEDIA_EXPORT_SERIALIZER_ALBUM, "s", _data_->_tmp153_, NULL);
			}
			_data_->genre = NULL;
			_data_->_tmp154_ = _data_->atags;
			_data_->_tmp155_ = NULL;
			_data_->_tmp156_ = gst_tag_list_get_string (_data_->_tmp154_, GST_TAG_GENRE, &_data_->_tmp155_);
			_g_free0 (_data_->genre);
			_data_->genre = _data_->_tmp155_;
			if (_data_->_tmp156_) {
				_data_->_tmp157_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
				_data_->_tmp158_ = _data_->genre;
				g_variant_dict_insert (_data_->_tmp157_, RYGEL_MEDIA_EXPORT_SERIALIZER_GENRE, "s", _data_->_tmp158_, NULL);
			}
			_data_->volume = G_MAXUINT;
			_data_->_tmp159_ = _data_->atags;
			_data_->_tmp160_ = 0U;
			_data_->_tmp161_ = gst_tag_list_get_uint (_data_->_tmp159_, GST_TAG_ALBUM_VOLUME_NUMBER, &_data_->_tmp160_);
			_data_->volume = _data_->_tmp160_;
			if (_data_->_tmp161_) {
				_data_->_tmp162_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
				_data_->_tmp163_ = _data_->volume;
				g_variant_dict_insert (_data_->_tmp162_, RYGEL_MEDIA_EXPORT_SERIALIZER_VOLUME_NUMBER, "i", _data_->_tmp163_, NULL);
			}
			_data_->track = G_MAXUINT;
			_data_->_tmp164_ = _data_->atags;
			_data_->_tmp165_ = 0U;
			_data_->_tmp166_ = gst_tag_list_get_uint (_data_->_tmp164_, GST_TAG_TRACK_NUMBER, &_data_->_tmp165_);
			_data_->track = _data_->_tmp165_;
			if (_data_->_tmp166_) {
				_data_->_tmp167_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
				_data_->_tmp168_ = _data_->track;
				g_variant_dict_insert (_data_->_tmp167_, RYGEL_MEDIA_EXPORT_SERIALIZER_TRACK_NUMBER, "i", _data_->_tmp168_, NULL);
			}
			_data_->bitrate = G_MAXUINT;
			_data_->_tmp169_ = _data_->atags;
			_data_->_tmp170_ = 0U;
			_data_->_tmp171_ = gst_tag_list_get_uint (_data_->_tmp169_, GST_TAG_BITRATE, &_data_->_tmp170_);
			_data_->bitrate = _data_->_tmp170_;
			if (_data_->_tmp171_) {
				_data_->_tmp172_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
				_data_->_tmp173_ = _data_->bitrate;
				g_variant_dict_insert (_data_->_tmp172_, RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_BITRATE, "i", ((gint) _data_->_tmp173_) / 8, NULL);
			}
			_data_->_tmp174_ = rygel_media_export_generic_extractor_media_art;
			if (_data_->_tmp174_ != NULL) {
				_data_->_tmp175_ = _data_->atags;
				_data_->_tmp176_ = NULL;
				gst_tag_list_get_sample (_data_->_tmp175_, GST_TAG_IMAGE, &_data_->_tmp176_);
				_gst_sample_unref0 (_data_->sample);
				_data_->sample = _data_->_tmp176_;
				_data_->_tmp177_ = _data_->sample;
				if (_data_->_tmp177_ == NULL) {
					_data_->_tmp178_ = _data_->atags;
					_data_->_tmp179_ = NULL;
					gst_tag_list_get_sample (_data_->_tmp178_, GST_TAG_PREVIEW_IMAGE, &_data_->_tmp179_);
					_gst_sample_unref0 (_data_->sample);
					_data_->sample = _data_->_tmp179_;
				}
				_data_->_tmp180_ = _data_->sample;
				if (_data_->_tmp180_ == NULL) {
					{
						_data_->_tmp182_ = _data_->artist;
						if (_data_->_tmp182_ != NULL) {
							_data_->_tmp181_ = TRUE;
						} else {
							_data_->_tmp183_ = _data_->album;
							_data_->_tmp181_ = _data_->_tmp183_ != NULL;
						}
						if (_data_->_tmp181_) {
							_data_->_tmp184_ = rygel_media_export_generic_extractor_media_art;
							_data_->_tmp185_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
							_data_->_tmp186_ = _data_->_tmp185_;
							_data_->_tmp187_ = _data_->artist;
							_data_->_tmp188_ = _data_->album;
							media_art_process_file (_data_->_tmp184_, MEDIA_ART_ALBUM, MEDIA_ART_PROCESS_FLAGS_NONE, _data_->_tmp186_, _data_->_tmp187_, _data_->_tmp188_, NULL, &_data_->_inner_error_);
							if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
								goto __catch9_g_error;
							}
						}
					}
					goto __finally9;
					__catch9_g_error:
					{
						_data_->_error_ = _data_->_inner_error_;
						_data_->_inner_error_ = NULL;
						_data_->_tmp189_ = _data_->_error_;
						_data_->_tmp190_ = _data_->_tmp189_->message;
						g_debug ("rygel-media-export-generic-extractor.vala:243: Failed to add external " \
"media art: %s", _data_->_tmp190_);
						_g_error_free0 (_data_->_error_);
					}
					__finally9:
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						_gst_sample_unref0 (_data_->sample);
						_g_free0 (_data_->genre);
						_g_free0 (_data_->album);
						_g_free0 (_data_->artist);
						_gst_tag_list_unref0 (_data_->atags);
						_g_object_unref0 (_data_->ainfo);
						_gst_tag_list_unref0 (_data_->tags);
						_g_object_unref0 (_data_->dlna);
						_g_object_unref0 (_data_->dlna_info);
						(_data_->video_streams == NULL) ? NULL : (_data_->video_streams = (_g_list_free__g_object_unref0_ (_data_->video_streams), NULL));
						(_data_->audio_streams == NULL) ? NULL : (_data_->audio_streams = (_g_list_free__g_object_unref0_ (_data_->audio_streams), NULL));
						_g_free0 (_data_->uri);
						_g_free0 (_data_->path);
						block1_data_unref (_data_->_data1_);
						_data_->_data1_ = NULL;
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				} else {
					_data_->_tmp191_ = _data_->sample;
					_data_->_tmp192_ = gst_sample_get_caps (_data_->_tmp191_);
					_data_->_tmp193_ = _gst_caps_ref0 (_data_->_tmp192_);
					_data_->caps = _data_->_tmp193_;
					_data_->_tmp194_ = _data_->caps;
					_data_->_tmp195_ = gst_caps_get_structure (_data_->_tmp194_, (guint) 0);
					_data_->structure = _data_->_tmp195_;
					_data_->_tmp196_ = _data_->structure;
					_data_->_tmp197_ = 0;
					gst_structure_get_enum (_data_->_tmp196_, "image-type", gst_tag_image_type_get_type (), &_data_->_tmp197_);
					_data_->image_type = _data_->_tmp197_;
					_data_->_tmp199_ = _data_->image_type;
					if (_data_->_tmp199_ == ((gint) GST_TAG_IMAGE_TYPE_UNDEFINED)) {
						_data_->_tmp198_ = TRUE;
					} else {
						_data_->_tmp200_ = _data_->image_type;
						_data_->_tmp198_ = _data_->_tmp200_ == ((gint) GST_TAG_IMAGE_TYPE_FRONT_COVER);
					}
					if (_data_->_tmp198_) {
						_data_->_tmp201_ = _data_->sample;
						_data_->_tmp202_ = gst_sample_get_buffer (_data_->_tmp201_);
						memset (&_data_->_tmp203_, 0, sizeof (GstMapInfo));
						gst_buffer_map (_data_->_tmp202_, &_data_->_tmp203_, GST_MAP_READ);
						_data_->map_info = _data_->_tmp203_;
						_data_->_tmp204_ = _data_->map_info;
						_data_->_tmp205_ = _data_->_tmp204_.data;
						_data_->_tmp205__length1 = (gint) _data_->_tmp204_.size;
						_data_->data = _data_->_tmp205_;
						_data_->data_length1 = _data_->_tmp205__length1;
						_data_->_data_size_ = _data_->data_length1;
						_data_->_tmp206_ = _data_->map_info;
						_data_->_tmp207_ = _data_->_tmp206_.size;
						_data_->data_length1 = (gint) _data_->_tmp207_;
						_data_->_tmp208_ = _data_->data_length1;
						{
							_data_->_tmp209_ = rygel_media_export_generic_extractor_media_art;
							_data_->_tmp210_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
							_data_->_tmp211_ = _data_->_tmp210_;
							_data_->_tmp212_ = _data_->data;
							_data_->_tmp212__length1 = _data_->data_length1;
							_data_->_tmp213_ = _data_->structure;
							_data_->_tmp214_ = gst_structure_get_name (_data_->_tmp213_);
							_data_->_tmp215_ = _data_->artist;
							_data_->_tmp216_ = _data_->album;
							media_art_process_buffer (_data_->_tmp209_, MEDIA_ART_ALBUM, MEDIA_ART_PROCESS_FLAGS_NONE, _data_->_tmp211_, _data_->_tmp212_, (gsize) _data_->_tmp212__length1, _data_->_tmp214_, _data_->_tmp215_, _data_->_tmp216_, NULL, &_data_->_inner_error_);
							if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
								goto __catch10_g_error;
							}
						}
						goto __finally10;
						__catch10_g_error:
						{
							_data_->_vala1__error_ = _data_->_inner_error_;
							_data_->_inner_error_ = NULL;
							_data_->_tmp217_ = _data_->_vala1__error_;
							_data_->_tmp218_ = _data_->_tmp217_->message;
							g_debug ("rygel-media-export-generic-extractor.vala:273: Failed to add media art" \
" to cache: %s", _data_->_tmp218_);
							_g_error_free0 (_data_->_vala1__error_);
						}
						__finally10:
						if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
							g_task_return_error (_data_->_async_result, _data_->_inner_error_);
							_gst_caps_unref0 (_data_->caps);
							_gst_sample_unref0 (_data_->sample);
							_g_free0 (_data_->genre);
							_g_free0 (_data_->album);
							_g_free0 (_data_->artist);
							_gst_tag_list_unref0 (_data_->atags);
							_g_object_unref0 (_data_->ainfo);
							_gst_tag_list_unref0 (_data_->tags);
							_g_object_unref0 (_data_->dlna);
							_g_object_unref0 (_data_->dlna_info);
							(_data_->video_streams == NULL) ? NULL : (_data_->video_streams = (_g_list_free__g_object_unref0_ (_data_->video_streams), NULL));
							(_data_->audio_streams == NULL) ? NULL : (_data_->audio_streams = (_g_list_free__g_object_unref0_ (_data_->audio_streams), NULL));
							_g_free0 (_data_->uri);
							_g_free0 (_data_->path);
							block1_data_unref (_data_->_data1_);
							_data_->_data1_ = NULL;
							g_object_unref (_data_->_async_result);
							return FALSE;
						}
						_data_->_tmp219_ = _data_->sample;
						_data_->_tmp220_ = gst_sample_get_buffer (_data_->_tmp219_);
						_data_->_tmp221_ = _data_->map_info;
						gst_buffer_unmap (_data_->_tmp220_, &_data_->_tmp221_);
					}
					_gst_caps_unref0 (_data_->caps);
				}
				_gst_sample_unref0 (_data_->sample);
			}
			_g_free0 (_data_->genre);
			_g_free0 (_data_->album);
			_g_free0 (_data_->artist);
		}
		_gst_tag_list_unref0 (_data_->atags);
		_g_object_unref0 (_data_->ainfo);
	}
	_gst_tag_list_unref0 (_data_->tags);
	_g_object_unref0 (_data_->dlna);
	_g_object_unref0 (_data_->dlna_info);
	(_data_->video_streams == NULL) ? NULL : (_data_->video_streams = (_g_list_free__g_object_unref0_ (_data_->video_streams), NULL));
	(_data_->audio_streams == NULL) ? NULL : (_data_->audio_streams = (_g_list_free__g_object_unref0_ (_data_->audio_streams), NULL));
	_g_free0 (_data_->uri);
	_g_free0 (_data_->path);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
rygel_media_export_generic_extractor_class_init (RygelMediaExportGenericExtractorClass * klass)
{
	GUPnPDLNAProfileGuesser* _tmp6_;
	GError * _inner_error_ = NULL;
	rygel_media_export_generic_extractor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportGenericExtractorPrivate));
	((RygelMediaExportExtractorClass *) klass)->run = (void (*) (RygelMediaExportExtractor *, GAsyncReadyCallback, gpointer)) rygel_media_export_generic_extractor_real_run;
	((RygelMediaExportExtractorClass *) klass)->run_finish = (void (*) (RygelMediaExportExtractor *, GAsyncResult*, GError**)) rygel_media_export_generic_extractor_real_run_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_generic_extractor_finalize;
	{
		GstDiscoverer* _tmp0_ = NULL;
		GstDiscoverer* _tmp1_;
		GstDiscoverer* _tmp2_;
		GstDiscoverer* _tmp3_;
		_tmp1_ = gst_discoverer_new ((GstClockTime) (10 * GST_SECOND), &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch11_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (rygel_media_export_generic_extractor_discoverer);
		rygel_media_export_generic_extractor_discoverer = _tmp2_;
		_tmp3_ = rygel_media_export_generic_extractor_discoverer;
		gst_discoverer_start (_tmp3_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		g_debug ("rygel-media-export-generic-extractor.vala:43: Generic extractor unavai" \
"lable: %s", _tmp5_);
		_g_error_free0 (_error_);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp6_ = gupnp_dlna_profile_guesser_new (TRUE, TRUE);
	_g_object_unref0 (rygel_media_export_generic_extractor_guesser);
	rygel_media_export_generic_extractor_guesser = _tmp6_;
	{
		MediaArtProcess* _tmp7_ = NULL;
		MediaArtProcess* _tmp8_;
		MediaArtProcess* _tmp9_;
		_tmp8_ = media_art_process_new (&_inner_error_);
		_tmp7_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch12_g_error;
		}
		_tmp9_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (rygel_media_export_generic_extractor_media_art);
		rygel_media_export_generic_extractor_media_art = _tmp9_;
		_g_object_unref0 (_tmp7_);
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = _error_;
		_tmp11_ = _tmp10_->message;
		g_warning (_ ("Failed to create media art extractor: %s"), _tmp11_);
		_g_error_free0 (_error_);
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
}


static void
rygel_media_export_generic_extractor_instance_init (RygelMediaExportGenericExtractor * self)
{
	self->priv = RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR_GET_PRIVATE (self);
}


static void
rygel_media_export_generic_extractor_finalize (GObject * obj)
{
	RygelMediaExportGenericExtractor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, RygelMediaExportGenericExtractor);
	_g_free0 (self->priv->upnp_class);
	_g_free0 (self->priv->mime_type);
	G_OBJECT_CLASS (rygel_media_export_generic_extractor_parent_class)->finalize (obj);
}


GType
rygel_media_export_generic_extractor_get_type (void)
{
	static volatile gsize rygel_media_export_generic_extractor_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_generic_extractor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportGenericExtractorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_generic_extractor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportGenericExtractor), 0, (GInstanceInitFunc) rygel_media_export_generic_extractor_instance_init, NULL };
		GType rygel_media_export_generic_extractor_type_id;
		rygel_media_export_generic_extractor_type_id = g_type_register_static (RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, "RygelMediaExportGenericExtractor", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_generic_extractor_type_id__volatile, rygel_media_export_generic_extractor_type_id);
	}
	return rygel_media_export_generic_extractor_type_id__volatile;
}



