// file automatically generated by: ../../../rheolef/nfem/gbasis/make_basis_list_cxx.sh
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/basis.h"
#include "basis_fem_Pk_lagrange.h"
#include "basis_fem_Pk_bernstein.h"
#include "basis_fem_Pk_sherwin.h"
#include "basis_fem_RTk.h"
#include "P0.h"
#include "P1.h"
#include "bubble.h"
#include "P1qd.h"
namespace rheolef {
using namespace std;

template<class T>
bool
basis_rep<T>::have_degree_parameter (std::string name) {
  if (name == "bubble") return false;
  if (name == "P1qd") return false;
  return true;
}
template<class T>
bool
basis_rep<T>::have_continuous_feature (std::string name) {
  if (name == "P0") return false;
  if (name == "bubble") return false;
  if (name == "P1qd") return false;
  return true;
}
template<class T>
basis_rep<T>*
basis_rep<T>::make_ptr (
    std::string              name,
    const basis_option& sopt)
{
  // TODO: how to a user's defined basis to the list ?
  // TODO: use gperf or hashtable instead of a long if-else test suite
  if (name == "") return 0;
  if (name == "P0") return new_macro(basis_P0<T>);
  if (name == "P1") return new_macro(basis_P1<T>(sopt));
  if (name == "bubble") return new_macro(basis_bubble<T>);
  if (name == "P1qd") return new_macro(basis_P1qd<T>);
  if (name[0] == 'P') return new_macro(basis_fem_Pk_lagrange<T>(name, sopt));
  if (name[0] == 'B') return new_macro(basis_fem_Pk_bernstein<T>(name, sopt));
  if (name[0] == 'S') return new_macro(basis_fem_Pk_sherwin<T>(name, sopt));
  if (name.length() >= 2 && name[0] == 'R' && name[1] == 'T')
                    return new_macro(basis_fem_RTk<T>(name, sopt));
  error_macro ("undefined basis `" << name << "'");
  return 0;
}
// instanciation in library:
template basis_rep<Float>* basis_rep<Float>::make_ptr (string, const basis_option&);
template bool              basis_rep<Float>::have_degree_parameter   (std::string family_name);
template bool              basis_rep<Float>::have_continuous_feature (std::string family_name);

} // namespace rheolef
