// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: OpenFOAMPluginInfo.C
// ****************************************************************************

#include <OpenFOAMPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(OpenFOAM,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(OpenFOAM,General)

// ****************************************************************************
//  Method: OpenFOAMGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
OpenFOAMGeneralPluginInfo::GetName() const
{
    return "OpenFOAM";
}

// ****************************************************************************
//  Method: OpenFOAMGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
OpenFOAMGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: OpenFOAMGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
OpenFOAMGeneralPluginInfo::GetID() const
{
    return "OpenFOAM_1.0";
}
// ****************************************************************************
//  Method: OpenFOAMGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
OpenFOAMGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: OpenFOAMGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
OpenFOAMGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  OpenFOAMGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a OpenFOAM database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
OpenFOAMGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("controlDict");
    defaultPatterns.push_back("*.foam");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  OpenFOAMGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a OpenFOAM database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
OpenFOAMGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return true;
}

// ****************************************************************************
//  Method:  OpenFOAMGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the OpenFOAM plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
OpenFOAMGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
