'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\"
.TH DS2740 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS2740
\- High-Precision Coulomb Counter
.SH SYNOPSIS
Voltage and Switch
.PP
.B 36
[.]XXXXXXXXXXXX[XX][/[
.B memory
|
.B PIO
|
.B sensed
|
.B vis
|
.B vis_B
|
.B volthours
|
.br
.B smod
|
.br
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I 36
.SH SPECIAL PROPERTIES
.SS memory
.I read-write, binary
.br
Access to the full 256 byte memory range. Much of this space is reserved or special use. User space is the
.I page
area.
.br
See the
.I DATASHEET
for a full memory map.
.SS PIO
.I write-only, yes-no
.br
Controls the PIO pin allowing external switching.
.br
Writing "1" turns the PIO pin on (conducting). Writing "0" makes the pin non-conducting.
The logical state of the voltage can be read with the
.I sensed
property. This will reflect the current voltage at the pin, not the value sent to
.I PIO
.br
Note also that
.I PIO
will also be altered by the power-status of the
.I DS2670
See the datasheet for details.
.SS sensed
.I read-only, yes-no
.br
The logical voltage at the PIO pin. Useful only if the
.I PIO
property is set to "0" (non-conducting).
.br
Value will be 0 or 1 depending on the voltage threshold.
.SS vis
.I read-only, floating point
.br
Current sensor reading (unknown external resistor). Measures the voltage gradient between the Vis pins. Units are in
.B Volts
.br
The
.I vis
readings are integrated over time to provide the
.I volthours
property.
.br
The
.I current
reading is derived from
.I vis
assuming the internal 25 mOhm resistor is employed. There is no way to know this through software.
.SS vis_B
.I read-only, floating point
.br
Current sensor reading (unknown external resistor). Measures the voltage gradient between the Vis pins. Units are in
.B Volts
.br
The
.I vis
readings are integrated over time to provide the
.I volthours
property.
.br
The
.I vis_B
is from a different tuning of the
.I DS2740 (3)
chip with faster sampling and lower resolution.
There is no way to know this through software.
.SS volthours
.I read-write, floating point
.br
Integral of
.I vis
over time. Units are in
.B volthours
.SH OBSCURE PROPERTIES
.SS smod
.I read-write, yes-no
.br
Bit flags corresponding to various battery management functions of the chip. See the 
.I DATASHEET
for details of the identically named entries.
.br
In general, writing "0" corresponds to a 0 bit value, and non-zero corresponds to a 1 bit value.
.br
Default power-on state for the corresponding properties.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None.
.SH DESCRIPTION
.so man3/description.3so
.SS DS2740
The
.B DS2740 (3)
is a class of battery charging controllers. This chip measures voltage and volthours, and has a pin that can be used for control.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS2740.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
