#include <stdio.h>
#include <stdlib.h>
#include <netcdf.h>

typedef struct compoundType_3 {
    double member3[1000];
} compoundType_3;


void
check_err(const int stat, const int line, const char *file) {
    if (stat != NC_NOERR) {
        (void)fprintf(stderr,"line %d of %s: %s\n", line, file, nc_strerror(stat));
        fflush(stderr);
        exit(1);
    }
}

int
main() {/* create aa.nc */

    int  stat;  /* return status */
    int  ncid;  /* netCDF id */

    /* group ids */
    int root_grp;

    /* type ids */
    int compoundType_3_typ;

    /* dimension ids */
    int dim3_dim;

    /* dimension lengths */
    size_t dim3_len = 2;

    /* variable ids */
    int var_3_id;

    /* rank (number of dimensions) for each variable */
#   define RANK_var_3 1

    /* variable shapes */
    int var_3_dims[RANK_var_3];

    /* enter define mode */
    stat = nc_create("aa.nc", NC_CLOBBER|NC_NETCDF4, &ncid);
    check_err(stat,__LINE__,__FILE__);
    root_grp = ncid;

    stat = nc_def_compound(root_grp, sizeof(compoundType_3), "compoundType_3", &compoundType_3_typ);
    check_err(stat,__LINE__,__FILE__);
    {
    static int member3_dims[1] = {1000};
    stat = nc_insert_array_compound(root_grp, compoundType_3_typ, "member3", NC_COMPOUND_OFFSET(compoundType_3,member3), NC_DOUBLE, 1, member3_dims);
    check_err(stat,__LINE__,__FILE__);
    }


    /* define dimensions */
    stat = nc_def_dim(root_grp, "dim3", dim3_len, &dim3_dim);
    check_err(stat,__LINE__,__FILE__);

    /* define variables */

    var_3_dims[0] = dim3_dim;
    stat = nc_def_var(root_grp, "var_3", compoundType_3_typ, RANK_var_3, var_3_dims, &var_3_id);
    check_err(stat,__LINE__,__FILE__);

    /* assign per-variable attributes */
    { /* _FillValue */
    static const compoundType_3 var_3__FillValue_att[1] = {{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}    stat = nc_put_att(root_grp, var_3_id, "_FillValue", compoundType_3_typ, 1, var_3__FillValue_att);
    check_err(stat,__LINE__,__FILE__);
    }


    /* leave define mode */
    stat = nc_enddef (root_grp);
    check_err(stat,__LINE__,__FILE__);

    /* assign variable data */
    {
    compoundType_3 var_3_data[1] = {{1, 2, 5, 10, 17, 26, 37, 50, 65, 82, 101, 122, 145, 170, 197, 226, 257, 290, 325, 362, 401, 442, 485, 530, 577, 626, 677, 730, 785, 842, 901, 962, 1025, 1090, 1157, 1226, 1297, 1370, 1445, 1522, 1601, 1682, 1765, 1850, 1937, 2026, 2117, 2210, 2305, 2402, 2501, 2602, 2705, 2810, 2917, 3026, 3137, 3250, 3365, 3482, 3601, 3722, 3845, 3970, 4097, 4226, 4357, 4490, 4625, 4762, 4901, 5042, 5185, 5330, 5477, 5626, 5777, 5930, 6085, 6242, 6401, 6562, 6725, 6890, 7057, 7226, 7397, 7570, 7745, 7922, 8101, 8282, 8465, 8650, 8837, 9026, 9217, 9410, 9605, 9802, 10001, 10202, 10405, 10610, 10817, 11026, 11237, 11450, 11665, 11882, 12101, 12322, 12545, 12770, 12997, 13226, 13457, 13690, 13925, 14162, 14401, 14642, 14885, 15130, 15377, 15626, 15877, 16130, 16385, 16642, 16901, 17162, 17425, 17690, 17957, 18226, 18497, 18770, 19045, 19322, 19601, 19882, 20165, 20450, 20737, 21026, 21317, 21610, 21905, 22202, 22501, 22802, 23105, 23410, 23717, 24026, 24337, 24650, 24965, 25282, 25601, 25922, 26245, 26570, 26897, 27226, 27557, 27890, 28225, 28562, 28901, 29242, 29585, 29930, 30277, 30626, 30977, 31330, 31685, 32042, 32401, 32762, 33125, 33490, 33857, 34226, 34597, 34970, 35345, 35722, 36101, 36482, 36865, 37250, 37637, 38026, 38417, 38810, 39205, 39602, 40001, 40402, 40805, 41210, 41617, 42026, 42437, 42850, 43265, 43682, 44101, 44522, 44945, 45370, 45797, 46226, 46657, 47090, 47525, 47962, 48401, 48842, 49285, 49730, 50177, 50626, 51077, 51530, 51985, 52442, 52901, 53362, 53825, 54290, 54757, 55226, 55697, 56170, 56645, 57122, 57601, 58082, 58565, 59050, 59537, 60026, 60517, 61010, 61505, 62002, 62501, 63002, 63505, 64010, 64517, 65026, 65537, 66050, 66565, 67082, 67601, 68122, 68645, 69170, 69697, 70226, 70757, 71290, 71825, 72362, 72901, 73442, 73985, 74530, 75077, 75626, 76177, 76730, 77285, 77842, 78401, 78962, 79525, 80090, 80657, 81226, 81797, 82370, 82945, 83522, 84101, 84682, 85265, 85850, 86437, 87026, 87617, 88210, 88805, 89402, 90001, 90602, 91205, 91810, 92417, 93026, 93637, 94250, 94865, 95482, 96101, 96722, 97345, 97970, 98597, 99226, 99857, 100490, 101125, 101762, 102401, 103042, 103685, 104330, 104977, 105626, 106277, 106930, 107585, 108242, 108901, 109562, 110225, 110890, 111557, 112226, 112897, 113570, 114245, 114922, 115601, 116282, 116965, 117650, 118337, 119026, 119717, 120410, 121105, 121802, 122501, 123202, 123905, 124610, 125317, 126026, 126737, 127450, 128165, 128882, 129601, 130322, 131045, 131770, 132497, 133226, 133957, 134690, 135425, 136162, 136901, 137642, 138385, 139130, 139877, 140626, 141377, 142130, 142885, 143642, 144401, 145162, 145925, 146690, 147457, 148226, 148997, 149770, 150545, 151322, 152101, 152882, 153665, 154450, 155237, 156026, 156817, 157610, 158405, 159202, 160001, 160802, 161605, 162410, 163217, 164026, 164837, 165650, 166465, 167282, 168101, 168922, 169745, 170570, 171397, 172226, 173057, 173890, 174725, 175562, 176401, 177242, 178085, 178930, 179777, 180626, 181477, 182330, 183185, 184042, 184901, 185762, 186625, 187490, 188357, 189226, 190097, 190970, 191845, 192722, 193601, 194482, 195365, 196250, 197137, 198026, 198917, 199810, 200705, 201602, 202501, 203402, 204305, 205210, 206117, 207026, 207937, 208850, 209765, 210682, 211601, 212522, 213445, 214370, 215297, 216226, 217157, 218090, 219025, 219962, 220901, 221842, 222785, 223730, 224677, 225626, 226577, 227530, 228485, 229442, 230401, 231362, 232325, 233290, 234257, 235226, 236197, 237170, 238145, 239122, 240101, 241082, 242065, 243050, 244037, 245026, 246017, 247010, 248005, 249002, 250001, 251002, 252005, 253010, 254017, 255026, 256037, 257050, 258065, 259082, 260101, 261122, 262145, 263170, 264197, 265226, 266257, 267290, 268325, 269362, 270401, 271442, 272485, 273530, 274577, 275626, 276677, 277730, 278785, 279842, 280901, 281962, 283025, 284090, 285157, 286226, 287297, 288370, 289445, 290522, 291601, 292682, 293765, 294850, 295937, 297026, 298117, 299210, 300305, 301402, 302501, 303602, 304705, 305810, 306917, 308026, 309137, 310250, 311365, 312482, 313601, 314722, 315845, 316970, 318097, 319226, 320357, 321490, 322625, 323762, 324901, 326042, 327185, 328330, 329477, 330626, 331777, 332930, 334085, 335242, 336401, 337562, 338725, 339890, 341057, 342226, 343397, 344570, 345745, 346922, 348101, 349282, 350465, 351650, 352837, 354026, 355217, 356410, 357605, 358802, 360001, 361202, 362405, 363610, 364817, 366026, 367237, 368450, 369665, 370882, 372101, 373322, 374545, 375770, 376997, 378226, 379457, 380690, 381925, 383162, 384401, 385642, 386885, 388130, 389377, 390626, 391877, 393130, 394385, 395642, 396901, 398162, 399425, 400690, 401957, 403226, 404497, 405770, 407045, 408322, 409601, 410882, 412165, 413450, 414737, 416026, 417317, 418610, 419905, 421202, 422501, 423802, 425105, 426410, 427717, 429026, 430337, 431650, 432965, 434282, 435601, 436922, 438245, 439570, 440897, 442226, 443557, 444890, 446225, 447562, 448901, 450242, 451585, 452930, 454277, 455626, 456977, 458330, 459685, 461042, 462401, 463762, 465125, 466490, 467857, 469226, 470597, 471970, 473345, 474722, 476101, 477482, 478865, 480250, 481637, 483026, 484417, 485810, 487205, 488602, 490001, 491402, 492805, 494210, 495617, 497026, 498437, 499850, 501265, 502682, 504101, 505522, 506945, 508370, 509797, 511226, 512657, 514090, 515525, 516962, 518401, 519842, 521285, 522730, 524177, 525626, 527077, 528530, 529985, 531442, 532901, 534362, 535825, 537290, 538757, 540226, 541697, 543170, 544645, 546122, 547601, 549082, 550565, 552050, 553537, 555026, 556517, 558010, 559505, 561002, 562501, 564002, 565505, 567010, 568517, 570026, 571537, 573050, 574565, 576082, 577601, 579122, 580645, 582170, 583697, 585226, 586757, 588290, 589825, 591362, 592901, 594442, 595985, 597530, 599077, 600626, 602177, 603730, 605285, 606842, 608401, 609962, 611525, 613090, 614657, 616226, 617797, 619370, 620945, 622522, 624101, 625682, 627265, 628850, 630437, 632026, 633617, 635210, 636805, 638402, 640001, 641602, 643205, 644810, 646417, 648026, 649637, 651250, 652865, 654482, 656101, 657722, 659345, 660970, 662597, 664226, 665857, 667490, 669125, 670762, 672401, 674042, 675685, 677330, 678977, 680626, 682277, 683930, 685585, 687242, 688901, 690562, 692225, 693890, 695557, 697226, 698897, 700570, 702245, 703922, 705601, 707282, 708965, 710650, 712337, 714026, 715717, 717410, 719105, 720802, 722501, 724202, 725905, 727610, 729317, 731026, 732737, 734450, 736165, 737882, 739601, 741322, 743045, 744770, 746497, 748226, 749957, 751690, 753425, 755162, 756901, 758642, 760385, 762130, 763877, 765626, 767377, 769130, 770885, 772642, 774401, 776162, 777925, 779690, 781457, 783226, 784997, 786770, 788545, 790322, 792101, 793882, 795665, 797450, 799237, 801026, 802817, 804610, 806405, 808202, 810001, 811802, 813605, 815410, 817217, 819026, 820837, 822650, 824465, 826282, 828101, 829922, 831745, 833570, 835397, 837226, 839057, 840890, 842725, 844562, 846401, 848242, 850085, 851930, 853777, 855626, 857477, 859330, 861185, 863042, 864901, 866762, 868625, 870490, 872357, 874226, 876097, 877970, 879845, 881722, 883601, 885482, 887365, 889250, 891137, 893026, 894917, 896810, 898705, 900602, 902501, 904402, 906305, 908210, 910117, 912026, 913937, 915850, 917765, 919682, 921601, 923522, 925445, 927370, 929297, 931226, 933157, 935090, 937025, 938962, 940901, 942842, 944785, 946730, 948677, 950626, 952577, 954530, 956485, 958442, 960401, 962362, 964325, 966290, 968257, 970226, 972197, 974170, 976145, 978122, 980101, 982082, 984065, 986050, 988037, 990026, 992017, 994010, 996005, 998002}} ;
    size_t var_3_startset[1] = {0} ;
    size_t var_3_countset[1] = {1} ;
    stat = nc_put_vara(root_grp, var_3_id, var_3_startset, var_3_countset, var_3_data);
    check_err(stat,__LINE__,__FILE__);
    }
    {
    compoundType_3 var_3_data[1] = {{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}} ;
    size_t var_3_startset[1] = {1} ;
    size_t var_3_countset[1] = {1} ;
    stat = nc_put_vara(root_grp, var_3_id, var_3_startset, var_3_countset, var_3_data);
    check_err(stat,__LINE__,__FILE__);
    }

    stat = nc_close(root_grp);
    check_err(stat,__LINE__,__FILE__);
    return 0;
}
