/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2017 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * benesiPwr2 mandelbulb
 * @reference
 * http://www.fractalforums.com/new-theories-and-research/
 * do-m3d-formula-have-to-be-distance-estimation-formulas/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "BenesiPwr2MandelbulbIteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 BenesiPwr2MandelbulbIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 c = aux->const_c;

	{
		REAL4 gap = fractal->transformCommon.constantMultiplier000;
		REAL t;
		REAL dot1;

		if (fractal->transformCommon.functionEnabledPFalse
				&& aux->i >= fractal->transformCommon.startIterationsP
				&& aux->i < fractal->transformCommon.stopIterationsP1)
		{
			z.y = fabs(z.y);
			z.z = fabs(z.z);
			dot1 = (mad(z.x, -SQRT_3_4, z.y * 0.5f)) * fractal->transformCommon.scale;
			t = max(0.0f, dot1);
			z.x -= t * -SQRT_3;
			z.y = fabs(z.y - t);

			if (z.y > z.z)
			{
				REAL temp = z.y;
				z.y = z.z;
				z.z = temp;
			}
			z -= gap * (REAL4){SQRT_3_4, 1.5f, 1.5f, 0.0f};

			if (z.z > z.x)
			{
				REAL temp = z.z;
				z.z = z.x;
				z.x = temp;
			}
			if (z.x > 0.0f)
			{
				z.y = max(0.0f, z.y);
				z.z = max(0.0f, z.z);
			}
		}
	}

	if (fractal->transformCommon.benesiT1Enabled && aux->i >= fractal->transformCommon.startIterations
			&& aux->i < fractal->transformCommon.stopIterations)
	{
		REAL tempXZ = mad(z.x, SQRT_2_3, -z.z * SQRT_1_3);
		z = (REAL4){
			(tempXZ - z.y) * SQRT_1_2, (tempXZ + z.y) * SQRT_1_2, z.x * SQRT_1_3 + z.z * SQRT_2_3, z.w};

		REAL4 temp = z;
		REAL tempL = length(temp);
		z = fabs(z) * fractal->transformCommon.scale3D222;
		// if (tempL < 1e-21f) tempL = 1e-21f;
		REAL avgScale = native_divide(length(z), tempL);
		aux->r_dz *= avgScale;
		aux->DE = mad(aux->DE, avgScale, 1.0f);

		if (fractal->transformCommon.rotationEnabled)
		{ // rotation inside T1
			z = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix, z);
		}

		tempXZ = (z.y + z.x) * SQRT_1_2;

		z = (REAL4){z.z * SQRT_1_3 + tempXZ * SQRT_2_3, (z.y - z.x) * SQRT_1_2,
			z.z * SQRT_2_3 - tempXZ * SQRT_1_3, z.w};
		z = z - fractal->transformCommon.offset200;
	}

	if (fractal->transformCommon.addCpixelEnabled
			&& aux->i >= fractal->transformCommon.startIterationsF
			&& aux->i < fractal->transformCommon.stopIterationsF)
	{											// Benesi original pwr2
		aux->r = length(z); // needed when alternating pwr2s
		aux->r_dz = aux->r_dz * 2.0f * aux->r;
		REAL r1 = mad(z.y, z.y, z.z * z.z);
		REAL4 newZ = (REAL4){0.0f, 0.0f, 0.0f, z.w};
		if (c.x < 0.0f || z.x < native_sqrt(r1))
		{
			newZ.x = mad(z.x, z.x, -r1);
		}
		else
		{
			newZ.x = mad(-z.x, z.x, r1);
		}
		r1 = -native_rsqrt(r1) * 2.0f * fabs(z.x);
		newZ.y = r1 * (mad(z.y, z.y, -z.z * z.z));
		newZ.z = r1 * 2.0f * z.y * z.z;
		z = newZ + (c * fractal->transformCommon.constantMultiplierA100);
	}

	if (fractal->transformCommon.addCpixelEnabledFalse
			&& aux->i >= fractal->transformCommon.startIterationsC
			&& aux->i < fractal->transformCommon.stopIterationsC)
	{ // pine tree
		REAL4 temp = z;
		aux->r = length(z); // needed when alternating pwr2s
		z *= z;
		REAL t = 2.0f * temp.x;
		if (z.y + z.z > 0.0f)
			t = native_divide(t, native_sqrt(z.y + z.z));
		else
			t = 1.0f;
		REAL4 tempC = c;
		if (fractal->transformCommon.alternateEnabledFalse) // alternate
		{
			tempC = aux->c;
			tempC = (REAL4){tempC.x, tempC.z, tempC.y, tempC.w};
			aux->c = tempC;
		}
		else
		{
			tempC = (REAL4){c.x, c.z, c.y, c.w};
		}
		z.x = mad(fractal->transformCommon.constantMultiplier100.x, tempC.x, (z.x - z.y - z.z));
		z.z = mad(fractal->transformCommon.constantMultiplier100.y, tempC.z, (t * (z.y - z.z)));
		z.y =
			mad(fractal->transformCommon.constantMultiplier100.z, tempC.y, (2.0f * t * temp.y * temp.z));
		aux->r_dz = mad(aux->r * aux->r_dz, 2.0f, 1.0f);
	}

	if (fractal->transformCommon.functionEnabledBxFalse
			&& aux->i >= fractal->transformCommon.startIterationsD
			&& aux->i < fractal->transformCommon.stopIterationsD)
	{
		z = (REAL4){z.x * native_cos(z.y * fractal->transformCommon.scale1),
					z.x * native_sin(z.y * fractal->transformCommon.scale1),
					z.z * fractal->transformCommon.scaleC1, z.w}
				* fractal->transformCommon.scaleA1;
		aux->r_dz *= fabs(fractal->transformCommon.scaleA1);
	}

	if (fractal->transformCommon.juliaMode)
	{
		z.x += fractal->transformCommon.offset000.x;
		z.y += fractal->transformCommon.offset000.y;
		z.z += fractal->transformCommon.offset000.z;
	}
	return z;
}