/* print-errors.c --- Print error codes.
 * Copyright (C) 2002-2021 Simon Josefsson
 *
 * This file is part of GNU SASL.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>

#include <gsasl.h>

int
main (void)
{
  const char *this = NULL, *last = NULL;
  const char *name;
  size_t i = 0;

  printf ("@c This file is automatically generated.  DO NOT EDIT!\n");
  printf ("@c Instead, edit print-errors.c and re-run.\n");

  do
    {
      last = this;

      this = gsasl_strerror (i);
      name = gsasl_strerror_name (i);

      if (name != NULL)
	printf ("\n@item @code{%s}\n%s\n", name, this);

      if (this == NULL)
	return EXIT_FAILURE;

      i++;
    }
  while (this != last);

  return EXIT_SUCCESS;
}
